/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.dns;

import java.io.Serializable;

public class Name
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MAX_LABEL_SIZE = 63;
    public static final int MAX_NAME_SIZE = 255;
    public static final Name EMPTY_NAME = new Name("");
    private String _label;
    private Name _child;

    public Name(String name) {
        if (name.length() > 255) {
            throw new IllegalArgumentException("Name: " + name + " is too long");
        }
        int index = name.indexOf(".");
        if (index != -1) {
            this._label = name.substring(0, index);
            this._child = new Name(name.substring(index + 1));
        } else {
            this._label = name;
        }
        if (this._label.length() > 63) {
            throw new IllegalArgumentException("Label: " + this._label + " is too long");
        }
    }

    public void append(Name suffix) {
        Name name = this;
        while (name.hasChild()) {
            name = name.getChild();
        }
        name.setChild(suffix);
    }

    public Name getChild() {
        return this._child;
    }

    public void setChild(Name name) {
        if (this._child != null) {
            throw new IllegalStateException("Child already set");
        }
        this._child = name;
    }

    public String getLabel() {
        return this._label;
    }

    public boolean hasChild() {
        return this._child != null;
    }

    public String toString() {
        if (this.hasChild()) {
            return this._label + "." + this._child.toString();
        }
        return this._label;
    }

    public int hashCode() {
        return this.toString().toLowerCase().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Name)) {
            return false;
        }
        Name name = (Name)o;
        if (!this._label.equalsIgnoreCase(name.getLabel())) {
            return false;
        }
        if (this.hasChild()) {
            return name.hasChild() && this._child.equals(name.getChild());
        }
        return !name.hasChild();
    }

    public Name clone() {
        Name name;
        try {
            name = (Name)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException();
        }
        name._child = null;
        if (this._child != null) {
            name.setChild(this._child.clone());
        }
        return name;
    }
}

