/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.dns;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.List;
import org.cipango.dns.DnsClient;
import org.cipango.dns.DnsMessage;
import org.cipango.dns.Name;
import org.cipango.dns.Type;
import org.cipango.dns.record.CnameRecord;
import org.cipango.dns.record.Record;
import org.cipango.dns.section.HeaderSection;

public class Lookup {
    private Record _record;
    private Name _toSearch;
    private DnsClient _dnsClient;
    private int _iterations = 0;

    public Lookup(DnsClient client, Record record) {
        this._dnsClient = client;
        this._record = record;
    }

    public List<Record> resolve() throws IOException, UnknownHostException {
        IOException e = null;
        try {
            return this.resolve(this._record);
        }
        catch (IOException e1) {
            e = e1;
            if (this._dnsClient.getSearchList() != null) {
                for (Name suffix : this._dnsClient.getSearchList()) {
                    Record record = this._record.getType().newRecord();
                    Name newName = this._record.getName().clone();
                    newName.append(suffix);
                    record.setName(newName);
                    record.setDnsClass(this._record.getDnsClass());
                    try {
                        return this.resolve(record);
                    }
                    catch (IOException e2) {
                    }
                }
            }
            throw e;
        }
    }

    public List<Record> resolve(Record record) throws IOException, UnknownHostException {
        this._toSearch = null;
        List<Record> records = this.getFromCache(record);
        while (records.isEmpty()) {
            if (this._toSearch != null) {
                record = record.getType().newRecord();
                record.setName(this._toSearch);
                record.setDnsClass(this._record.getDnsClass());
            }
            DnsMessage query = new DnsMessage(record);
            DnsMessage answer = this._dnsClient.resolve(query);
            this.incrementIteration();
            HeaderSection.ResponseCode responseCode = answer.getHeaderSection().getResponseCode();
            if (responseCode == HeaderSection.ResponseCode.NAME_ERROR) {
                this._dnsClient.getCache().addNegativeRecord(query, answer);
                throw new UnknownHostException(this._record.getName().toString());
            }
            if (responseCode != HeaderSection.ResponseCode.NO_ERROR) {
                throw new IOException("Got negative answer: " + (Object)((Object)answer.getHeaderSection().getResponseCode()));
            }
            if (answer.getAnswerSection().isEmpty()) {
                throw new UnknownHostException(this._record.getName().toString());
            }
            this._dnsClient.getCache().addRecordSet(query, answer);
            records = this.getFromCache(record);
        }
        return records;
    }

    private List<Record> getFromCache(Record record) throws IOException {
        List<Record> records = this._dnsClient.getCache().getRecords(record.getName(), record.getType());
        while (records.size() == 1 && records.get(0).getType() == Type.CNAME && record.getType() != Type.CNAME) {
            this.incrementIteration();
            this._toSearch = ((CnameRecord)records.get(0)).getCname();
            records = this._dnsClient.getCache().getRecords(this._toSearch, record.getType());
        }
        return records;
    }

    private void incrementIteration() throws IOException {
        ++this._iterations;
        if (this._iterations > 12) {
            throw new IOException("Name " + this._record.getName() + " Looped");
        }
    }
}

