/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.dns;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.cipango.dns.Cache;
import org.cipango.dns.DnsClient;
import org.cipango.dns.DnsConnector;
import org.cipango.dns.DnsMessage;
import org.cipango.dns.Lookup;
import org.cipango.dns.Name;
import org.cipango.dns.Resolver;
import org.cipango.dns.bio.TcpConnector;
import org.cipango.dns.bio.UdpConnector;
import org.cipango.dns.record.ARecord;
import org.cipango.dns.record.AaaaRecord;
import org.cipango.dns.record.PtrRecord;
import org.cipango.dns.record.Record;
import org.cipango.util.StringScanner;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import sun.net.dns.ResolverConfiguration;

@ManagedObject(value="DNS Service")
public class DnsService
extends ContainerLifeCycle
implements DnsClient {
    private static final Logger LOG = Log.getLogger(DnsService.class);
    private Cache _cache;
    private Name[] _searchList;
    private Resolver[] _resolvers;
    private DnsConnector[] _connectors;
    private DnsConnector _tcpConnector;
    private boolean _preferIpv6 = false;
    private Map<Name, InetAddress[]> _staticHostsByName = new HashMap<Name, InetAddress[]>();
    private Map<Name, String> _staticHostsByAddr = new HashMap<Name, String>();
    private Executor _executor;

    protected void doStart() throws Exception {
        ResolverConfiguration resolverConfiguration;
        if (this._executor == null) {
            QueuedThreadPool executor = new QueuedThreadPool(10, 1, 2000);
            executor.setName("qtp-dns");
            executor.setMinThreads(1);
            executor.setDaemon(true);
            this.setExecutor((Executor)executor);
        }
        if (this._resolvers == null || this._resolvers.length == 0) {
            resolverConfiguration = ResolverConfiguration.open();
            List<String> servers = resolverConfiguration.nameservers();
            int attempts = resolverConfiguration.options().attempts();
            int retrans = resolverConfiguration.options().retrans();
            for (String server : servers) {
                Resolver resolver = new Resolver();
                resolver.setHost(server);
                if (attempts != -1) {
                    resolver.setAttempts(attempts);
                }
                if (retrans != -1) {
                    resolver.setTimeout(retrans);
                }
                this.addResolver(resolver);
            }
        }
        if (this._connectors == null || this._connectors.length == 0) {
            this.setConnectors(new DnsConnector[]{new UdpConnector(), new TcpConnector()});
        }
        for (DnsConnector connector : this._connectors) {
            if (connector.getExecutor() != null) continue;
            connector.setExecutor(this._executor);
        }
        if (this._searchList == null) {
            resolverConfiguration = ResolverConfiguration.open();
            ArrayList<Name> searchList = new ArrayList<Name>();
            for (String name : resolverConfiguration.searchlist()) {
                searchList.add(new Name(name));
            }
            this._searchList = searchList.toArray(new Name[searchList.size()]);
        }
        if (this._cache == null) {
            this.setCache(new Cache());
        }
        this.addEtcHosts();
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this._connectors != null) {
            for (int i = 0; i < this._connectors.length; ++i) {
                if (!(this._connectors[i] instanceof LifeCycle)) continue;
                ((LifeCycle)this._connectors[i]).stop();
            }
        }
        super.doStop();
    }

    public InetAddress[] lookupAllHostAddr(String host) throws UnknownHostException {
        try {
            Name name = new Name(host);
            InetAddress[] array = this._staticHostsByName.get(name);
            if (array != null) {
                return array;
            }
            List<Record> records = null;
            try {
                records = this.lookup(this._preferIpv6 ? new AaaaRecord(name) : new ARecord(name));
            }
            catch (IOException e) {
                try {
                    records = this.lookup(this._preferIpv6 ? new ARecord(name) : new AaaaRecord(name));
                }
                catch (UnknownHostException e2) {
                    throw e2;
                }
                catch (Exception e2) {
                    UnknownHostException e3 = new UnknownHostException(host);
                    e3.initCause(e2);
                    throw e3;
                }
            }
            array = new InetAddress[records.size()];
            for (int i = 0; i < records.size(); ++i) {
                if (records.get(i) instanceof ARecord) {
                    ARecord a = (ARecord)records.get(i);
                    array[i] = a.getAddress();
                    continue;
                }
                AaaaRecord aaaa = (AaaaRecord)records.get(i);
                array[i] = aaaa.getAddress();
            }
            return array;
        }
        catch (Exception e) {
            if (e instanceof UnknownHostException) {
                throw (UnknownHostException)e;
            }
            LOG.debug((Throwable)e);
            throw new UnknownHostException(host);
        }
    }

    public String getHostByAddr(byte[] addr) throws UnknownHostException {
        try {
            Name name = PtrRecord.getReverseName(InetAddress.getByAddress(addr));
            String reverse = this._staticHostsByAddr.get(name);
            if (reverse != null) {
                return reverse;
            }
            PtrRecord ptrRecord = new PtrRecord(name);
            List<Record> records = new Lookup(this, ptrRecord).resolve();
            PtrRecord result = (PtrRecord)records.get(0);
            return result.getPrtdName().toString();
        }
        catch (IOException e) {
            if (e instanceof UnknownHostException) {
                throw (UnknownHostException)e;
            }
            LOG.debug((Throwable)e);
            throw new UnknownHostException();
        }
    }

    public List<Record> lookup(Record record) throws IOException {
        return new Lookup(this, record).resolve();
    }

    @Override
    @ManagedAttribute(value="Cache", readonly=true)
    public Cache getCache() {
        return this._cache;
    }

    public void setCache(Cache cache) {
        this.updateBean(this._cache, cache);
        this._cache = cache;
    }

    @Override
    @ManagedAttribute(value="Search list")
    public Name[] getSearchList() {
        return this._searchList;
    }

    public void setSearchList(Name[] searchList) {
        this._searchList = searchList;
    }

    @Override
    public DnsMessage resolve(DnsMessage query) throws IOException {
        IOException e = null;
        for (Resolver resolver : this._resolvers) {
            try {
                return resolver.resolve(query);
            }
            catch (IOException e1) {
                e = e1;
            }
        }
        if (e == null) {
            throw new IOException("No resovler");
        }
        throw e;
    }

    public void addResolver(Resolver resolver) {
        this.setResolvers((Resolver[])ArrayUtil.addToArray((Object[])this.getResolvers(), (Object)resolver, Resolver.class));
    }

    public void addConnector(DnsConnector connector) {
        this.setConnectors((DnsConnector[])ArrayUtil.addToArray((Object[])this.getConnectors(), (Object)connector, DnsConnector.class));
    }

    @Override
    public DnsConnector getDefaultConnector() {
        if (this._connectors == null || this._connectors.length == 0) {
            return null;
        }
        return this._connectors[0];
    }

    @Override
    public DnsConnector getTcpConnector() {
        return this._tcpConnector;
    }

    @Override
    @ManagedAttribute(value="Resolvers", readonly=true)
    public Resolver[] getResolvers() {
        return this._resolvers;
    }

    @Override
    @ManagedAttribute(value="Connectors", readonly=true)
    public DnsConnector[] getConnectors() {
        return this._connectors;
    }

    public void setConnectors(DnsConnector[] connectors) {
        this.updateBeans(this._connectors, connectors);
        this._tcpConnector = null;
        if (connectors != null) {
            for (int i = 0; i < connectors.length; ++i) {
                if (connectors[i].getExecutor() == null) {
                    connectors[i].setExecutor(this._executor);
                }
                if (!connectors[i].isTcp()) continue;
                this._tcpConnector = connectors[i];
                break;
            }
        }
        this._connectors = connectors;
    }

    public void setResolvers(Resolver[] resolvers) {
        this.updateBeans(this._resolvers, resolvers);
        if (resolvers != null) {
            for (int i = 0; i < resolvers.length; ++i) {
                resolvers[i].setDnsClient(this);
            }
        }
        this._resolvers = resolvers;
    }

    protected void addEtcHosts() {
        try {
            String os = System.getProperty("os.name");
            File file = os.startsWith("Windows") ? new File("C:/WINDOWS/system32/drivers/etc/hosts") : new File("/etc/hosts");
            if (!(file.exists() && file.isFile() && file.canRead())) {
                LOG.warn("Unable to read " + file.getAbsolutePath(), new Object[0]);
                return;
            }
            LOG.debug("Read hosts file: " + file.getAbsolutePath(), new Object[0]);
            this.addEtcHosts(new FileInputStream(file));
        }
        catch (Exception e) {
            LOG.warn("Parse error in hosts file", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEtcHosts(InputStream is) {
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                try {
                    if (line.indexOf(35) != -1) {
                        line = line.substring(0, line.indexOf(35));
                    }
                    StringScanner scanner = new StringScanner(line);
                    scanner.skipWhitespace();
                    if (scanner.eof()) continue;
                    String addr = scanner.readToSpace();
                    InetAddress ip = InetAddress.getByName(addr);
                    scanner.skipWhitespace();
                    boolean first = true;
                    while (!scanner.eof()) {
                        String host = scanner.readToSpace();
                        scanner.skipWhitespace();
                        LOG.debug("Assign host " + host + " to IP address " + ip + " from hosts file", new Object[0]);
                        this._staticHostsByName.put(new Name(host), new InetAddress[]{ip});
                        if (!first) continue;
                        this._staticHostsByAddr.put(PtrRecord.getReverseName(ip), host);
                        first = false;
                    }
                }
                catch (Exception e) {
                    LOG.warn("Error in parsing of etc host file", (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            LOG.warn("Parse error in hosts file", (Throwable)e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    LOG.debug("", (Throwable)e);
                }
            }
        }
    }

    @ManagedAttribute(value="Prefer IPv6")
    public boolean isPreferIpv6() {
        return this._preferIpv6;
    }

    public void setPreferIpv6(boolean preferIpv6) {
        this._preferIpv6 = preferIpv6;
    }

    public Executor getExecutor() {
        return this._executor;
    }

    public void setExecutor(Executor executor) {
        this.updateBean(this._executor, executor);
        this._executor = executor;
    }
}

