/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.dns;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import org.cipango.dns.Compression;
import org.cipango.dns.record.OptRecord;
import org.cipango.dns.record.Record;
import org.cipango.dns.section.HeaderSection;
import org.cipango.dns.section.QuestionSection;
import org.cipango.dns.section.ResourceRecordsSection;

public class DnsMessage {
    private HeaderSection _headerSection = new HeaderSection(this);
    private QuestionSection _questionSection = new QuestionSection(this);
    private ResourceRecordsSection _answerSection = new ResourceRecordsSection(this);
    private ResourceRecordsSection _authoritySection = new ResourceRecordsSection(this);
    private ResourceRecordsSection _additionalSection = new ResourceRecordsSection(this);
    private Compression _compression = new Compression();

    public DnsMessage() {
    }

    public DnsMessage(Record record) {
        this._headerSection.setId(ThreadLocalRandom.current().nextInt() & 0xFFFF);
        this._headerSection.setOpCode(HeaderSection.OpCode.QUERY);
        this._questionSection.add(record);
    }

    public void encode(ByteBuffer buffer) throws IOException {
        this.getCompression().clear();
        this._headerSection.encode(buffer);
        this._questionSection.encode(buffer);
        this._answerSection.encode(buffer);
        this._authoritySection.encode(buffer);
        this._additionalSection.encode(buffer);
    }

    public void decode(ByteBuffer buffer) throws IOException {
        this.getCompression().clear();
        this._headerSection.decode(buffer);
        this._questionSection.decode(buffer);
        this._answerSection.decode(buffer, this._headerSection.getAnswerRecords());
        this._authoritySection.decode(buffer, this._headerSection.getAuthorityRecords());
        this._additionalSection.decode(buffer, this._headerSection.getAdditionalRecords());
    }

    public Compression getCompression() {
        return this._compression;
    }

    public HeaderSection getHeaderSection() {
        return this._headerSection;
    }

    public QuestionSection getQuestionSection() {
        return this._questionSection;
    }

    public ResourceRecordsSection getAnswerSection() {
        return this._answerSection;
    }

    public ResourceRecordsSection getAuthoritySection() {
        return this._authoritySection;
    }

    public ResourceRecordsSection getAdditionalSection() {
        return this._additionalSection;
    }

    public int getMaxUdpSize() {
        OptRecord record = this._additionalSection.get(OptRecord.class);
        if (record != null) {
            return record.getMaxPayloadSize();
        }
        return 512;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this._headerSection.append(sb);
        this._questionSection.append(sb);
        this._answerSection.append(sb, "Answers");
        this._authoritySection.append(sb, "Authority name servers");
        this._additionalSection.append(sb, "Additional records");
        return sb.toString();
    }
}

