/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.dns;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.cipango.dns.Name;

public class Compression {
    private Map<Name, Integer> _mapping = new HashMap<Name, Integer>();
    private Map<Integer, Name> _reverse = new HashMap<Integer, Name>();
    private static final int POINTER_PREFIX = 192;

    public void encodeName(Name name, ByteBuffer buffer) {
        this.encodeName(name, buffer, false);
    }

    public void encodeName(Name name, ByteBuffer buffer, boolean rdata) {
        while (name != null) {
            Integer index = this.getPosition(name);
            if (!rdata && index != null) {
                buffer.put((byte)(192 + (index >> 8) & 0xFF));
                buffer.put((byte)(index & 0xFF));
                return;
            }
            this.addName(name, buffer.position());
            buffer.put((byte)name.getLabel().length());
            buffer.put(name.getLabel().getBytes());
            name = name.getChild();
        }
        buffer.put((byte)0);
    }

    private void addName(Name name, int index) {
        this._mapping.put(name, index);
        this._reverse.put(index, name);
    }

    private Integer getPosition(Name name) {
        return this._mapping.get(name);
    }

    private Name getName(Integer position) {
        return this._reverse.get(position);
    }

    public void clear() {
        this._mapping.clear();
    }

    public Name decodeName(ByteBuffer buffer) {
        Name result;
        ArrayList<Name> names = new ArrayList<Name>();
        while (true) {
            int size;
            if ((size = buffer.get() & 0xFF) >= 192) {
                int index = (size - 192 & 0xFF) << 8 | buffer.get() & 0xFF;
                names.add(this.getName(index));
                break;
            }
            if (size == 0) break;
            int position = buffer.position() - 1;
            byte[] bName = new byte[size];
            buffer.get(bName);
            Name name = new Name(new String(bName));
            this.addName(name, position);
            names.add(name);
        }
        if (names.isEmpty()) {
            return Name.EMPTY_NAME;
        }
        Iterator it = names.iterator();
        Name name = result = (Name)it.next();
        while (it.hasNext()) {
            Name tmp = (Name)it.next();
            name.setChild(tmp);
            name = tmp;
        }
        return result;
    }
}

