/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.dns;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.cipango.dns.DnsMessage;
import org.cipango.dns.Name;
import org.cipango.dns.Type;
import org.cipango.dns.record.AdditionalName;
import org.cipango.dns.record.Record;
import org.cipango.dns.record.SoaRecord;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Cache")
public class Cache
implements Dumpable {
    public static final int DEFAULT_NEGATIVE_TTL = 3600;
    private static final Logger LOG = Log.getLogger(Cache.class);
    private ConcurrentMap<Name, RemovableList> _cache = new ConcurrentHashMap<Name, RemovableList>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecord(Record record) {
        RemovableList records = (RemovableList)this._cache.get(record.getName());
        if (records == null) {
            records = new RemovableList();
            RemovableList records2 = this._cache.putIfAbsent(record.getName(), records);
            if (records2 != null) {
                records = records2;
            }
        }
        RemovableList removableList = records;
        synchronized (removableList) {
            if (records.isRemoved()) {
                LOG.debug("Record list for {} as been removed, so reload list from cache", new Object[]{record.getName()});
                this.addRecord(record);
                return;
            }
            Iterator it = records.iterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                if (!element.get().equals(record)) continue;
                it.remove();
                records.add(new Element(record));
                LOG.debug("Update record {} on {} with {}", new Object[]{element, records, record});
                return;
            }
            LOG.debug("cache.add: {} on {}", new Object[]{record, records});
            records.add(new Element(record));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNegativeRecord(DnsMessage query, DnsMessage answer) {
        Record record = query.getQuestionSection().get(0);
        RemovableList records = (RemovableList)this._cache.get(record.getName());
        if (records == null) {
            records = new RemovableList();
            RemovableList records2 = this._cache.putIfAbsent(record.getName(), records);
            if (records2 != null) {
                records = records2;
            }
        }
        int ttl = 3600;
        for (Record record2 : answer.getAuthoritySection()) {
            if (!(record2 instanceof SoaRecord)) continue;
            ttl = ((SoaRecord)record2).getTtl();
        }
        LOG.debug("Negative cache.add: {} on {} with ttl {}", new Object[]{record, records, ttl});
        RemovableList removableList = records;
        synchronized (removableList) {
            records.add(new Element(record, ttl, true));
        }
    }

    public void addRecordSet(DnsMessage query, DnsMessage answer) {
        ArrayList<Name> toAdd = new ArrayList<Name>();
        for (Record record : query.getQuestionSection()) {
            toAdd.add(record.getName());
        }
        for (Record record : answer.getAnswerSection()) {
            if (!toAdd.contains(record.getName())) continue;
            this.addRecord(record);
            if (!(record instanceof AdditionalName)) continue;
            toAdd.add(((AdditionalName)((Object)record)).getAdditionalName());
        }
        for (Record record : answer.getAdditionalSection()) {
            if (!toAdd.contains(record.getName())) continue;
            this.addRecord(record);
            if (!(record instanceof AdditionalName)) continue;
            toAdd.add(((AdditionalName)((Object)record)).getAdditionalName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Record> getRecords(Name name, Type type) throws UnknownHostException {
        RemovableList records = (RemovableList)this._cache.get(name);
        if (records != null) {
            ArrayList<Record> list = new ArrayList<Record>();
            RemovableList removableList = records;
            synchronized (removableList) {
                Iterator it = records.iterator();
                while (it.hasNext()) {
                    Element element = (Element)it.next();
                    if (element.isExpired()) {
                        it.remove();
                        continue;
                    }
                    if (element.get().getType() == type) {
                        if (element.isNegative()) {
                            throw new UnknownHostException(name.toString());
                        }
                        list.add(element.get());
                        continue;
                    }
                    if (element.get().getType() != Type.CNAME) continue;
                    list.add(element.get());
                }
                if (records.isEmpty()) {
                    this._cache.remove(name, records);
                    records.setRemoved();
                }
            }
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    @ManagedOperation(value="Clear cache", impact="ACTION")
    public void clear() {
        this._cache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(value="Remove old entries from cache", impact="ACTION")
    public void scavenge() {
        for (Map.Entry entry : this._cache.entrySet()) {
            RemovableList records;
            RemovableList removableList = records = (RemovableList)entry.getValue();
            synchronized (removableList) {
                Iterator it = records.iterator();
                while (it.hasNext()) {
                    Element element = (Element)it.next();
                    if (!element.isExpired()) continue;
                    it.remove();
                }
                if (records.isEmpty()) {
                    this._cache.remove(entry.getKey(), records);
                    records.setRemoved();
                }
            }
        }
    }

    public String dump() {
        return ContainerLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        out.append("DNS cache").append('\n');
        for (Map.Entry entry : this._cache.entrySet()) {
            out.append(indent).append("  - ");
            out.append(((Name)entry.getKey()).toString()).append(": ").append(((RemovableList)entry.getValue()).toString()).append('\n');
        }
    }

    static class RemovableList
    extends ArrayList<Element> {
        private static final long serialVersionUID = 1L;
        private boolean _removed = false;

        public RemovableList() {
            super(4);
        }

        public boolean isRemoved() {
            return this._removed;
        }

        public void setRemoved() {
            this._removed = true;
        }
    }

    static class Element {
        private Record _record;
        private Long _expires;
        private boolean _negative;

        public Element(Record record) {
            this._record = record;
            this._expires = System.currentTimeMillis() + (long)(record.getTtl() * 1000);
        }

        public Element(Record record, long ttl, boolean negative) {
            this._record = record;
            this._expires = System.currentTimeMillis() + ttl * 1000L;
            this._negative = negative;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() > this._expires;
        }

        public Record get() {
            return this._record;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this._record.toString());
            if (this.isNegative()) {
                sb.append(" [Negative]");
            }
            sb.append('@').append((this._expires - System.currentTimeMillis()) / 1000L).append("s");
            return sb.toString();
        }

        public boolean isNegative() {
            return this._negative;
        }
    }
}

