/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.dns;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import org.cipango.dns.DnsConnector;
import org.cipango.dns.DnsMessage;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;

public abstract class AbstractConnector
extends AbstractLifeCycle
implements DnsConnector {
    private static final Logger LOG = Log.getLogger(AbstractConnector.class);
    private InetAddress _host;
    private int _timeout = 10000;
    protected Map<Integer, MsgContainer> _queries = new HashMap<Integer, MsgContainer>();
    private Executor _executor;

    protected void doStart() throws Exception {
        super.doStart();
        if (this._executor == null) {
            this.setExecutor((Executor)new ExecutorThreadPool(1, 10, 2000L));
        }
    }

    @Override
    public String getHost() {
        if (this._host == null) {
            return null;
        }
        return this._host.getHostName();
    }

    public InetAddress getHostAddr() {
        return this._host;
    }

    @Override
    public void setHost(String host) {
        try {
            this._host = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            LOG.debug((Throwable)e);
        }
    }

    public int getTimeout() {
        return this._timeout;
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addQuery(DnsMessage query) {
        Map<Integer, MsgContainer> map = this._queries;
        synchronized (map) {
            if (!this._queries.containsKey(query.getHeaderSection().getId())) {
                this._queries.put(query.getHeaderSection().getId(), new MsgContainer(query));
            } else {
                int id = ThreadLocalRandom.current().nextInt() & 0xFFFF;
                LOG.warn("ID {} is already in use. Change ID to {}", new Object[]{query.getHeaderSection().getId(), id});
                query.getHeaderSection().setId(id);
                this.addQuery(query);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateQueryOnAnswer(DnsMessage answer) {
        MsgContainer msgContainer;
        Object object = this._queries;
        synchronized (object) {
            msgContainer = this._queries.get(answer.getHeaderSection().getId());
        }
        if (msgContainer != null) {
            object = msgContainer.getQuery();
            synchronized (object) {
                msgContainer.setAnswer(answer);
                msgContainer.getQuery().notify();
            }
        } else {
            LOG.warn("Drop DNS {}, as can not found a query with same ID", new Object[]{answer});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DnsMessage waitAnswer(DnsMessage request, int timeout) {
        MsgContainer messages;
        DnsMessage dnsMessage = request;
        synchronized (dnsMessage) {
            try {
                request.wait(timeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        Map<Integer, MsgContainer> map = this._queries;
        synchronized (map) {
            messages = this._queries.remove(request.getHeaderSection().getId());
        }
        if (messages == null) {
            return null;
        }
        return messages.getAnswer();
    }

    @Override
    public Executor getExecutor() {
        return this._executor;
    }

    @Override
    public void setExecutor(Executor executor) {
        this._executor = executor;
    }

    public static class MsgContainer {
        private DnsMessage _query;
        private DnsMessage _answer;

        public MsgContainer(DnsMessage query) {
            this._query = query;
        }

        public DnsMessage getAnswer() {
            return this._answer;
        }

        public void setAnswer(DnsMessage answer) {
            this._answer = answer;
        }

        public DnsMessage getQuery() {
            return this._query;
        }
    }
}

