/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.util;

import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;

public class FixedBufferPool
implements ByteBufferPool {
    private final Queue<ByteBuffer> _directQueue = new ConcurrentLinkedQueue<ByteBuffer>();
    private final Queue<ByteBuffer> _indirectQueue = new ConcurrentLinkedQueue<ByteBuffer>();
    private int _size;

    public FixedBufferPool(int size) {
        this._size = size;
    }

    public ByteBuffer acquire(int size, boolean direct) {
        ByteBuffer buffer;
        ByteBuffer byteBuffer = buffer = direct ? this._directQueue.poll() : this._indirectQueue.poll();
        if (buffer == null) {
            buffer = direct ? BufferUtil.allocateDirect((int)this._size) : BufferUtil.allocate((int)this._size);
        }
        return buffer;
    }

    public void release(ByteBuffer buffer) {
        if (buffer != null) {
            if (buffer.isDirect()) {
                this._directQueue.offer(buffer);
            } else {
                this._indirectQueue.offer(buffer);
            }
        }
    }
}

