/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.transaction;

import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.cipango.server.SipMessage;
import org.cipango.server.SipProxy;
import org.cipango.server.SipRequest;
import org.cipango.server.SipResponse;
import org.cipango.server.processor.SipProcessorWrapper;
import org.cipango.server.processor.TransportProcessor;
import org.cipango.server.transaction.ClientTransaction;
import org.cipango.server.transaction.ClientTransactionImpl;
import org.cipango.server.transaction.ClientTransactionListener;
import org.cipango.server.transaction.ServerTransaction;
import org.cipango.server.transaction.Transaction;
import org.cipango.server.transaction.TransactionImpl;
import org.cipango.util.TimerQueue;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.statistic.CounterStatistic;

@ManagedObject(value="Transaction manager")
public class TransactionManager
extends SipProcessorWrapper
implements Dumpable {
    private final Logger LOG = Log.getLogger(TransactionManager.class);
    private static final String CANCEL_PREFIX = "cancel-";
    private ConcurrentHashMap<String, ServerTransaction> _serverTransactions = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ClientTransaction> _clientTransactions = new ConcurrentHashMap();
    private TimerQueue<TimerTask> _timerQueue = new TimerQueue();
    private TransportProcessor _transportProcessor;
    private final CounterStatistic _serverTxStats = new CounterStatistic();
    private final CounterStatistic _clientTxStats = new CounterStatistic();

    public void setTransportProcessor(TransportProcessor processor) {
        this._transportProcessor = processor;
    }

    @Override
    public void doProcess(SipMessage message) throws Exception {
        if (message.isRequest()) {
            this.doProcessRequest((SipRequest)message);
        } else {
            this.doProcessResponse((SipResponse)message);
        }
    }

    @Override
    public void doStart() {
        new Thread((Runnable)new Timer(), "Timer-TransactionManager").start();
    }

    public void doProcessRequest(SipRequest request) throws Exception {
        String branch = request.getTopVia().getBranch();
        if (!(branch != null && branch.startsWith("z9hG4bK") || "0".equals(branch) && request.isAck())) {
            this.LOG.debug("Not 3261 branch: {}. Dropping request", new Object[]{branch});
            return;
        }
        if (request.isCancel()) {
            branch = CANCEL_PREFIX + branch;
        }
        ServerTransaction transaction = this._serverTransactions.get(branch);
        this.LOG.debug("handling server transaction message with tx {}", new Object[]{transaction});
        ServerTransaction newTransaction = null;
        if (transaction == null) {
            newTransaction = new ServerTransaction(request);
            newTransaction.setTransactionManager(this);
            if (!request.isAck() && (transaction = this._serverTransactions.putIfAbsent(branch, newTransaction)) == null) {
                this._serverTxStats.increment();
            }
        }
        if (transaction != null) {
            transaction.handleRequest(request);
        } else if (request.isCancel()) {
            String txBranch = request.getTopVia().getBranch();
            ServerTransaction stx = this._serverTransactions.get(txBranch);
            if (stx == null) {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("No transaction for cancelled branch {}", new Object[]{txBranch});
                }
                SipResponse unknown = (SipResponse)request.createResponse(481);
                newTransaction.send(unknown);
            } else {
                stx.cancel(request);
            }
        } else {
            super.doProcess(request);
        }
    }

    public void doProcessResponse(SipResponse response) throws Exception {
        String branch = response.getTopVia().getBranch();
        if (response.isCancel()) {
            branch = CANCEL_PREFIX + branch;
        }
        ClientTransaction transaction = this._clientTransactions.get(branch);
        this.LOG.debug("handling client transaction message with tx {}", new Object[]{transaction});
        if (transaction == null) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("did not find client transaction for response {}", new Object[]{response});
            }
            this.transactionNotFound();
            return;
        }
        response.setRequest(transaction.getRequest());
        transaction.handleResponse(response);
    }

    protected void transactionNotFound() {
    }

    private String getId(Transaction transaction) {
        if (transaction.isCancel()) {
            return CANCEL_PREFIX + transaction.getBranch();
        }
        return transaction.getBranch();
    }

    public void transactionTerminated(ServerTransaction transaction) {
        ServerTransaction tx = this._serverTransactions.remove(this.getId(transaction));
        if (tx != null) {
            this._serverTxStats.decrement();
        }
    }

    public void transactionTerminated(ClientTransaction transaction) {
        ClientTransaction tx = this._clientTransactions.remove(this.getId(transaction));
        if (tx != null) {
            this._clientTxStats.decrement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimerTask schedule(Runnable runnable, long delay) {
        TimerTask task = new TimerTask(runnable, System.currentTimeMillis() + delay);
        TimerQueue<TimerTask> timerQueue = this._timerQueue;
        synchronized (timerQueue) {
            this._timerQueue.offer((TimerQueue.Node)task);
            this._timerQueue.notifyAll();
        }
        return task;
    }

    public TransportProcessor getTransportProcessor() {
        return this._transportProcessor;
    }

    protected ClientTransaction addClientTransaction(ClientTransaction tx) {
        ClientTransaction oldTx = this._clientTransactions.putIfAbsent(this.getId(tx), tx);
        if (oldTx != null) {
            this.LOG.warn("Try to add client transaction {} when there is already the transaction {}", new Object[]{tx, oldTx});
        } else {
            this._clientTxStats.increment();
        }
        return oldTx;
    }

    public ClientTransaction sendRequest(SipRequest request, ClientTransactionListener listener) {
        ClientTransaction ctx;
        ClientTransaction oldTx = null;
        do {
            ctx = this.newClientTransaction(request, listener);
            ctx.setTransactionManager(this);
            if (request.isAck()) continue;
            oldTx = this.addClientTransaction(ctx);
        } while (oldTx != null);
        try {
            ctx.start();
        }
        catch (IOException e) {
            this.LOG.warn("Failed to start client transaction {}: {}", new Object[]{ctx, e});
        }
        return ctx;
    }

    protected ClientTransaction newClientTransaction(SipRequest request, ClientTransactionListener listener) {
        return new ClientTransactionImpl(request, listener);
    }

    @ManagedAttribute(value="Current active client transactions")
    public long getClientTransactions() {
        return this._clientTxStats.getCurrent();
    }

    @ManagedAttribute(value="Max simultaneous client transactions")
    public long getClientTransactionsMax() {
        return this._clientTxStats.getMax();
    }

    @ManagedAttribute(value="Total client transactions")
    public long getClientTransactionsTotal() {
        return this._clientTxStats.getTotal();
    }

    @ManagedAttribute(value="Current active server transactions")
    public long getServerTransactions() {
        return this._serverTxStats.getCurrent();
    }

    @ManagedAttribute(value="Max simultaneous server transactions")
    public long getServerTransactionsMax() {
        return this._serverTxStats.getMax();
    }

    @ManagedAttribute(value="Total server transactions")
    public long getServerTransactionsTotal() {
        return this._serverTxStats.getTotal();
    }

    @ManagedAttribute(value="Timer T1 in milliseconds", readonly=true)
    public int getT1() {
        return TransactionImpl.__T1;
    }

    @ManagedAttribute(value="Timer T2 in milliseconds", readonly=true)
    public int getT2() {
        return TransactionImpl.__T2;
    }

    @ManagedAttribute(value="Timer T4 in milliseconds", readonly=true)
    public int getT4() {
        return TransactionImpl.__T4;
    }

    @ManagedAttribute(value="Timer TD in milliseconds", readonly=true)
    public int getTD() {
        return TransactionImpl.__TD;
    }

    @ManagedAttribute(value="Timer C in seconds", readonly=true)
    public int getTimerC() {
        return SipProxy.__timerC;
    }

    public void setT1(int millis) {
        if (millis < 0) {
            throw new IllegalArgumentException("SIP Timers must be positive");
        }
        TransactionImpl.__T1 = millis;
    }

    public void setT2(int millis) {
        if (millis < 0) {
            throw new IllegalArgumentException("SIP Timers must be positive");
        }
        TransactionImpl.__T2 = millis;
    }

    public void setT4(int millis) {
        if (millis < 0) {
            throw new IllegalArgumentException("SIP Timers must be positive");
        }
        TransactionImpl.__T4 = millis;
    }

    public void setTD(int millis) {
        if (millis < 0) {
            throw new IllegalArgumentException("SIP Timers must be positive");
        }
        TransactionImpl.__TD = millis;
    }

    @ManagedOperation(value="Reset statistics", impact="ACTION")
    public void statsReset() {
        this._serverTxStats.reset((long)this._serverTransactions.size());
        this._clientTxStats.reset((long)this._clientTransactions.size());
    }

    public String dump() {
        return ContainerLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        out.append(indent).append(" +- TransactionManager\n");
        indent = indent + "  ";
        out.append(indent).append(" +- ClientTransactions\n");
        Iterator<ClientTransaction> it = this._clientTransactions.values().iterator();
        int i = 50;
        while (it.hasNext() && --i > 0) {
            out.append(indent).append("  - ").append(it.next().toString()).append("\n");
        }
        if (it.hasNext()) {
            out.append(indent).append("  - ").append("...\n");
        }
        out.append(indent).append(" +- ServerTransactions\n");
        Iterator<ServerTransaction> it2 = this._serverTransactions.values().iterator();
        i = 50;
        while (it2.hasNext() && --i > 0) {
            out.append(indent).append("  - ").append(it2.next().toString()).append("\n");
        }
        if (it.hasNext()) {
            out.append(indent).append("  - ").append("...\n");
        }
    }

    class Watcher
    implements Runnable {
        Watcher() {
        }

        @Override
        public void run() {
            while (TransactionManager.this.isRunning()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                TransactionManager.this.LOG.info("transactions size: " + TransactionManager.this._serverTransactions.size(), new Object[0]);
            }
        }
    }

    public class TimerTask
    extends TimerQueue.Node {
        private Runnable _runnable;

        public TimerTask(Runnable runnable, long executionTime) {
            super(executionTime);
            this._runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            TimerQueue timerQueue = TransactionManager.this._timerQueue;
            synchronized (timerQueue) {
                TransactionManager.this._timerQueue.remove((TimerQueue.Node)this);
            }
        }
    }

    class Timer
    implements Runnable {
        Timer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            do {
                try {
                    long delay;
                    TimerTask task;
                    TimerQueue timerQueue = TransactionManager.this._timerQueue;
                    synchronized (timerQueue) {
                        task = (TimerTask)TransactionManager.this._timerQueue.peek();
                        long l = delay = task != null ? task.getValue() - System.currentTimeMillis() : Long.MAX_VALUE;
                        if (delay > 0L) {
                            TransactionManager.this._timerQueue.wait(delay);
                        } else {
                            TransactionManager.this._timerQueue.poll();
                        }
                    }
                    if (delay > 0L) continue;
                    task._runnable.run();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            } while (TransactionManager.this.isRunning());
        }
    }
}

