/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.transaction;

import java.util.EnumMap;
import java.util.Map;
import org.cipango.server.SipConnection;
import org.cipango.server.SipRequest;
import org.cipango.server.SipServer;
import org.cipango.server.transaction.Transaction;
import org.cipango.server.transaction.TransactionManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class TransactionImpl
implements Transaction {
    private static final Logger LOG = Log.getLogger(TransactionImpl.class);
    public static final int DEFAULT_T1 = 500;
    public static final int DEFAULT_T2 = 4000;
    public static final int DEFAULT_T4 = 5000;
    public static final int DEFAULT_TD = 32000;
    public static int __T1 = 500;
    public static int __T2 = 4000;
    public static int __T4 = 5000;
    public static int __TD = 32000;
    protected Transaction.State _state = Transaction.State.UNDEFINED;
    private String _branch;
    protected TransactionManager _transactionManager;
    protected SipRequest _request;
    private Map<Timer, TransactionManager.TimerTask> _timerTasks = new EnumMap<Timer, TransactionManager.TimerTask>(Timer.class);

    @Override
    public abstract boolean isServer();

    @Override
    public abstract SipConnection getConnection();

    protected abstract void timeout(Timer var1);

    public TransactionImpl(SipRequest request, String branch) {
        this._request = request;
        this._branch = branch;
        request.setTransaction(this);
    }

    public boolean isTransportReliable() {
        return this.getConnection().getTransport().isReliable();
    }

    @Override
    public Transaction.State getState() {
        return this._state;
    }

    protected void setState(Transaction.State state) {
        this._state = state;
    }

    @Override
    public boolean isInvite() {
        return this._request.isInvite();
    }

    @Override
    public boolean isAck() {
        return this._request.isAck();
    }

    @Override
    public boolean isCancel() {
        return this._request.isCancel();
    }

    @Override
    public boolean isCompleted() {
        return this._state.ordinal() >= Transaction.State.COMPLETED.ordinal();
    }

    @Override
    public String getBranch() {
        return this._branch;
    }

    protected SipServer getServer() {
        return this._transactionManager.getServer();
    }

    @Override
    public void setTransactionManager(TransactionManager manager) {
        this._transactionManager = manager;
    }

    protected void startTimer(Timer timer, long delay) {
        TransactionManager.TimerTask task = this._timerTasks.get((Object)timer);
        if (task != null) {
            task.cancel();
        }
        if (this._state != Transaction.State.TERMINATED) {
            this._timerTasks.put(timer, this._transactionManager.schedule(new Timeout(timer), delay));
        }
    }

    protected void terminate() {
        this.setState(Transaction.State.TERMINATED);
        for (TransactionManager.TimerTask task : this._timerTasks.values()) {
            task.cancel();
        }
        this._timerTasks.clear();
    }

    protected void cancelTimer(Timer timer) {
        TransactionManager.TimerTask task = this._timerTasks.get((Object)timer);
        if (task != null) {
            task.cancel();
        }
        this._timerTasks.remove((Object)timer);
    }

    protected boolean isCanceled(Timer timer) {
        return this._timerTasks.get((Object)timer) == null;
    }

    @Override
    public SipRequest getRequest() {
        return this._request;
    }

    public String toString() {
        return String.format("%s{%s,%s}", new Object[]{this.isServer() ? "ST" : "CT", this.getBranch(), this._state});
    }

    class Timeout
    implements Runnable {
        private Timer _timer;

        public Timeout(Timer timer) {
            this._timer = timer;
        }

        @Override
        public void run() {
            try {
                TransactionImpl.this.timeout(this._timer);
            }
            catch (Throwable t) {
                LOG.debug(t);
            }
        }

        public String toString() {
            return "Timer" + (Object)((Object)this._timer);
        }
    }

    protected static enum Timer {
        A,
        B,
        D,
        E,
        F,
        G,
        H,
        I,
        J,
        K,
        L,
        M;

    }
}

