/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.transaction;

import java.io.IOException;
import org.cipango.server.SipConnection;
import org.cipango.server.SipRequest;
import org.cipango.server.SipResponse;
import org.cipango.server.session.Session;
import org.cipango.server.session.scoped.ScopedServerTransactionListener;
import org.cipango.server.transaction.ServerTransactionListener;
import org.cipango.server.transaction.Transaction;
import org.cipango.server.transaction.TransactionImpl;
import org.cipango.sip.SipHeader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ServerTransaction
extends TransactionImpl {
    private static final Logger LOG = Log.getLogger(ServerTransaction.class);
    private SipResponse _latestResponse;
    private long _gDelay = __T1;
    private ServerTransactionListener _listener;

    public ServerTransaction(SipRequest request) {
        super(request, request.getTopVia().getBranch());
        if (this.isInvite()) {
            this.setState(Transaction.State.PROCEEDING);
        } else {
            this.setState(Transaction.State.TRYING);
        }
    }

    @Override
    public boolean isServer() {
        return true;
    }

    @Override
    public SipConnection getConnection() {
        return this._request.getConnection();
    }

    public synchronized void handleRequest(SipRequest request) {
        request.setTransaction(this);
        if (request.isAck()) {
            if (this.isInvite()) {
                if (this._state != Transaction.State.COMPLETED) {
                    LOG.debug("received ACK in non-completed state for transaction {}", new Object[]{this});
                    return;
                }
                this.setState(Transaction.State.CONFIRMED);
                this.cancelTimer(TransactionImpl.Timer.H);
                this.cancelTimer(TransactionImpl.Timer.G);
                if (this.isTransportReliable()) {
                    this.terminate();
                } else {
                    this.startTimer(TransactionImpl.Timer.I, __T4);
                }
            } else {
                LOG.debug("received ACK for non-INVITE transaction: {}", new Object[]{this});
            }
        } else {
            if (!request.getHeader(SipHeader.CSEQ.toString()).equals(this._request.getHeader(SipHeader.CSEQ.toString()))) {
                LOG.debug("invalid retransmission {}", new Object[]{this});
                return;
            }
            if ((this._state == Transaction.State.PROCEEDING || this._state == Transaction.State.COMPLETED) && this._latestResponse != null) {
                try {
                    this.doSend(this._latestResponse);
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
            }
        }
    }

    public void cancel(SipRequest cancel) throws IOException {
        if (this._listener == null) {
            Session session = this._request.session();
            if (session == null) {
                LOG.warn("No transaction listener set on {}. Could not handle:\n{}", new Object[]{this, cancel});
                return;
            }
            if (session.getUa() == null) {
                session.setUAS();
            }
            this.setListener(new ScopedServerTransactionListener(session, session.getUa()));
        }
        this._listener.handleCancel(this, cancel);
    }

    public synchronized void send(SipResponse response) {
        block18: {
            int status;
            block17: {
                status = response.getStatus();
                if (!this.isInvite()) break block17;
                switch (this._state) {
                    case PROCEEDING: {
                        if (status < 200) {
                            this._latestResponse = response;
                        } else if (status < 300) {
                            this.setState(Transaction.State.ACCEPTED);
                            this.startTimer(TransactionImpl.Timer.L, 64 * __T1);
                        } else {
                            this.setState(Transaction.State.COMPLETED);
                            this._latestResponse = response;
                            if (this.isTransportReliable()) {
                                this.startTimer(TransactionImpl.Timer.G, this._gDelay);
                            }
                            this.startTimer(TransactionImpl.Timer.H, 64 * __T1);
                        }
                        break block18;
                    }
                    case ACCEPTED: {
                        if (status < 200 || status >= 300) {
                            throw new IllegalStateException("accepted && !2xx");
                        }
                        break block18;
                    }
                    default: {
                        throw new IllegalStateException("!proceeding && send(invite)");
                    }
                }
            }
            switch (this._state) {
                case PROCEEDING: 
                case TRYING: {
                    this._latestResponse = response;
                    if (status < 200) {
                        if (this._state != Transaction.State.TRYING) break;
                        this.setState(Transaction.State.PROCEEDING);
                        break;
                    }
                    this.setState(Transaction.State.COMPLETED);
                    if (this.isTransportReliable()) {
                        this.terminate();
                        break;
                    }
                    this.startTimer(TransactionImpl.Timer.J, 64 * __T1);
                    break;
                }
                default: {
                    throw new IllegalStateException("state != trying||proceeding && send(non-invite)");
                }
            }
        }
        try {
            this.doSend(response);
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
    }

    @Override
    protected void terminate() {
        super.terminate();
        this._latestResponse = null;
        this._transactionManager.transactionTerminated(this);
        if (this._listener != null) {
            this._listener.transactionTerminated(this);
        }
    }

    private void doSend(SipResponse response) throws IOException {
        this.getServer().sendResponse(response, this.getConnection());
    }

    @Override
    protected synchronized void timeout(TransactionImpl.Timer timer) {
        if (this.isCanceled(timer)) {
            LOG.debug("Do not run timer {} on transaction {} as it is canceled ", new Object[]{timer, this});
            return;
        }
        switch (timer) {
            case G: {
                try {
                    this.doSend(this._latestResponse);
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
                this._gDelay *= 2L;
                this.startTimer(TransactionImpl.Timer.G, Math.min(this._gDelay, (long)__T2));
                break;
            }
            case H: {
                this.cancelTimer(TransactionImpl.Timer.G);
                this.terminate();
                break;
            }
            case I: 
            case J: 
            case L: {
                this.terminate();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown timer in server transaction: " + (Object)((Object)timer));
            }
        }
    }

    public ServerTransactionListener getListener() {
        return this._listener;
    }

    public void setListener(ServerTransactionListener listener) {
        this._listener = listener;
    }

    @Override
    public String toString() {
        return "ServerTransaction {branch=" + this.getBranch() + ", method=" + this.getRequest().getMethod() + ", state=" + (Object)((Object)this.getState()) + "}";
    }
}

