/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.transaction;

import java.io.IOException;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicLong;
import org.cipango.server.SipConnection;
import org.cipango.server.SipRequest;
import org.cipango.server.SipResponse;
import org.cipango.server.dns.BlackList;
import org.cipango.server.dns.Hop;
import org.cipango.server.transaction.ClientTransaction;
import org.cipango.server.transaction.ClientTransactionImpl;
import org.cipango.server.transaction.ClientTransactionListener;
import org.cipango.server.transaction.Transaction;
import org.cipango.server.transaction.TransactionManager;
import org.cipango.server.util.ClientTransactionProxy;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject
public class RetryableTransactionManager
extends TransactionManager {
    private static final Logger LOG = Log.getLogger(RetryableTransactionManager.class);
    private long _maxRetryTime = -1L;
    private final AtomicLong _retries = new AtomicLong();

    @Override
    protected ClientTransaction newClientTransaction(SipRequest request, ClientTransactionListener listener) {
        RetryableClientTransaction ctx = new RetryableClientTransaction(request, listener);
        return ctx;
    }

    @ManagedAttribute(value="Max retry time")
    public long getMaxRetryTime() {
        return this._maxRetryTime;
    }

    public void setMaxRetryTime(long maxRetryTime) {
        this._maxRetryTime = maxRetryTime;
    }

    @ManagedAttribute(value="Number of retries")
    public long getRetries() {
        return this._retries.get();
    }

    public class RetryableClientTransaction
    extends ClientTransactionProxy
    implements ClientTransaction {
        private ClientTransaction _activeTx;
        private ClientTransactionListener _listener;
        private Listener _localListener;
        private boolean _isRetrying = false;
        private long _start;
        private TransactionManager.TimerTask _retryTask;

        public RetryableClientTransaction(SipRequest request, ClientTransactionListener listener) {
            this._listener = listener;
            this._localListener = new Listener();
            this._activeTx = this.newClientTransaction(request, false);
            this._start = System.currentTimeMillis();
        }

        protected ClientTransaction newClientTransaction(SipRequest request, boolean isRetry) {
            if (isRetry) {
                RetryableTransactionManager.this._retries.incrementAndGet();
            }
            ClientTransaction oldTx = null;
            do {
                this._activeTx = new ClientTransactionImpl(request, this._localListener);
                if (!isRetry) continue;
                this._activeTx.setTransactionManager(RetryableTransactionManager.this);
                if (!request.isAck()) {
                    oldTx = RetryableTransactionManager.this.addClientTransaction(this);
                }
                if (RetryableTransactionManager.this.getMaxRetryTime() == -1L || this._retryTask != null) continue;
                long delay = RetryableTransactionManager.this.getMaxRetryTime() - (System.currentTimeMillis() - this._start);
                this._retryTask = RetryableTransactionManager.this.schedule(new RetryTimeout(), delay);
            } while (oldTx != null);
            return this._activeTx;
        }

        protected BlackList.Reason isRetryable(SipResponse response) {
            int status = response.getStatus();
            if (this.isCanceled() || this.isCancel()) {
                return null;
            }
            if (status == 503) {
                return BlackList.Reason.RESPONSE_CODE_503;
            }
            if (status == 408 && response.getConnection() instanceof ClientTransactionImpl.TimeoutConnection) {
                return BlackList.Reason.TIMEOUT;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void start() {
            while (true) {
                try {
                    this._activeTx.start();
                    return;
                }
                catch (IOException e) {
                    ListIterator<Hop> hops = this.getRequest().getHops();
                    if (hops == null) {
                        LOG.debug(e.getCause());
                        return;
                    }
                    if (hops.hasPrevious()) {
                        Hop failedHop = hops.previous();
                        RetryableTransactionManager.this.getTransportProcessor().getBlackList().hopFailed(failedHop, BlackList.Reason.CONNECT_FAILED, null);
                        hops.next();
                        if (hops.hasNext()) {
                            LOG.warn("Could not send request using hop {} due to {}, try with next hop", new Object[]{failedHop, e.getCause()});
                        } else {
                            LOG.warn("Could not send request using hop {} due to {} and there is no more hops", new Object[]{failedHop, e.getCause()});
                        }
                    }
                    if (hops.hasNext()) {
                        this._isRetrying = true;
                        try {
                            this._activeTx.terminate();
                            this._activeTx = this.newClientTransaction(this.getRequest(), true);
                            continue;
                        }
                        finally {
                            this._isRetrying = false;
                            continue;
                        }
                    }
                    LOG.debug(e.getCause());
                    return;
                }
                break;
            }
        }

        @Override
        protected ClientTransaction getTransaction() {
            return this._activeTx;
        }

        protected boolean retry(SipResponse response, BlackList.Reason reason) {
            ListIterator<Hop> hops = this.getRequest().getHops();
            if (hops.hasPrevious()) {
                Hop failedHop = hops.previous();
                RetryableTransactionManager.this.getTransportProcessor().getBlackList().hopFailed(failedHop, reason, response);
                hops.next();
            }
            if (hops.hasNext()) {
                try {
                    LOG.debug("Retrying to send request on session {}", new Object[]{this});
                    this.getRequest().removeTopVia();
                    this._activeTx = this.newClientTransaction(this.getRequest(), true);
                    this.start();
                    return true;
                }
                catch (Exception e) {
                    LOG.debug("Failed to send request to another hop", (Throwable)e);
                }
            }
            LOG.debug("Could not retry to send request on session {} as there is no more hop", new Object[]{this});
            return false;
        }

        @Override
        public ClientTransactionListener getListener() {
            return this._listener;
        }

        @Override
        public boolean isProcessingResponse() {
            return this._activeTx.isProcessingResponse();
        }

        public String toString() {
            return "Retryable" + this._activeTx;
        }

        class Listener
        implements ClientTransactionListener {
            Listener() {
            }

            @Override
            public void transactionTerminated(Transaction transaction) {
                if (transaction.isCancel()) {
                    RetryableClientTransaction.this._listener.transactionTerminated(transaction);
                } else if (!RetryableClientTransaction.this._isRetrying && transaction == RetryableClientTransaction.this._activeTx) {
                    RetryableClientTransaction.this._listener.transactionTerminated(RetryableClientTransaction.this);
                } else {
                    LOG.warn("Ignore event transaction terminated({}) as {}", new Object[]{transaction, RetryableClientTransaction.this._isRetrying ? "a new transaction will be created" : "this transaction is no more active"});
                }
            }

            @Override
            public void handleResponse(SipResponse response) {
                BlackList.Reason reason = RetryableClientTransaction.this.isRetryable(response);
                if (reason != null) {
                    LOG.debug("Response is retryable for reason {} on session {}", new Object[]{reason, RetryableClientTransaction.this.getRequest().session()});
                    if (RetryableClientTransaction.this.retry(response, reason)) {
                        return;
                    }
                }
                if (RetryableClientTransaction.this._retryTask != null) {
                    RetryableClientTransaction.this._retryTask.cancel();
                    RetryableClientTransaction.this._retryTask = null;
                }
                RetryableClientTransaction.this._listener.handleResponse(response);
            }

            @Override
            public void customizeRequest(SipRequest request, SipConnection connection) {
                RetryableClientTransaction.this._listener.customizeRequest(request, connection);
            }
        }

        class RetryTimeout
        implements Runnable {
            RetryTimeout() {
            }

            @Override
            public void run() {
                LOG.warn("Generate localy 408 Request Timeout due to retry timeout", new Object[0]);
                SipResponse responseB = RetryableClientTransaction.this.create408();
                if (!RetryableClientTransaction.this.isCancel()) {
                    RetryableClientTransaction.this._listener.handleResponse(responseB);
                }
                RetryableClientTransaction.this.terminate();
            }
        }
    }
}

