/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.transaction;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.cipango.server.SipConnection;
import org.cipango.server.SipConnector;
import org.cipango.server.SipMessage;
import org.cipango.server.SipRequest;
import org.cipango.server.SipResponse;
import org.cipango.server.Transport;
import org.cipango.server.log.AccessLog;
import org.cipango.server.transaction.ClientTransaction;
import org.cipango.server.transaction.ClientTransactionListener;
import org.cipango.server.transaction.Transaction;
import org.cipango.server.transaction.TransactionImpl;
import org.cipango.sip.SipHeader;
import org.cipango.sip.SipMethod;
import org.cipango.sip.Via;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ClientTransactionImpl
extends TransactionImpl
implements ClientTransaction {
    private static final Logger LOG = Log.getLogger(ClientTransactionImpl.class);
    private long _aDelay = __T1;
    private long _eDelay = __T1;
    private ClientTransactionListener _listener;
    private SipRequest _pendingCancel;
    private boolean _canceled = false;
    private SipConnection _connection;
    private Thread _responseProcessingThread;

    public ClientTransactionImpl(SipRequest request, ClientTransactionListener listener) {
        this(request, listener, request.appSession().newBranch());
    }

    public ClientTransactionImpl(SipRequest request, ClientTransactionListener listener, String branch) {
        super(request, branch);
        this._listener = listener;
    }

    @Override
    public ClientTransactionListener getListener() {
        return this._listener;
    }

    private void ack(SipResponse response) {
        String tag;
        SipRequest ack = this._request.createRequest(SipMethod.ACK);
        if (ack.to().getTag() == null && (tag = response.to().getTag()) != null) {
            ack.to().setParameter("tag", tag);
        }
        try {
            this.getServer().sendRequest(ack, this.getConnection());
        }
        catch (IOException e) {
            LOG.ignore((Throwable)e);
        }
    }

    @Override
    public synchronized void cancel(SipRequest cancel) {
        if (this._canceled) {
            return;
        }
        this._canceled = true;
        if (this._state == Transaction.State.UNDEFINED || this._state == Transaction.State.CALLING || this._state == Transaction.State.TRYING) {
            this._pendingCancel = cancel;
            return;
        }
        this.doCancel(cancel);
    }

    @Override
    public boolean isCanceled() {
        return this._canceled;
    }

    private ClientTransaction doCancel(SipRequest cancel) {
        ClientTransactionImpl cancelTx = new ClientTransactionImpl(cancel, this._listener, cancel.getTopVia().getBranch());
        cancelTx.setTransactionManager(this._transactionManager);
        cancelTx._connection = this.getConnection();
        cancelTx._listener = this._listener;
        this._transactionManager.addClientTransaction(cancelTx);
        try {
            cancelTx.start();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        return cancelTx;
    }

    private void doSend() throws IOException {
        if (this.getConnection() != null) {
            if (this.getConnection().isOpen()) {
                this.getServer().sendRequest(this._request, this.getConnection());
            } else {
                LOG.debug("Could not sent request {} as the connection {} is closed", new Object[]{this._request, this.getConnection()});
            }
        } else {
            Via via = new Via(null, null, -1);
            via.setBranch(this.getBranch());
            this._request.getFields().add(SipHeader.VIA.asString(), (Object)via, true);
            this._connection = this._transactionManager.getTransportProcessor().getConnection(this._request, null);
            this._listener.customizeRequest(this._request, this._connection);
            this.getServer().sendRequest(this._request, this._connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() throws IOException {
        if (this._state != Transaction.State.UNDEFINED) {
            throw new IllegalStateException("!undefined: " + (Object)((Object)this._state));
        }
        if (this.isInvite()) {
            this.setState(Transaction.State.CALLING);
            try {
                this.doSend();
            }
            finally {
                this.startTimer(TransactionImpl.Timer.B, 64L * (long)__T1);
            }
            if (!this.isTransportReliable()) {
                this.startTimer(TransactionImpl.Timer.A, this._aDelay);
            }
        } else if (this.isAck()) {
            this.setState(Transaction.State.TRYING);
            this.doSend();
        } else {
            this.setState(Transaction.State.TRYING);
            try {
                this.doSend();
            }
            finally {
                this.startTimer(TransactionImpl.Timer.F, 64L * (long)__T1);
            }
            if (!this.isTransportReliable()) {
                this.startTimer(TransactionImpl.Timer.E, this._eDelay);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void handleResponse(SipResponse response) {
        this._responseProcessingThread = Thread.currentThread();
        try {
            int status = response.getStatus();
            if (this.isInvite()) {
                switch (this._state) {
                    case CALLING: {
                        this.cancelTimer(TransactionImpl.Timer.A);
                        this.cancelTimer(TransactionImpl.Timer.B);
                        if (status < 200) {
                            this.setState(Transaction.State.PROCEEDING);
                            if (this._pendingCancel != null) {
                                this.doCancel(this._pendingCancel);
                            }
                        } else if (200 <= status && status < 300) {
                            this.setState(Transaction.State.ACCEPTED);
                            this.startTimer(TransactionImpl.Timer.M, 64L * (long)__T1);
                        } else {
                            this.setState(Transaction.State.COMPLETED);
                            this.ack(response);
                            if (this.isTransportReliable()) {
                                this.terminate();
                            } else {
                                this.startTimer(TransactionImpl.Timer.D, __TD);
                            }
                        }
                        this._listener.handleResponse(response);
                        return;
                    }
                    case PROCEEDING: {
                        if (200 <= status && status < 300) {
                            this.setState(Transaction.State.ACCEPTED);
                            this.startTimer(TransactionImpl.Timer.M, 64L * (long)__T1);
                        } else if (status >= 300) {
                            this.setState(Transaction.State.COMPLETED);
                            this.ack(response);
                            if (this.isTransportReliable()) {
                                this.terminate();
                            } else {
                                this.startTimer(TransactionImpl.Timer.D, __TD);
                            }
                        }
                        this._listener.handleResponse(response);
                        return;
                    }
                    case COMPLETED: {
                        this.ack(response);
                        return;
                    }
                    case ACCEPTED: {
                        if (200 > status || status >= 300) {
                            LOG.debug("non 2xx response {} in Accepted state", new Object[]{response});
                            return;
                        }
                        this._listener.handleResponse(response);
                        return;
                    }
                    default: {
                        LOG.debug("handleResponse (invite) && state ==" + (Object)((Object)this._state), new Object[0]);
                        return;
                    }
                }
            }
            switch (this._state) {
                case TRYING: {
                    if (status < 200) {
                        this.setState(Transaction.State.PROCEEDING);
                    } else {
                        this.cancelTimer(TransactionImpl.Timer.E);
                        this.cancelTimer(TransactionImpl.Timer.F);
                        this.setState(Transaction.State.COMPLETED);
                        if (this.isTransportReliable()) {
                            this.terminate();
                        } else {
                            this.startTimer(TransactionImpl.Timer.K, __T4);
                        }
                    }
                    if (this.isCancel()) return;
                    this._listener.handleResponse(response);
                    return;
                }
                case PROCEEDING: {
                    if (status < 200) return;
                    this.cancelTimer(TransactionImpl.Timer.E);
                    this.cancelTimer(TransactionImpl.Timer.F);
                    this.setState(Transaction.State.COMPLETED);
                    if (this.isTransportReliable()) {
                        this.terminate();
                    } else {
                        this.startTimer(TransactionImpl.Timer.K, __T4);
                    }
                    if (this.isCancel()) return;
                    this._listener.handleResponse(response);
                    return;
                }
                case COMPLETED: {
                    return;
                }
                default: {
                    LOG.warn("handleResponse (non-invite) && state ==" + (Object)((Object)this._state), new Object[0]);
                    return;
                }
            }
        }
        finally {
            this._responseProcessingThread = null;
        }
    }

    @Override
    public boolean isProcessingResponse() {
        return this._responseProcessingThread != null && this._responseProcessingThread != Thread.currentThread();
    }

    @Override
    public boolean isServer() {
        return false;
    }

    @Override
    public void terminate() {
        super.terminate();
        this._transactionManager.transactionTerminated(this);
        if (this._listener != null) {
            this._listener.transactionTerminated(this);
        }
    }

    @Override
    public SipResponse create408() {
        SipResponse responseB = new SipResponse(this._request, 408, null);
        if (responseB.to().getTag() == null) {
            responseB.to().setParameter("tag", responseB.appSession().newUASTag());
        }
        SipConnector c = this.getConnection() == null ? this.getServer().getConnectors()[0] : this.getConnection().getConnector();
        responseB.setConnection(new TimeoutConnection(c));
        AccessLog accessLog = this.getServer().getAccessLog();
        if (accessLog != null) {
            accessLog.messageReceived(responseB, responseB.getConnection());
        }
        return responseB;
    }

    @Override
    public SipConnection getConnection() {
        return this._connection;
    }

    @Override
    public String toString() {
        return "ClientTransaction {branch=" + this.getBranch() + ", method=" + this.getRequest().getMethod() + ", state=" + (Object)((Object)this.getState()) + "}";
    }

    @Override
    protected synchronized void timeout(TransactionImpl.Timer timer) {
        if (this.isCanceled(timer)) {
            LOG.debug("Do not run timer {} on transaction {} as it is canceled ", new Object[]{timer, this});
            return;
        }
        switch (timer) {
            case A: {
                try {
                    this.doSend();
                }
                catch (IOException e) {
                    LOG.debug("Failed to (re)send request " + this._request, new Object[0]);
                }
                this._aDelay *= 2L;
                this.startTimer(TransactionImpl.Timer.A, this._aDelay);
                break;
            }
            case B: {
                this.cancelTimer(TransactionImpl.Timer.A);
                SipResponse responseB = this.create408();
                if (!this.isCancel()) {
                    this._listener.handleResponse(responseB);
                }
                this.terminate();
                break;
            }
            case D: {
                this.terminate();
                break;
            }
            case E: {
                try {
                    this.doSend();
                }
                catch (IOException e) {
                    LOG.debug("Failed to (re)send request " + this._request, new Object[0]);
                }
                this._eDelay = this._state == Transaction.State.TRYING ? Math.min(this._eDelay * 2L, (long)__T2) : (long)__T2;
                this.startTimer(TransactionImpl.Timer.E, this._eDelay);
                break;
            }
            case F: {
                this.cancelTimer(TransactionImpl.Timer.E);
                SipResponse responseF = this.create408();
                if (!this.isCancel()) {
                    this._listener.handleResponse(responseF);
                }
                this.terminate();
                break;
            }
            case K: {
                this.terminate();
                break;
            }
            case M: {
                this.terminate();
                break;
            }
            default: {
                throw new RuntimeException("unknown timer  " + (Object)((Object)timer));
            }
        }
    }

    public static class TimeoutConnection
    implements SipConnection {
        private SipConnector _connector;

        public TimeoutConnection(SipConnector connector) {
            this._connector = connector;
        }

        @Override
        public SipConnector getConnector() {
            return this._connector;
        }

        @Override
        public InetAddress getLocalAddress() {
            return this._connector.getAddress();
        }

        @Override
        public int getLocalPort() {
            return this._connector.getPort();
        }

        @Override
        public InetAddress getRemoteAddress() {
            return this._connector.getAddress();
        }

        @Override
        public int getRemotePort() {
            return this._connector.getPort();
        }

        @Override
        public Transport getTransport() {
            return this._connector.getTransport();
        }

        @Override
        public void send(SipMessage message) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void write(ByteBuffer buffer) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOpen() {
            return false;
        }
    }
}

