/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.sipapp;

import java.util.ArrayList;
import java.util.Iterator;
import org.cipango.server.security.Constraint;
import org.cipango.server.security.ConstraintMapping;
import org.cipango.server.security.ConstraintSecurityHandler;
import org.cipango.server.security.SipSecurityHandler;
import org.cipango.server.servlet.SipServletHolder;
import org.cipango.server.sipapp.SipAppContext;
import org.cipango.server.sipapp.SipDescriptor;
import org.cipango.server.sipapp.SipServletMapping;
import org.cipango.server.sipapp.rules.AndRule;
import org.cipango.server.sipapp.rules.ContainsRule;
import org.cipango.server.sipapp.rules.EqualsRule;
import org.cipango.server.sipapp.rules.ExistsRule;
import org.cipango.server.sipapp.rules.MatchingRule;
import org.cipango.server.sipapp.rules.NotRule;
import org.cipango.server.sipapp.rules.OrRule;
import org.cipango.server.sipapp.rules.SubdomainRule;
import org.eclipse.jetty.security.UserDataConstraint;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.Descriptor;
import org.eclipse.jetty.webapp.IterativeDescriptorProcessor;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlParser;

public class StandardDescriptorProcessor
extends IterativeDescriptorProcessor {
    private static final Logger LOG = Log.getLogger(StandardDescriptorProcessor.class);

    public StandardDescriptorProcessor() {
        try {
            this.registerVisitor("app-name", ((Object)((Object)this)).getClass().getDeclaredMethod("visitAppName", __signature));
            this.registerVisitor("servlet-selection", ((Object)((Object)this)).getClass().getDeclaredMethod("visitServletSelection", __signature));
            this.registerVisitor("proxy-config", ((Object)((Object)this)).getClass().getDeclaredMethod("visitProxyConfig", __signature));
            this.registerVisitor("context-param", ((Object)((Object)this)).getClass().getDeclaredMethod("visitContextParam", __signature));
            this.registerVisitor("display-name", ((Object)((Object)this)).getClass().getDeclaredMethod("visitDisplayName", __signature));
            this.registerVisitor("servlet", ((Object)((Object)this)).getClass().getDeclaredMethod("visitServlet", __signature));
            this.registerVisitor("servlet-mapping", ((Object)((Object)this)).getClass().getDeclaredMethod("visitServletMapping", __signature));
            this.registerVisitor("session-config", ((Object)((Object)this)).getClass().getDeclaredMethod("visitSessionConfig", __signature));
            this.registerVisitor("security-constraint", ((Object)((Object)this)).getClass().getDeclaredMethod("visitSecurityConstraint", __signature));
            this.registerVisitor("login-config", ((Object)((Object)this)).getClass().getDeclaredMethod("visitLoginConfig", __signature));
            this.registerVisitor("security-role", ((Object)((Object)this)).getClass().getDeclaredMethod("visitSecurityRole", __signature));
            this.registerVisitor("listener", ((Object)((Object)this)).getClass().getDeclaredMethod("visitListener", __signature));
            this.registerVisitor("distributable", ((Object)((Object)this)).getClass().getDeclaredMethod("visitDistributable", __signature));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void start(WebAppContext context, Descriptor descriptor) {
    }

    public void end(WebAppContext context, Descriptor descriptor) {
    }

    public void visitContextParam(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        String name = node.getString("param-name", false, true);
        String value = node.getString("param-value", false, true);
        context.getInitParams().put(name, value);
        if (LOG.isDebugEnabled()) {
            LOG.debug("ContextParam: " + name + "=" + value, new Object[0]);
        }
    }

    public void visitDisplayName(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        context.setDisplayName(node.toString(false, true));
    }

    public void visitServlet(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        String roleName;
        String servletName = node.getString("servlet-name", false, true);
        String servletClass = node.getString("servlet-class", false, true);
        SipAppContext appContext = this.getContext(context);
        SipServletHolder holder = appContext.getServletHandler().getHolder(servletName);
        if (holder == null) {
            holder = new SipServletHolder(Holder.Source.DESCRIPTOR);
            holder.setName(servletName);
            appContext.getServletHandler().addServlet(holder);
        }
        holder.setClassName(servletClass);
        Iterator params = node.iterator("init-param");
        while (params.hasNext()) {
            XmlParser.Node param = (XmlParser.Node)params.next();
            String pName = param.getString("param-name", false, true);
            String pValue = param.getString("param-value", false, true);
            holder.setInitParameter(pName, pValue);
        }
        XmlParser.Node startup = node.get("load-on-startup");
        if (startup != null) {
            String s = startup.toString(false, true);
            int order = 0;
            if (s != null && s.trim().length() > 0) {
                try {
                    order = Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    LOG.warn("Cannot parse load-on-startup " + s, new Object[0]);
                }
            }
            holder.setInitOrder(order);
        }
        Iterator sRefsIter = node.iterator("security-role-ref");
        while (sRefsIter.hasNext()) {
            XmlParser.Node securityRef = (XmlParser.Node)sRefsIter.next();
            roleName = securityRef.getString("role-name", false, true);
            String roleLink = securityRef.getString("role-link", false, true);
            if (roleName != null && roleName.length() > 0 && roleLink != null && roleLink.length() > 0) {
                holder.setUserRoleLink(roleName, roleLink);
                continue;
            }
            LOG.warn("Ignored invalid security-role-ref element: servlet-name=" + holder.getName() + ", " + securityRef, new Object[0]);
        }
        XmlParser.Node run_as = node.get("run-as");
        if (run_as != null && (roleName = run_as.getString("role-name", false, true)) != null) {
            holder.setRunAsRole(roleName);
        }
    }

    private SipAppContext getContext(WebAppContext context) {
        return (SipAppContext)context.getBean(SipAppContext.class);
    }

    public void visitServletMapping(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        String servletName = node.getString("servlet-name", false, true);
        SipServletMapping mapping = new SipServletMapping();
        XmlParser.Node pattern = node.get("pattern");
        XmlParser.Node start = null;
        Iterator it = pattern.iterator();
        while (it.hasNext() && start == null) {
            Object o = it.next();
            if (!(o instanceof XmlParser.Node)) continue;
            start = (XmlParser.Node)o;
        }
        MatchingRule rule = this.initRule(start);
        mapping.setServletName(servletName);
        mapping.setMatchingRule(rule);
        this.getContext(context).getServletHandler().addServletMapping(mapping);
    }

    public MatchingRule initRule(XmlParser.Node node) {
        String name = node.getTag();
        if ("and".equals(name)) {
            AndRule and = new AndRule();
            for (Object o : node) {
                if (!(o instanceof XmlParser.Node)) continue;
                and.addCriterion(this.initRule((XmlParser.Node)o));
            }
            return and;
        }
        if ("equal".equals(name)) {
            String var = node.getString("var", false, true);
            String value = node.getString("value", false, true);
            boolean ignoreCase = "true".equalsIgnoreCase(node.getAttribute("ignore-case"));
            return new EqualsRule(var, value, ignoreCase);
        }
        if ("subdomain-of".equals(name)) {
            String var = node.getString("var", false, true);
            String value = node.getString("value", false, true);
            return new SubdomainRule(var, value);
        }
        if ("or".equals(name)) {
            OrRule or = new OrRule();
            for (Object o : node) {
                if (!(o instanceof XmlParser.Node)) continue;
                or.addCriterion(this.initRule((XmlParser.Node)o));
            }
            return or;
        }
        if ("not".equals(name)) {
            NotRule not = new NotRule();
            for (Object o : node) {
                if (!(o instanceof XmlParser.Node)) continue;
                not.setCriterion(this.initRule((XmlParser.Node)o));
            }
            return not;
        }
        if ("contains".equals(name)) {
            String var = node.getString("var", false, true);
            String value = node.getString("value", false, true);
            boolean ignoreCase = "true".equalsIgnoreCase(node.getAttribute("ignore-case"));
            return new ContainsRule(var, value, ignoreCase);
        }
        if ("exists".equals(name)) {
            return new ExistsRule(node.getString("var", false, true));
        }
        throw new IllegalArgumentException("Unknown rule: " + name);
    }

    public void visitSessionConfig(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        XmlParser.Node tNode = node.get("session-timeout");
        if (tNode != null) {
            int timeout = Integer.parseInt(tNode.toString(false, true));
            this.getContext(context).getSessionHandler().getSessionManager().setSessionTimeout(timeout);
        }
    }

    public void visitAppName(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        this.getContext(context).getMetaData().setAppName(node.toString(false, true));
    }

    public void visitServletSelection(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        XmlParser.Node mainServlet = node.get("main-servlet");
        if (mainServlet != null) {
            this.getContext(context).getMetaData().setMainServletName(mainServlet.toString(false, true));
        } else {
            Iterator it = node.iterator("servlet-mapping");
            while (it.hasNext()) {
                this.visitServletMapping(context, descriptor, (XmlParser.Node)it.next());
            }
        }
    }

    public void visitProxyConfig(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        String s = node.getString("proxy-timeout", false, true);
        if (s == null) {
            s = node.getString("sequential-search-timeout", false, true);
        }
        if (s != null) {
            try {
                int timeout = Integer.parseInt(s);
                this.getContext(context).setProxyTimeout(timeout);
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid sequential-search-timeout value: " + s, new Object[0]);
            }
        }
    }

    public void visitListener(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        String className = node.getString("listener-class", false, true);
        try {
            if (className != null && className.length() > 0) {
                this.getContext(context).getMetaData().addListener(className);
            }
        }
        catch (Exception e) {
            LOG.warn("Could not instantiate listener " + className, (Throwable)e);
            return;
        }
    }

    public void visitDistributable(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        ((SipDescriptor)descriptor).setDistributable(true);
    }

    public void visitSecurityConstraint(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        Constraint scBase = new Constraint();
        ConstraintSecurityHandler securityHandler = (ConstraintSecurityHandler)this.getContext(context).getSecurityHandler();
        try {
            XmlParser.Node auths = node.get("auth-constraint");
            if (auths != null) {
                scBase.setAuthenticate(true);
                Iterator iter = auths.iterator("role-name");
                ArrayList<String> roles = new ArrayList<String>();
                while (iter.hasNext()) {
                    String role = ((XmlParser.Node)iter.next()).toString(false, true);
                    roles.add(role);
                }
                scBase.setRoles(roles.toArray(new String[roles.size()]));
            }
            scBase.setProxyMode(node.get("proxy-authentication") != null);
            XmlParser.Node data = node.get("user-data-constraint");
            if (data != null) {
                String guarantee = (data = data.get("transport-guarantee")).toString(false, true).toUpperCase();
                if (guarantee == null || guarantee.length() == 0 || "NONE".equals(guarantee)) {
                    scBase.setUserDataConstraint(UserDataConstraint.None);
                } else if ("INTEGRAL".equals(guarantee)) {
                    scBase.setUserDataConstraint(UserDataConstraint.Integral);
                } else if ("CONFIDENTIAL".equals(guarantee)) {
                    scBase.setUserDataConstraint(UserDataConstraint.Confidential);
                } else {
                    LOG.warn("Unknown user-data-constraint:" + guarantee, new Object[0]);
                    scBase.setUserDataConstraint(UserDataConstraint.Confidential);
                }
            }
            Iterator iter = node.iterator("resource-collection");
            while (iter.hasNext()) {
                XmlParser.Node collection = (XmlParser.Node)iter.next();
                String name = collection.getString("resource-name", false, true);
                Constraint sc = (Constraint)((Object)scBase.clone());
                sc.setName(name);
                Iterator iter3 = collection.iterator("sip-method");
                ArrayList<String> methods = null;
                if (iter3.hasNext()) {
                    methods = new ArrayList<String>();
                    while (iter3.hasNext()) {
                        methods.add(((XmlParser.Node)iter3.next()).toString(false, true));
                    }
                }
                iter3 = collection.iterator("servlet-name");
                ArrayList<String> servletNames = null;
                if (iter3.hasNext()) {
                    servletNames = new ArrayList<String>();
                    while (iter3.hasNext()) {
                        servletNames.add(((XmlParser.Node)iter3.next()).toString(false, true));
                    }
                }
                ConstraintMapping mapping = new ConstraintMapping();
                mapping.setServletNames(servletNames);
                mapping.setMethods(methods);
                mapping.setConstraint(sc);
                securityHandler.addConstraintMapping(mapping);
            }
        }
        catch (CloneNotSupportedException e) {
            LOG.warn((Throwable)e);
        }
    }

    public void visitLoginConfig(WebAppContext context, Descriptor descriptor, XmlParser.Node node) throws Exception {
        XmlParser.Node name;
        SipSecurityHandler<?> securityHandler = this.getContext(context).getSecurityHandler();
        XmlParser.Node method = node.get("auth-method");
        if (method != null) {
            securityHandler.setAuthMethod(method.toString(false, true));
        }
        String nameStr = (name = node.get("realm-name")) == null ? "default" : name.toString(false, true);
        securityHandler.setRealmName(nameStr);
        XmlParser.Node identityAssertion = node.get("identity-assertion");
        if (identityAssertion != null) {
            String scheme = identityAssertion.getString("identity-assertion-scheme", false, true);
            securityHandler.setIdentityAssertionScheme(SipSecurityHandler.IdentityAssertionScheme.getByName(scheme));
            String supported = identityAssertion.getString("identity-assertion-support", false, true);
            securityHandler.setIdentityAssertionRequired("REQUIRED".equalsIgnoreCase(supported));
        }
    }

    public void visitSecurityRole(WebAppContext context, Descriptor descriptor, XmlParser.Node node) {
        XmlParser.Node roleNode = node.get("role-name");
        String role = roleNode.toString(false, true);
        ConstraintSecurityHandler securityHandler = (ConstraintSecurityHandler)this.getContext(context).getSecurityHandler();
        securityHandler.addRole(role);
    }
}

