/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.sipapp;

import java.io.IOException;
import java.net.MalformedURLException;
import org.cipango.server.servlet.SipServletHandler;
import org.cipango.server.sipapp.SipAppContext;
import org.cipango.server.sipapp.StandardDescriptorProcessor;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.DescriptorProcessor;
import org.eclipse.jetty.webapp.WebAppContext;

public class SipXmlConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(SipXmlConfiguration.class);

    public void preConfigure(WebAppContext context) throws Exception {
        Resource sipXml;
        SipAppContext sac = (SipAppContext)context.getBean(SipAppContext.class);
        if (sac == null) {
            sac = new SipAppContext();
            sac.setWebAppContext(context);
            context.addBean((Object)sac);
        } else {
            sac.setWebAppContext(context);
        }
        String defaultsSipDescriptor = sac.getDefaultsDescriptor();
        if (defaultsSipDescriptor != null && defaultsSipDescriptor.length() > 0) {
            Resource dftSipResource = Resource.newSystemResource((String)defaultsSipDescriptor);
            if (dftSipResource == null) {
                dftSipResource = context.newResource(defaultsSipDescriptor);
            }
            sac.getMetaData().setDefaults(dftSipResource);
        }
        if ((sipXml = this.findSipXml(context)) != null) {
            sac.getMetaData().setSipXml(sipXml);
        }
        for (String overrideDescriptor : sac.getOverrideDescriptors()) {
            if (overrideDescriptor == null || overrideDescriptor.length() <= 0) continue;
            Resource orideResource = Resource.newSystemResource((String)overrideDescriptor);
            if (orideResource == null) {
                orideResource = context.newResource(overrideDescriptor);
            }
            sac.getMetaData().addOverride(orideResource);
        }
    }

    public void configure(WebAppContext context) throws Exception {
        SipAppContext sac = (SipAppContext)context.getBean(SipAppContext.class);
        sac.getMetaData().addDescriptorProcessor((DescriptorProcessor)new StandardDescriptorProcessor());
    }

    public void deconfigure(WebAppContext context) throws Exception {
        SipAppContext sac = (SipAppContext)context.getBean(SipAppContext.class);
        SipServletHandler servletHandler = sac.getServletHandler();
        servletHandler.setServlets(null);
        servletHandler.setServletMappings(null);
        context.setEventListeners(null);
    }

    protected Resource findSipXml(WebAppContext context) throws IOException, MalformedURLException {
        Resource webInf = context.getWebInf();
        if (webInf != null && webInf.isDirectory()) {
            Resource sip = webInf.addPath("sip.xml");
            if (sip.exists()) {
                return sip;
            }
            LOG.debug("No WEB-INF/sip.xml in " + context.getWar(), new Object[0]);
        }
        return null;
    }
}

