/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.sipapp;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.AuthInfo;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipApplicationSessionAttributeListener;
import javax.servlet.sip.SipApplicationSessionListener;
import javax.servlet.sip.SipErrorListener;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletContextEvent;
import javax.servlet.sip.SipServletListener;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipSessionAttributeListener;
import javax.servlet.sip.SipSessionListener;
import javax.servlet.sip.SipSessionsUtil;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TimerListener;
import javax.servlet.sip.TimerService;
import javax.servlet.sip.URI;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;
import org.cipango.server.SipConnector;
import org.cipango.server.SipMessage;
import org.cipango.server.SipRequest;
import org.cipango.server.SipServer;
import org.cipango.server.handler.SipHandlerWrapper;
import org.cipango.server.log.event.Events;
import org.cipango.server.security.AuthInfoImpl;
import org.cipango.server.security.ConstraintSecurityHandler;
import org.cipango.server.security.SipSecurityHandler;
import org.cipango.server.servlet.SipDispatcher;
import org.cipango.server.servlet.SipServletHandler;
import org.cipango.server.servlet.SipServletHolder;
import org.cipango.server.session.ApplicationSession;
import org.cipango.server.session.Session;
import org.cipango.server.session.SessionHandler;
import org.cipango.server.session.SessionManager;
import org.cipango.server.session.http.ConvergedSessionManager;
import org.cipango.server.session.scoped.ScopedAppSession;
import org.cipango.server.session.scoped.ScopedTimer;
import org.cipango.server.sipapp.MetaData;
import org.cipango.server.sipapp.ServletContextProxy;
import org.cipango.server.util.ReadOnlySipURI;
import org.cipango.sip.AddressImpl;
import org.cipango.sip.ParameterableImpl;
import org.cipango.sip.SipHeader;
import org.cipango.sip.SipMethod;
import org.cipango.sip.SipURIImpl;
import org.cipango.sip.URIFactory;
import org.cipango.util.StringUtil;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.WebAppContext;

@ManagedObject(value="SIP application context")
public class SipAppContext
extends SipHandlerWrapper {
    private static final Logger LOG = Log.getLogger(SipAppContext.class);
    public static final int VERSION_10 = 10;
    public static final int VERSION_11 = 11;
    public static final String[] EXTENSIONS = new String[]{"MESSAGE", "INFO", "SUBSCRIBE", "NOTIFY", "UPDATE", "PUBLISH", "REFER", "100rel"};
    public static final String[] SUPPORTED_RFC = new String[]{"2976", "3261", "3262", "3263", "3265", "3311", "3327", "3428", "3515", "3903", "5658", "6026"};
    public static final String EXTERNAL_INTERFACES = "org.cipango.externalOutboundInterfaces";
    public static final String SIP_DEFAULTS_XML = "org/cipango/server/sipapp/sipdefault.xml";
    private static final ThreadLocal<SipAppContext> __context = new ThreadLocal();
    private String _name;
    private String _defaultsDescriptor = "org/cipango/server/sipapp/sipdefault.xml";
    private final List<String> _overrideDescriptors = new ArrayList<String>();
    private int _proxyTimeout = -1;
    private final SessionHandler _sessionHandler;
    private SipServletHandler _servletHandler;
    private SipSecurityHandler<?> _securityHandler;
    private int _specVersion;
    private WebAppContext _context;
    private ServletContext _sContext;
    private MetaData _metaData;
    private final List<TimerListener> _timerListeners = new CopyOnWriteArrayList<TimerListener>();
    private final List<SipErrorListener> _errorListeners = new CopyOnWriteArrayList<SipErrorListener>();
    private final List<SipServletListener> _servletListeners = new CopyOnWriteArrayList<SipServletListener>();
    private final List<ServletContextListener> _contextListeners = new CopyOnWriteArrayList<ServletContextListener>();
    private final SipFactory _sipFactory;
    private TimerService _timerService;
    private SipSessionsUtil _sipSessionsUtil = new SessionUtil();
    protected final List<Decorator> _decorators = new ArrayList<Decorator>();
    private String _id;
    private ServerListener _serverListener;
    private Throwable _unavailableException;

    public static SipAppContext getCurrentContext() {
        return __context.get();
    }

    public SipAppContext() {
        this._sessionHandler = new SessionHandler();
        this._servletHandler = new SipServletHandler();
        this._securityHandler = new ConstraintSecurityHandler();
        this._metaData = new MetaData();
        this._sipFactory = new Factory();
        this._timerService = new TimerServiceImpl();
    }

    protected void doStart() throws Exception {
        ClassLoader oldClassLoader = null;
        Thread currentThread = null;
        SipAppContext oldContext = __context.get();
        try {
            if (this.getClassLoader() != null) {
                currentThread = Thread.currentThread();
                oldClassLoader = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(this.getClassLoader());
            }
            __context.set(this);
            this.relinkHandlers();
            this._metaData.resolve(this);
            super.doStart();
            if (!this._contextListeners.isEmpty()) {
                ServletContextEvent sce = new ServletContextEvent(this.getServletContext());
                for (ServletContextListener listener : this._contextListeners) {
                    listener.contextInitialized(sce);
                }
            }
            this._servletHandler.initialize();
            for (Decorator decorator : this._decorators) {
                if (this.getServletHandler().getServlets() == null) continue;
                for (SipServletHolder holder : this.getServletHandler().getServlets()) {
                    decorator.decorateServletHolder(holder);
                }
            }
        }
        catch (Throwable e) {
            if (this._name == null) {
                this.setName(this.getDefaultName());
            }
            LOG.warn("Failed to start SipAppContext {}: {}", new Object[]{this.getName(), e});
            this._unavailableException = e;
            if (this._context != null) {
                this._context.setAvailable(false);
            }
            throw e;
        }
        finally {
            __context.set(oldContext);
            if (currentThread != null && oldClassLoader != null) {
                currentThread.setContextClassLoader(oldClassLoader);
            }
            if (this.isAvailable()) {
                if (this.getServer().isStarted()) {
                    this.serverStarted();
                }
            } else {
                Throwable exception = this._unavailableException;
                if (exception == null) {
                    exception = this._context.getUnavailableException();
                }
                Events.fire(2, "Unable to deploy application " + this.getName() + ": " + exception);
            }
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.getServer() != null && this._serverListener != null) {
            this.getServer().removeLifeCycleListener((LifeCycle.Listener)this._serverListener);
        }
        this._serverListener = null;
        this._unavailableException = null;
    }

    private void relinkHandlers() {
        SipHandlerWrapper wrapper;
        SipHandlerWrapper handler = this;
        while (handler.getHandler() instanceof HandlerWrapper && !((wrapper = (SipHandlerWrapper)handler.getHandler()) instanceof SessionHandler)) {
            handler = wrapper;
        }
        if (this.getSessionHandler() != null) {
            handler.setHandler(this._sessionHandler);
            handler = this._sessionHandler;
        }
        if (this.getSecurityHandler() != null) {
            handler.setHandler(this._securityHandler);
            handler = this._securityHandler;
        }
        if (this.getServletHandler() != null) {
            handler.setHandler(this._servletHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverStarted() {
        ClassLoader oldClassLoader = null;
        Thread currentThread = null;
        if (this.getClassLoader() != null) {
            currentThread = Thread.currentThread();
            oldClassLoader = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(this.getClassLoader());
        }
        try {
            SipServletHolder[] holders;
            ArrayList<ReadOnlySipURI> outbounds = new ArrayList<ReadOnlySipURI>();
            ArrayList<ReadOnlySipURI> externals = new ArrayList<ReadOnlySipURI>();
            SipConnector[] connectors = this.getServer().getConnectors();
            if (connectors != null) {
                for (SipConnector connector : connectors) {
                    SipURIImpl uri = new SipURIImpl(null, connector.getAddress().getHostAddress(), connector.getPort());
                    if (!outbounds.contains(uri)) {
                        outbounds.add(new ReadOnlySipURI((SipURI)uri));
                    }
                    if (externals.contains(connector.getURI())) continue;
                    externals.add(new ReadOnlySipURI(connector.getURI()));
                }
            }
            if (this._context != null) {
                this._context.setAttribute("javax.servlet.sip.outboundInterfaces", Collections.unmodifiableList(outbounds));
                this._context.setAttribute(EXTERNAL_INTERFACES, Collections.unmodifiableList(externals));
            }
            if ((holders = this.getServletHandler().getServlets()) != null) {
                for (SipServletHolder holder : holders) {
                    if (holder.getServletInstance() == null || !(holder.getServletInstance() instanceof SipServlet)) continue;
                    this.fireServletInitialized((SipServlet)holder.getServletInstance());
                }
            }
        }
        finally {
            if (this.getClassLoader() != null) {
                currentThread.setContextClassLoader(oldClassLoader);
            }
        }
    }

    public void fireServletInitialized(SipServlet servlet) {
        for (SipServletListener l : this._servletListeners) {
            try {
                l.servletInitialized(new SipServletContextEvent(servlet.getServletContext(), servlet));
            }
            catch (Throwable t) {
                LOG.debug(t);
            }
        }
    }

    public void setWebAppContext(WebAppContext context) {
        if (this._context != context) {
            this._context = context;
            context.addBean((Object)this, false);
            this._context.setAttribute("javax.servlet.sip.100rel", (Object)Boolean.TRUE);
            this._context.setAttribute("javax.servlet.sip.SipFactory", (Object)this.getSipFactory());
            this._context.setAttribute("javax.servlet.sip.TimerService", (Object)this.getTimerService());
            this._context.setAttribute("javax.servlet.sip.SipSessionsUtil", (Object)this.getSipSessionsUtil());
            this._context.setAttribute("javax.servlet.sip.supported", Collections.unmodifiableList(Arrays.asList(EXTENSIONS)));
            this._context.setAttribute("javax.servlet.sip.supportedRfcs", Collections.unmodifiableList(Arrays.asList(SUPPORTED_RFC)));
            this._context.addBean((Object)new AbstractLifeCycle(){

                protected void doStart() throws Exception {
                    SipAppContext.this._context.addEventListener((EventListener)new ServletContextListener(){

                        public void contextInitialized(ServletContextEvent sce) {
                            try {
                                SipAppContext.this.start();
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }

                        public void contextDestroyed(ServletContextEvent sce) {
                            try {
                                SipAppContext.this.stop();
                            }
                            catch (Exception e) {
                                LOG.warn("Failed to stop SipAppContext " + SipAppContext.this.getName(), (Throwable)e);
                            }
                        }
                    });
                }
            });
            this._sContext = new SContext((ServletContext)this._context.getServletContext());
            if (context.getConfigurations() == null && context.getConfigurationClasses() == WebAppContext.getDefaultConfigurationClasses()) {
                String[] classes = (String[])ArrayUtil.addToArray((Object[])WebAppContext.getDefaultConfigurationClasses(), (Object)"org.cipango.server.sipapp.SipXmlConfiguration", String.class);
                context.setConfigurationClasses(classes);
            }
        }
    }

    public void setWebAppContext(WebAppContext context, boolean converged) {
        this.setWebAppContext(context);
        if (converged) {
            context.setSessionHandler((org.eclipse.jetty.server.session.SessionHandler)new org.cipango.server.session.http.SessionHandler(new ConvergedSessionManager()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(SipMessage message) throws IOException, ServletException {
        if (!this.isAvailable() && message instanceof SipServletRequest) {
            SipServletResponse response = ((SipServletRequest)message).createResponse(503);
            response.addHeader(SipHeader.REASON.asString(), "Application " + this.getName() + " unavailable");
            response.send();
            return;
        }
        ClassLoader oldClassLoader = null;
        Thread currentThread = null;
        if (this.getClassLoader() != null) {
            currentThread = Thread.currentThread();
            oldClassLoader = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(this.getClassLoader());
        }
        try {
            super.handle(message);
        }
        finally {
            if (this.getClassLoader() != null) {
                currentThread.setContextClassLoader(oldClassLoader);
            }
        }
    }

    public ServletContext getServletContext() {
        return this._sContext;
    }

    public void setName(String name) {
        this._name = name;
        if (this._name != null) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte[] bytes = md.digest(name.getBytes(StringUtil.__UTF8_CHARSET));
                int i = 0;
                for (byte b : bytes) {
                    i = i * 33 + b;
                }
                this._id = StringUtil.toBase62String2((int)Math.abs(i)).substring(0, 3);
            }
            catch (Exception e) {
                LOG.warn("Unable to create ID", (Throwable)e);
            }
        }
    }

    @ManagedAttribute(value="Name", readonly=true)
    public String getName() {
        return this._name;
    }

    @ManagedAttribute(value="Context ID")
    public String getContextId() {
        return this._id;
    }

    public String getDefaultName() {
        String name;
        String string = name = this._context == null ? null : this._context.getContextPath();
        if (name != null && name.startsWith("/")) {
            name = name.substring(1);
        }
        return name;
    }

    public EventListener[] getEventListeners() {
        return this._context.getEventListeners();
    }

    public void addEventListener(EventListener listener) {
        if (this._context != null) {
            this._context.addEventListener(listener);
        }
        if (listener instanceof TimerListener) {
            this._timerListeners.add((TimerListener)listener);
        }
        if (listener instanceof SipErrorListener) {
            this._errorListeners.add((SipErrorListener)listener);
        }
        if (listener instanceof SipServletListener) {
            this._servletListeners.add((SipServletListener)listener);
        }
        if (listener instanceof ServletContextListener) {
            this._contextListeners.add((ServletContextListener)listener);
        }
        if ((listener instanceof SipApplicationSessionAttributeListener || listener instanceof SipSessionListener || listener instanceof SipSessionAttributeListener || listener instanceof SipApplicationSessionListener) && this._sessionHandler != null) {
            this._sessionHandler.addEventListener(listener);
        }
    }

    public void removeEventListener(EventListener listener) {
        if (this._context != null) {
            this._context.removeEventListener(listener);
        }
        if (listener instanceof TimerListener) {
            this._timerListeners.remove((TimerListener)listener);
        }
        if (listener instanceof SipErrorListener) {
            this._errorListeners.remove((SipErrorListener)listener);
        }
        if (listener instanceof SipServletListener) {
            this._servletListeners.remove((SipServletListener)listener);
        }
        if ((listener instanceof SipApplicationSessionAttributeListener || listener instanceof SipSessionListener || listener instanceof SipSessionAttributeListener || listener instanceof SipApplicationSessionListener) && this._sessionHandler != null) {
            this._sessionHandler.removeEventListener(listener);
        }
    }

    public void setEventListeners(EventListener[] eventListeners) {
        if (this._context != null) {
            this._context.setEventListeners(eventListeners);
        }
        if (this._sessionHandler != null) {
            this._sessionHandler.clearEventListeners();
        }
        this._timerListeners.clear();
        this._errorListeners.clear();
        this._servletListeners.clear();
        if (eventListeners != null) {
            for (EventListener listener : eventListeners) {
                this.addEventListener(listener);
            }
        }
    }

    public ClassLoader getClassLoader() {
        if (this.getWebAppContext() == null) {
            return null;
        }
        return this.getWebAppContext().getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire(ApplicationSession applicationSession, List<? extends EventListener> listeners, Method method, Object ... args) {
        ClassLoader oldClassLoader = null;
        Thread currentThread = null;
        if (this.getClassLoader() != null) {
            currentThread = Thread.currentThread();
            oldClassLoader = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(this.getClassLoader());
        }
        SessionManager.ApplicationSessionScope scope = null;
        if (applicationSession != null) {
            scope = applicationSession.getSessionManager().openScope(applicationSession);
        }
        try {
            for (EventListener eventListener : listeners) {
                try {
                    method.invoke((Object)eventListener, args);
                }
                catch (Throwable t) {
                    LOG.warn("Failed to invoke listener " + eventListener, t);
                }
            }
        }
        finally {
            if (scope != null) {
                scope.close();
            }
            if (this.getClassLoader() != null) {
                currentThread.setContextClassLoader(oldClassLoader);
            }
        }
    }

    public int getProxyTimeout() {
        return this._proxyTimeout;
    }

    public void setProxyTimeout(int proxyTimeout) {
        this._proxyTimeout = proxyTimeout;
    }

    public String getDefaultsDescriptor() {
        return this._defaultsDescriptor;
    }

    public void setDefaultsDescriptor(String defaultsDescriptor) {
        this._defaultsDescriptor = defaultsDescriptor;
    }

    public String getOverrideDescriptor() {
        if (this._overrideDescriptors.size() != 1) {
            return null;
        }
        return this._overrideDescriptors.get(0);
    }

    public void setOverrideDescriptor(String overrideDescriptor) {
        this._overrideDescriptors.clear();
        this._overrideDescriptors.add(overrideDescriptor);
    }

    public List<String> getOverrideDescriptors() {
        return this._overrideDescriptors;
    }

    @ManagedAttribute(value="Web app context", readonly=true)
    public WebAppContext getWebAppContext() {
        return this._context;
    }

    @ManagedAttribute(value="specification version", readonly=true)
    public int getSpecVersion() {
        return this._specVersion;
    }

    @ManagedAttribute(value="specification version", readonly=true)
    public String getSpecVersionAsString() {
        if (this._specVersion == 10) {
            return "1.0";
        }
        if (this._specVersion == 11) {
            return "1.1";
        }
        return "Unknown";
    }

    public void setSpecVersion(int specVersion) {
        this._specVersion = specVersion;
    }

    @ManagedAttribute(value="context servlet handler", readonly=true)
    public SipServletHandler getServletHandler() {
        return this._servletHandler;
    }

    public boolean hasSipServlets() {
        SipServletHolder[] holders = this.getServletHandler().getServlets();
        return holders != null && holders.length != 0;
    }

    public void addDecorator(Decorator decorator) {
        this._decorators.add(decorator);
        this._context.addDecorator((ServletContextHandler.Decorator)decorator);
    }

    public MetaData getMetaData() {
        return this._metaData;
    }

    public SipFactory getSipFactory() {
        return this._sipFactory;
    }

    public TimerService getTimerService() {
        return this._timerService;
    }

    public SipSessionsUtil getSipSessionsUtil() {
        return this._sipSessionsUtil;
    }

    @ManagedAttribute(value="context session handler", readonly=true)
    public SessionHandler getSessionHandler() {
        return this._sessionHandler;
    }

    @ManagedAttribute(value="context security handler", readonly=true)
    public SipSecurityHandler<?> getSecurityHandler() {
        return this._securityHandler;
    }

    public List<TimerListener> getTimerListeners() {
        return this._timerListeners;
    }

    public List<SipErrorListener> getSipErrorListeners() {
        return this._errorListeners;
    }

    @ManagedAttribute
    public Throwable getUnavailableException() {
        return this._unavailableException;
    }

    @ManagedAttribute
    public boolean isAvailable() {
        return this._unavailableException == null && (this._context == null || this._context.isStarted() && this._context.isAvailable());
    }

    @Override
    public void setServer(SipServer server) {
        super.setServer(server);
        this._serverListener = new ServerListener();
        server.addLifeCycleListener((LifeCycle.Listener)this._serverListener);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + this.getName();
    }

    public static interface Decorator
    extends ServletContextHandler.Decorator {
        public void decorateServletHolder(SipServletHolder var1) throws ServletException;
    }

    private class ServerListener
    extends AbstractLifeCycle.AbstractLifeCycleListener {
        private ServerListener() {
        }

        public void lifeCycleStarted(LifeCycle event) {
            SipAppContext.this.serverStarted();
        }
    }

    private class TimerServiceImpl
    implements TimerService {
        private TimerServiceImpl() {
        }

        public ServletTimer createTimer(SipApplicationSession session, long delay, boolean isPersistent, Serializable info) {
            ApplicationSession appSession = ((SessionManager.AppSessionIf)session).getAppSession();
            return new ScopedTimer(appSession, delay, isPersistent, info);
        }

        public ServletTimer createTimer(SipApplicationSession session, long delay, long period, boolean fixedDelay, boolean isPersistent, Serializable info) {
            ApplicationSession appSession = ((SessionManager.AppSessionIf)session).getAppSession();
            return new ScopedTimer(appSession, delay, period, fixedDelay, isPersistent, info);
        }
    }

    private class Factory
    implements SipFactory {
        private Factory() {
        }

        public Address createAddress(String address) throws ServletParseException {
            try {
                AddressImpl addr = new AddressImpl(address);
                addr.parse();
                return addr;
            }
            catch (ParseException e) {
                throw new ServletParseException((Throwable)e);
            }
        }

        public Address createAddress(URI uri) {
            return new AddressImpl(uri);
        }

        public Address createAddress(URI uri, String displayName) {
            AddressImpl addr = new AddressImpl(uri);
            addr.setDisplayName(displayName);
            return addr;
        }

        public SipApplicationSession createApplicationSession() {
            return new ScopedAppSession(SipAppContext.this.getSessionHandler().getSessionManager().createApplicationSession());
        }

        public SipApplicationSession createApplicationSessionByKey(String key) {
            String id;
            SessionManager manager = SipAppContext.this._sessionHandler.getSessionManager();
            ApplicationSession appSession = manager.getApplicationSession(id = manager.getApplicationSessionIdByKey(key));
            if (appSession == null) {
                appSession = manager.createApplicationSession(id);
            }
            return new ScopedAppSession(appSession);
        }

        public AuthInfo createAuthInfo() {
            return new AuthInfoImpl();
        }

        public Parameterable createParameterable(String s) throws ServletParseException {
            try {
                return new ParameterableImpl(s);
            }
            catch (ParseException e) {
                throw new ServletParseException((Throwable)e);
            }
        }

        public SipServletRequest createRequest(SipServletRequest srcRequest, boolean sameCallId) {
            SipRequest origRequest = (SipRequest)srcRequest;
            ApplicationSession appSession = origRequest.appSession();
            Address local = (Address)origRequest.getFrom().clone();
            local.setParameter("tag", appSession.newUASTag());
            Address remote = origRequest.to().clone();
            remote.removeParameter("tag");
            String callId = null;
            callId = sameCallId ? origRequest.getCallId() : appSession.getSessionManager().newCallId();
            Session session = appSession.createUacSession(callId, local, remote);
            session.setHandler(SipAppContext.this.getServletHandler().getDefaultServlet());
            SipRequest request = session.getUa().createRequest((SipRequest)srcRequest);
            request.setRoutingDirective(SipApplicationRoutingDirective.CONTINUE, srcRequest);
            return request;
        }

        public SipServletRequest createRequest(SipApplicationSession sipAppSession, String method, Address from, Address to) {
            ApplicationSession appSession = ((SessionManager.AppSessionIf)sipAppSession).getAppSession();
            SipMethod sipMethod = SipMethod.get((String)method);
            if (sipMethod == SipMethod.ACK || sipMethod == SipMethod.CANCEL) {
                throw new IllegalArgumentException("Method cannot be ACK nor CANCEL");
            }
            Address local = (Address)from.clone();
            Address remote = (Address)to.clone();
            local.setParameter("tag", appSession.newUASTag());
            remote.removeParameter("tag");
            String cid = appSession.getSessionManager().newCallId();
            Session session = appSession.createUacSession(cid, local, remote);
            session.setHandler(SipAppContext.this.getServletHandler().getDefaultServlet());
            SipRequest request = (SipRequest)session.createRequest(method);
            request.setRoutingDirective(SipApplicationRoutingDirective.NEW, null);
            return request;
        }

        public SipServletRequest createRequest(SipApplicationSession appSession, String method, URI from, URI to) {
            return this.createRequest(appSession, method, this.createAddress(from), this.createAddress(to));
        }

        public SipServletRequest createRequest(SipApplicationSession appSession, String method, String from, String to) throws ServletParseException {
            return this.createRequest(appSession, method, this.createAddress(from), this.createAddress(to));
        }

        public SipURI createSipURI(String user, String host) {
            return new SipURIImpl(user, host, -1);
        }

        public URI createURI(String uri) throws ServletParseException {
            try {
                return URIFactory.parseURI((String)uri);
            }
            catch (ParseException e) {
                throw new ServletParseException((Throwable)e);
            }
        }
    }

    private class SessionUtil
    implements SipSessionsUtil {
        private SessionUtil() {
        }

        public SipApplicationSession getApplicationSessionById(String id) {
            return new ScopedAppSession(SipAppContext.this.getSessionHandler().getSessionManager().getApplicationSession(id));
        }

        public SipApplicationSession getApplicationSessionByKey(String key, boolean create) {
            String id;
            if (key == null) {
                throw new NullPointerException("Null key");
            }
            SessionManager manager = SipAppContext.this._sessionHandler.getSessionManager();
            ApplicationSession appSession = manager.getApplicationSession(id = manager.getApplicationSessionIdByKey(key));
            if (appSession == null && !create) {
                return null;
            }
            if (appSession == null) {
                appSession = manager.createApplicationSession(id);
            }
            return new ScopedAppSession(appSession);
        }

        public SipSession getCorrespondingSipSession(SipSession session, String headerName) {
            return null;
        }
    }

    class SContext
    extends ServletContextProxy {
        public SContext(ServletContext servletContext) {
            super((ServletContext)SipAppContext.this._context.getServletContext());
        }

        @Override
        public RequestDispatcher getNamedDispatcher(String name) {
            SipServletHolder holder;
            if (SipAppContext.this._servletHandler != null && (holder = SipAppContext.this._servletHandler.getHolder(name)) != null) {
                return new SipDispatcher(SipAppContext.this, holder);
            }
            return super.getNamedDispatcher(name);
        }

        @Override
        public String getServerInfo() {
            return "Cipango-3.0";
        }
    }
}

