/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.session.scoped;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.URI;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;
import org.cipango.server.session.ApplicationSession;
import org.cipango.server.session.Session;
import org.cipango.server.session.SessionManager;
import org.cipango.server.session.scoped.ScopedAppSession;
import org.cipango.server.session.scoped.ScopedObject;

public class ScopedSession
extends ScopedObject
implements SessionManager.SipSessionIf,
Serializable {
    private static final long serialVersionUID = 1L;
    private Session _session;

    public ScopedSession(Session session) {
        this._session = session;
    }

    public SipServletRequest createRequest(String method) {
        return this._session.createRequest(method);
    }

    public SipApplicationSession getApplicationSession() {
        return new ScopedAppSession(this._session.appSession());
    }

    public Object getAttribute(String name) {
        return this._session.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this._session.getAttributeNames();
    }

    public String getCallId() {
        return this._session.getCallId();
    }

    public long getCreationTime() {
        return this._session.getCreationTime();
    }

    public String getId() {
        return this._session.getId();
    }

    public boolean getInvalidateWhenReady() {
        return this._session.getInvalidateWhenReady();
    }

    public long getLastAccessedTime() {
        return this._session.getLastAccessedTime();
    }

    public Address getLocalParty() {
        return this._session.getLocalParty();
    }

    public SipApplicationRoutingRegion getRegion() {
        return this._session.getRegion();
    }

    public Address getRemoteParty() {
        return this._session.getRemoteParty();
    }

    public ServletContext getServletContext() {
        return this._session.getServletContext();
    }

    public SipSession.State getState() {
        return this._session.getState();
    }

    public URI getSubscriberURI() {
        return this._session.getSubscriberURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        try (SessionManager.ApplicationSessionScope scope = this.openScope();){
            this._session.invalidate();
        }
    }

    public boolean isReadyToInvalidate() {
        return this._session.isReadyToInvalidate();
    }

    public boolean isValid() {
        return this._session.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        try (SessionManager.ApplicationSessionScope scope = this.openScope();){
            this._session.removeAttribute(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        try (SessionManager.ApplicationSessionScope scope = this.openScope();){
            this._session.setAttribute(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHandler(String name) throws ServletException {
        try (SessionManager.ApplicationSessionScope scope = this.openScope();){
            this._session.setHandler(name);
        }
    }

    public void setInvalidateWhenReady(boolean invalidateWhenReady) {
        this._session.setInvalidateWhenReady(invalidateWhenReady);
    }

    public void setOutboundInterface(InetAddress address) {
        this._session.setOutboundInterface(address);
    }

    public void setOutboundInterface(InetSocketAddress address) {
        this._session.setOutboundInterface(address);
    }

    @Override
    public Session getSession() {
        return this._session;
    }

    public String toString() {
        return this._session.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SessionManager.SipSessionIf)) {
            return false;
        }
        return this._session.equals(((SessionManager.SipSessionIf)o).getSession());
    }

    public int hashCode() {
        return this._session.hashCode();
    }

    @Override
    protected ApplicationSession getAppSession() {
        return this._session.appSession();
    }
}

