/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.session.scoped;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.URI;
import org.cipango.server.session.ApplicationSession;
import org.cipango.server.session.Session;
import org.cipango.server.session.SessionManager;
import org.cipango.server.session.scoped.ScopedObject;
import org.cipango.server.session.scoped.ScopedSession;
import org.cipango.server.session.scoped.ScopedTimer;

public class ScopedAppSession
extends ScopedObject
implements SessionManager.AppSessionIf,
Serializable {
    private static final long serialVersionUID = 1L;
    protected ApplicationSession _appSession;

    public ScopedAppSession(ApplicationSession appSession) {
        this._appSession = appSession;
    }

    public void encodeURI(URI uri) {
        this._appSession.encodeURI(uri);
    }

    public URL encodeURL(URL url) {
        return this._appSession.encodeURL(url);
    }

    public String getApplicationName() {
        return this._appSession.getApplicationName();
    }

    public Object getAttribute(String name) {
        return this._appSession.getAttribute(name);
    }

    public Iterator<String> getAttributeNames() {
        return this._appSession.getAttributeNames();
    }

    public long getCreationTime() {
        return this._appSession.getCreationTime();
    }

    public long getExpirationTime() {
        return this._appSession.getExpirationTime();
    }

    public String getId() {
        return this._appSession.getId();
    }

    public boolean getInvalidateWhenReady() {
        return this._appSession.getInvalidateWhenReady();
    }

    public long getLastAccessedTime() {
        return this._appSession.getLastAccessedTime();
    }

    public Object getSession(String id, SipApplicationSession.Protocol protocol) {
        Object session = this._appSession.getSession(id, protocol);
        if (session instanceof Session) {
            return new ScopedSession((Session)session);
        }
        return session;
    }

    public Iterator<?> getSessions() {
        ArrayList<ScopedSession> list = new ArrayList<ScopedSession>();
        Iterator<?> it = this._appSession.getSessions();
        while (it.hasNext()) {
            Object session = it.next();
            if (session instanceof Session) {
                list.add(new ScopedSession((Session)session));
                continue;
            }
            list.add((ScopedSession)session);
        }
        return list.iterator();
    }

    public Iterator<?> getSessions(String protocol) {
        Iterator<?> it = this._appSession.getSessions(protocol);
        if (SipApplicationSession.Protocol.SIP.toString().equalsIgnoreCase(protocol)) {
            ArrayList<ScopedSession> list = new ArrayList<ScopedSession>();
            while (it.hasNext()) {
                Session session = (Session)it.next();
                list.add(new ScopedSession(session));
            }
            return list.iterator();
        }
        return it;
    }

    public SipSession getSipSession(String id) {
        Session session = (Session)this._appSession.getSipSession(id);
        if (session != null) {
            return new ScopedSession(session);
        }
        return null;
    }

    public ServletTimer getTimer(String id) {
        ServletTimer timer = this._appSession.getTimer(id);
        if (timer != null) {
            return new ScopedTimer(timer);
        }
        return null;
    }

    public Collection<ServletTimer> getTimers() {
        Iterator<ServletTimer> it = this._appSession.getTimers().iterator();
        if (!it.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<ServletTimer> timers = new ArrayList<ServletTimer>();
        while (it.hasNext()) {
            timers.add(new ScopedTimer(it.next()));
        }
        return timers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        try (SessionManager.ApplicationSessionScope scope = this.openScope();){
            this._appSession.invalidate();
        }
    }

    public boolean isReadyToInvalidate() {
        return this._appSession.isReadyToInvalidate();
    }

    public boolean isValid() {
        return this._appSession.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        try (SessionManager.ApplicationSessionScope scope = this.openScope();){
            this._appSession.removeAttribute(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        try (SessionManager.ApplicationSessionScope scope = this.openScope();){
            this._appSession.setAttribute(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setExpires(int deltaMinutes) {
        try (SessionManager.ApplicationSessionScope scope = this.openScope();){
            int n = this._appSession.setExpires(deltaMinutes);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInvalidateWhenReady(boolean invalidateWhenReady) {
        try (SessionManager.ApplicationSessionScope scope = this.openScope();){
            this._appSession.setInvalidateWhenReady(invalidateWhenReady);
        }
    }

    @Override
    public ApplicationSession getAppSession() {
        return this._appSession;
    }

    public String toString() {
        return this._appSession.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SessionManager.AppSessionIf)) {
            return false;
        }
        return this._appSession.equals(((SessionManager.AppSessionIf)o).getAppSession());
    }

    public int hashCode() {
        return this._appSession.hashCode();
    }
}

