/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.session.http;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.sip.ConvergedHttpSession;
import javax.servlet.sip.SipApplicationSession;
import org.cipango.server.session.ApplicationSession;
import org.cipango.server.session.SessionManager;
import org.cipango.server.session.scoped.ScopedAppSession;
import org.cipango.server.sipapp.SipAppContext;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.HashedSession;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ConvergedSessionManager
extends HashSessionManager {
    private static final Logger LOG = Log.getLogger(ConvergedSessionManager.class);

    protected AbstractSession newSession(HttpServletRequest request) {
        return new Session(request);
    }

    public class Session
    extends HashedSession
    implements ConvergedHttpSession {
        private ApplicationSession _appSession;
        private String _serverName;
        private String _scheme;
        private int _port;
        private int _securePort;

        protected Session(HttpServletRequest httpServletRequest) {
            super((HashSessionManager)ConvergedSessionManager.this, httpServletRequest);
            Request request = (Request)httpServletRequest;
            this._serverName = request.getServerName();
            this._scheme = request.getScheme();
            this._securePort = request.getHttpChannel().getHttpConfiguration().getSecurePort();
            this._port = request.getServerPort();
            this.updateSession((HttpServletRequest)request);
        }

        public void updateSession(HttpServletRequest request) {
            if (this._appSession != null) {
                return;
            }
            String uri = request.getRequestURI();
            int semi = uri.lastIndexOf(59);
            if (semi == -1) {
                return;
            }
            String appId = null;
            String path_params = uri.substring(semi + 1);
            if (path_params != null && path_params.startsWith("appid")) {
                appId = path_params.substring("appid".length() + 1);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Got App ID " + appId + " from URL", new Object[0]);
                }
            }
            if (appId != null && !appId.trim().equals("")) {
                appId = appId.replace("%3B", ";");
                this._appSession = this.getSipAppContext().getSessionHandler().getSessionManager().getApplicationSession(appId);
                if (this._appSession != null && this.isValid()) {
                    this._appSession.addSession((Object)this);
                }
            }
        }

        private SipAppContext getSipAppContext() {
            return (SipAppContext)ConvergedSessionManager.this._context.getContextHandler().getBean(SipAppContext.class);
        }

        public String encodeURL(String url) {
            String sessionURLPrefix = ConvergedSessionManager.this.getSessionIdPathParameterNamePrefix();
            String id = this.getNodeId();
            int prefix = url.indexOf(sessionURLPrefix);
            if (prefix != -1) {
                int suffix = url.indexOf("?", prefix);
                if (suffix < 0) {
                    suffix = url.indexOf("#", prefix);
                }
                if (suffix <= prefix) {
                    return url.substring(0, prefix + sessionURLPrefix.length()) + id;
                }
                return url.substring(0, prefix + sessionURLPrefix.length()) + id + url.substring(suffix);
            }
            int suffix = url.indexOf(63);
            if (suffix < 0) {
                suffix = url.indexOf(35);
            }
            if (suffix < 0) {
                return url + sessionURLPrefix + id;
            }
            return url.substring(0, suffix) + sessionURLPrefix + id + url.substring(suffix);
        }

        public String encodeURL(String relativePath, String scheme) {
            StringBuffer sb = new StringBuffer();
            sb.append(scheme).append("://");
            sb.append(this._serverName);
            if (this._scheme.equalsIgnoreCase(scheme)) {
                if (this._port > 0 && (scheme.equalsIgnoreCase("http") && this._port != 80 || scheme.equalsIgnoreCase("https") && this._port != 443)) {
                    sb.append(':').append(this._port);
                }
            } else if ("https".equalsIgnoreCase(scheme) && this._securePort != 0) {
                if (this._securePort != 443) {
                    sb.append(':').append(this._securePort);
                }
            } else {
                throw new IllegalArgumentException("Scheme " + scheme + " is not the scheme used for this session " + " and unable to detect the port for this scheme");
            }
            sb.append(ConvergedSessionManager.this._context.getContextPath());
            sb.append(relativePath);
            return this.encodeURL(sb.toString());
        }

        public SipApplicationSession getApplicationSession() {
            if (this._appSession == null) {
                this._appSession = this.getSipAppContext().getSessionHandler().getSessionManager().createApplicationSession();
                if (this.isValid()) {
                    this._appSession.addSession((Object)this);
                }
            }
            return new ScopedAppSession(this._appSession);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean access(long time) {
            boolean access = super.access(time);
            if (this._appSession != null) {
                try (SessionManager.ApplicationSessionScope scope = this._appSession.getSessionManager().openScope(this._appSession);){
                    this._appSession.access(time);
                }
            }
            return access;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doInvalidate() throws IllegalStateException {
            super.doInvalidate();
            if (this._appSession != null) {
                try (SessionManager.ApplicationSessionScope scope = this._appSession.getSessionManager().openScope(this._appSession);){
                    this._appSession.removeSession((Object)this);
                }
            }
        }
    }
}

