/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.session;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipApplicationSessionAttributeListener;
import javax.servlet.sip.SipApplicationSessionBindingEvent;
import javax.servlet.sip.SipApplicationSessionEvent;
import javax.servlet.sip.SipApplicationSessionListener;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipSessionAttributeListener;
import javax.servlet.sip.SipSessionBindingEvent;
import javax.servlet.sip.SipSessionListener;
import org.cipango.server.session.ApplicationSession;
import org.cipango.server.session.HashIdManager;
import org.cipango.server.session.IdManager;
import org.cipango.server.session.Session;
import org.cipango.server.sipapp.SipAppContext;
import org.cipango.util.StringUtil;
import org.cipango.util.TimerTask;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.eclipse.jetty.util.statistic.SampleStatistic;

@ManagedObject(value="Session manager")
public class SessionManager
extends AbstractLifeCycle {
    private static final Logger LOG = Log.getLogger(SessionManager.class);
    public static final char CONTEXT_ID_SEPARATOR = '.';
    protected static final Method __appSessionCreated;
    protected static final Method __appSessionDestroyed;
    private Random _random = new Random();
    private ConcurrentHashMap<String, ApplicationSession> _appSessions = new ConcurrentHashMap();
    private final List<SipSessionAttributeListener> _sessionAttributeListeners = new CopyOnWriteArrayList<SipSessionAttributeListener>();
    private final List<SipApplicationSessionAttributeListener> _applicationSessionAttributeListeners = new CopyOnWriteArrayList<SipApplicationSessionAttributeListener>();
    private final List<SipApplicationSessionListener> _applicationSessionListeners = new CopyOnWriteArrayList<SipApplicationSessionListener>();
    private final List<SipSessionListener> _sessionListeners = new CopyOnWriteArrayList<SipSessionListener>();
    private Timer _timer;
    private long _scavengePeriodMs = 30000L;
    private TimerTask _task;
    protected ClassLoader _loader;
    private SipAppContext _sipAppContext;
    private Queue<TimerTask> _timerQueue = new PriorityQueue<TimerTask>();
    private int _sessionTimeout = -1;
    private final CounterStatistic _sessionsStats = new CounterStatistic();
    private final SampleStatistic _sessionTimeStats = new SampleStatistic();
    private IdManager _callIdManager;
    private IdManager _sessionIdManager;

    protected void doStart() throws Exception {
        String localhost;
        if (this._sessionIdManager == null) {
            this.setSessionIdManager(new HashIdManager());
        }
        this._sessionIdManager.setPrefix(this._sipAppContext.getContextId() + '.');
        this._sessionIdManager.start();
        if (this._callIdManager == null) {
            this.setCallIdManager(new HashIdManager());
        }
        try {
            localhost = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            localhost = "localhost";
        }
        this._callIdManager.setPostfix("@" + localhost);
        this._callIdManager.start();
        super.doStart();
        this._loader = Thread.currentThread().getContextClassLoader();
        this._timer = new Timer();
        new Thread((Runnable)this._timer, "Timer-" + this._sipAppContext.getName()).start();
        this.setScavengePeriod(this.getScavengePeriod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        super.doStop();
        Queue<TimerTask> queue = this._timerQueue;
        synchronized (queue) {
            this._timerQueue.notify();
        }
        this._sessionIdManager.stop();
        this._callIdManager.stop();
    }

    public ServletContext getContext() {
        return this._sipAppContext.getServletContext();
    }

    public ApplicationSession createApplicationSession() {
        return this.createApplicationSession(this._sessionIdManager.newId());
    }

    public ApplicationSession createApplicationSession(String id) {
        ApplicationSession appSession = new ApplicationSession(this, id);
        appSession = this.addApplicationSession(appSession);
        return appSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ApplicationSession addApplicationSession(ApplicationSession appSession) {
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            ApplicationSession session = this._appSessions.putIfAbsent(appSession.getId(), appSession);
            if (session != null) {
                LOG.warn("A session with same ID already exist. {}, {}", new Object[]{session, appSession});
                return session;
            }
        }
        this._sessionsStats.increment();
        appSession.setExpires(this._sessionTimeout);
        if (!this._applicationSessionListeners.isEmpty()) {
            this.getSipAppContext().fire(appSession, this._applicationSessionListeners, __appSessionCreated, new SipApplicationSessionEvent((SipApplicationSession)appSession));
        }
        return appSession;
    }

    protected ConcurrentHashMap<String, ApplicationSession> getAppSessions() {
        return this._appSessions;
    }

    public ApplicationSession getApplicationSession(String id) {
        return this._appSessions.get(id);
    }

    public String newSessionId() {
        long r = this._random.nextInt();
        if (r < 0L) {
            r = -r;
        }
        return StringUtil.toBase62String2((long)r);
    }

    public ApplicationSessionScope openScope(String id) {
        ApplicationSession applicationSession = this.getApplicationSession(id);
        if (applicationSession == null) {
            return null;
        }
        return this.openScope(applicationSession);
    }

    public ApplicationSessionScope openScope(ApplicationSession applicationSession, int seconds) {
        boolean locked;
        try {
            locked = applicationSession.getLock().tryLock(seconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e1) {
            locked = false;
        }
        if (!locked) {
            LOG.warn("Could not get lock for session {} in {} seconds: lock is {}", new Object[]{this, seconds, applicationSession.getLock()});
        }
        return new ApplicationSessionScope(applicationSession, locked);
    }

    public ApplicationSessionScope openScope(ApplicationSession applicationSession) {
        return this.openScope(applicationSession, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(ApplicationSession applicationSession) {
        try {
            int holds = applicationSession.getLock().getHoldCount();
            if (holds == 1 && !applicationSession.getLock().hasQueuedThreads()) {
                applicationSession.invalidateIfReady();
                if (applicationSession.isValid()) {
                    this.saveSession(applicationSession);
                }
            }
        }
        finally {
            applicationSession.getLock().unlock();
        }
    }

    protected void saveSession(ApplicationSession applicationSession) {
    }

    public String getApplicationSessionIdByKey(String key) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = md.digest(key.getBytes(StringUtil.__UTF8_CHARSET));
            long i = 0L;
            for (byte b : bytes) {
                i = i * 31L + (long)b;
            }
            key = StringUtil.toBase62String2((long)Math.abs(i));
            if (key.length() > 7) {
                key = key.substring(0, 7);
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to create session key", (Throwable)e);
        }
        return this._sipAppContext.getContextId() + '.' + key;
    }

    public String newTimerId() {
        long r = this._random.nextInt();
        if (r < 0L) {
            r = -r;
        }
        return StringUtil.toBase62String2((long)r);
    }

    public String newCallId() {
        return this._callIdManager.newId();
    }

    public String newUASTag(ApplicationSession session) {
        long r = this._random.nextInt();
        if (r < 0L) {
            r = -r;
        }
        return session.getId() + "-" + StringUtil.toBase62String2((long)r);
    }

    public String newBranch() {
        long r = this._random.nextLong();
        if (r < 0L) {
            r = -r;
        }
        return "z9hG4bK" + StringUtil.toBase62String2((long)r);
    }

    public void removeApplicationSession(ApplicationSession session) {
        this._appSessions.remove(session.getId());
        this._sessionIdManager.releaseId(session.getId());
        this._sessionsStats.decrement();
        this._sessionTimeStats.set(Math.round((double)(System.currentTimeMillis() - session.getCreationTime()) / 1000.0));
        if (!this._applicationSessionListeners.isEmpty()) {
            this.getSipAppContext().fire(session, this._applicationSessionListeners, __appSessionDestroyed, new SipApplicationSessionEvent((SipApplicationSession)session));
        }
    }

    public void removeSipSession(Session session) {
        this._callIdManager.releaseId(session.getCallId());
    }

    protected void scavenge() {
        if (!this.isRunning()) {
            return;
        }
        try {
            for (ApplicationSession session : this._appSessions.values()) {
                if (!session.isValid() || session.getExpirationTime() != Long.MIN_VALUE) continue;
                this.doSessionExpired(session);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to scavenge application sessions", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSessionExpired(ApplicationSession applicationSession) {
        ApplicationSessionScope scope = this.openScope(applicationSession, 2);
        if (!scope.isLocked()) {
            return;
        }
        try {
            for (SipApplicationSessionListener l : this._applicationSessionListeners) {
                try {
                    l.sessionExpired(new SipApplicationSessionEvent((SipApplicationSession)applicationSession));
                }
                catch (Throwable e) {
                    LOG.debug("Got exception while invoking session SipApplicationSessionListener " + l, e);
                }
            }
            if (applicationSession.getExpirationTime() < 0L) {
                applicationSession.invalidate();
            }
        }
        finally {
            scope.close();
        }
    }

    public void doSessionAttributeListeners(Session session, String name, Object old, Object value) {
        if (!this._sessionAttributeListeners.isEmpty()) {
            SipSessionBindingEvent event = new SipSessionBindingEvent((SipSession)session, name);
            for (SipSessionAttributeListener l : this._sessionAttributeListeners) {
                if (value == null) {
                    l.attributeRemoved(event);
                    continue;
                }
                if (old == null) {
                    l.attributeAdded(event);
                    continue;
                }
                l.attributeReplaced(event);
            }
        }
    }

    public void doApplicationSessionAttributeListeners(ApplicationSession applicationSession, String name, Object old, Object value) {
        if (!this._applicationSessionAttributeListeners.isEmpty()) {
            SipApplicationSessionBindingEvent event = new SipApplicationSessionBindingEvent((SipApplicationSession)applicationSession, name);
            for (SipApplicationSessionAttributeListener l : this._applicationSessionAttributeListeners) {
                if (value == null) {
                    l.attributeRemoved(event);
                    continue;
                }
                if (old == null) {
                    l.attributeAdded(event);
                    continue;
                }
                l.attributeReplaced(event);
            }
        }
    }

    public int getScavengePeriod() {
        return (int)(this._scavengePeriodMs / 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScavengePeriod(int seconds) {
        if (seconds == 0) {
            seconds = 60;
        }
        long oldPeriods = this._scavengePeriodMs;
        long period = (long)seconds * 1000L;
        if (period > 60000L) {
            period = 60000L;
        }
        if (period < 1000L) {
            period = 1000L;
        }
        this._scavengePeriodMs = period;
        if (this._timer != null && (period != oldPeriods || this._task == null)) {
            SessionManager sessionManager = this;
            synchronized (sessionManager) {
                if (this._task != null) {
                    this._task.cancel();
                }
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        SessionManager.this.scavenge();
                        if (SessionManager.this.isRunning()) {
                            SessionManager.this._task = SessionManager.this.schedule(this, SessionManager.this._scavengePeriodMs);
                        }
                    }
                };
                this._task = this.schedule(runnable, this._scavengePeriodMs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimerTask schedule(Runnable runnable, long delay) {
        TimerTask task = new TimerTask(runnable, System.currentTimeMillis() + delay);
        Queue<TimerTask> queue = this._timerQueue;
        synchronized (queue) {
            this._timerQueue.offer(task);
            this._timerQueue.notifyAll();
        }
        return task;
    }

    public SipAppContext getSipAppContext() {
        return this._sipAppContext;
    }

    public List<SipApplicationSessionListener> getApplicationSessionListeners() {
        return this._applicationSessionListeners;
    }

    public void addEventListener(EventListener listener) {
        if (listener instanceof SipApplicationSessionAttributeListener) {
            this._applicationSessionAttributeListeners.add((SipApplicationSessionAttributeListener)listener);
        }
        if (listener instanceof SipApplicationSessionListener) {
            this._applicationSessionListeners.add((SipApplicationSessionListener)listener);
        }
        if (listener instanceof SipSessionAttributeListener) {
            this._sessionAttributeListeners.add((SipSessionAttributeListener)listener);
        }
        if (listener instanceof SipSessionListener) {
            this._sessionListeners.add((SipSessionListener)listener);
        }
    }

    public void removeEventListener(EventListener listener) {
        if (listener instanceof SipApplicationSessionAttributeListener) {
            this._applicationSessionAttributeListeners.remove((SipApplicationSessionAttributeListener)listener);
        }
        if (listener instanceof SipApplicationSessionListener) {
            this._applicationSessionListeners.remove((SipApplicationSessionListener)listener);
        }
        if (listener instanceof SipSessionAttributeListener) {
            this._sessionAttributeListeners.remove((SipSessionAttributeListener)listener);
        }
        if (listener instanceof SipSessionListener) {
            this._sessionListeners.remove((SipSessionListener)listener);
        }
    }

    public void clearEventListeners() {
        this._applicationSessionAttributeListeners.clear();
        this._applicationSessionListeners.clear();
        this._sessionAttributeListeners.clear();
        this._sessionListeners.clear();
    }

    public List<SipSessionAttributeListener> getSessionAttributeListeners() {
        return this._sessionAttributeListeners;
    }

    public List<SipApplicationSessionAttributeListener> getApplicationSessionAttributeListeners() {
        return this._applicationSessionAttributeListeners;
    }

    public List<SipSessionListener> getSessionListeners() {
        return this._sessionListeners;
    }

    @ManagedAttribute(value="Session timeout")
    public int getSessionTimeout() {
        return this._sessionTimeout;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this._sessionTimeout = sessionTimeout;
    }

    @ManagedAttribute(value="Active application sessions")
    public long getSessions() {
        return this._sessionsStats.getCurrent();
    }

    @ManagedAttribute(value="Total application sessions")
    public long getSessionsTotal() {
        return this._sessionsStats.getTotal();
    }

    @ManagedAttribute(value="Max active application sessions")
    public long getSessionsMax() {
        return this._sessionsStats.getMax();
    }

    @ManagedAttribute(value="Maximum amount of time session remained valid")
    public long getSessionTimeMax() {
        return this._sessionTimeStats.getMax();
    }

    @ManagedOperation(value="Stats reset")
    public void statsReset() {
        this._sessionsStats.reset(this.getSessions());
        this._sessionTimeStats.reset();
    }

    @ManagedAttribute(value="maximum amount of time session remained valid")
    public long getSessionTimeTotal() {
        return this._sessionTimeStats.getTotal();
    }

    @ManagedAttribute(value="Mean amount of time session remained valid")
    public double getSessionTimeMean() {
        return this._sessionTimeStats.getMean();
    }

    @ManagedAttribute(value="Standard deviation of amount of time session remained valid")
    public double getSessionTimeStdDev() {
        return this._sessionTimeStats.getStdDev();
    }

    public void setSipAppContext(SipAppContext sipAppContext) {
        this._sipAppContext = sipAppContext;
    }

    @ManagedOperation(value="View SIP Application session", impact="INFO")
    public String viewApplicationSession(@Name(value="id") String id) {
        ApplicationSession appSession = this.getApplicationSession(id);
        if (appSession == null) {
            return "No SIP application session with ID " + id + " found";
        }
        return appSession.dump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute(value="Application session IDs")
    public List<String> getApplicationSessionIds() {
        ConcurrentHashMap<String, ApplicationSession> concurrentHashMap = this._appSessions;
        synchronized (concurrentHashMap) {
            return new ArrayList<String>(this._appSessions.keySet());
        }
    }

    public IdManager getSessionIdManager() {
        return this._sessionIdManager;
    }

    public void setSessionIdManager(IdManager sessionIdManager) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this._sessionIdManager = sessionIdManager;
    }

    public IdManager getCallIdManager() {
        return this._callIdManager;
    }

    public void setCallIdManager(IdManager callIdManager) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this._callIdManager = callIdManager;
    }

    static {
        try {
            __appSessionCreated = SipApplicationSessionListener.class.getMethod("sessionCreated", SipApplicationSessionEvent.class);
            __appSessionDestroyed = SipApplicationSessionListener.class.getMethod("sessionDestroyed", SipApplicationSessionEvent.class);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static interface SipSessionIf
    extends SipSession {
        public Session getSession();
    }

    public static interface AppSessionIf
    extends SipApplicationSession {
        public ApplicationSession getAppSession();
    }

    class Timer
    implements Runnable {
        Timer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClassLoader oldClassLoader = null;
            Thread currentThread = null;
            if (SessionManager.this._loader != null) {
                currentThread = Thread.currentThread();
                oldClassLoader = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(SessionManager.this._loader);
            } else {
                LOG.warn("Could not set right class loader for timer of context {}", new Object[]{SessionManager.this.getSipAppContext()});
            }
            do {
                try {
                    long delay;
                    TimerTask task;
                    Queue queue = SessionManager.this._timerQueue;
                    synchronized (queue) {
                        do {
                            if ((task = (TimerTask)SessionManager.this._timerQueue.peek()) == null || !task.isCancelled()) continue;
                            task = (TimerTask)SessionManager.this._timerQueue.remove();
                        } while (task != null && task.isCancelled());
                        long l = delay = task != null ? task.getExecutionTime() - System.currentTimeMillis() : Long.MAX_VALUE;
                        if (delay > 0L) {
                            SessionManager.this._timerQueue.wait(delay);
                        } else {
                            SessionManager.this._timerQueue.poll();
                        }
                    }
                    if (delay > 0L) continue;
                    try {
                        if (task.isCancelled()) continue;
                        task.getRunnable().run();
                    }
                    catch (Throwable e) {
                        LOG.debug("Failed to execute timer " + task, e);
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            } while (SessionManager.this.isRunning());
            if (SessionManager.this._loader != null) {
                currentThread.setContextClassLoader(oldClassLoader);
            }
        }
    }

    public static class ApplicationSessionScope {
        private final ApplicationSession _applicationSession;
        private boolean _locked;

        public ApplicationSessionScope(ApplicationSession applicationSession, boolean locked) {
            this._applicationSession = applicationSession;
            this._locked = locked;
        }

        public ApplicationSession getApplicationSession() {
            return this._applicationSession;
        }

        public boolean isLocked() {
            return this._locked;
        }

        public void close() {
            if (this._locked) {
                this._applicationSession.getSessionManager().close(this._applicationSession);
                this._locked = false;
            }
        }
    }
}

