/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.session;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.EventListener;
import javax.servlet.ServletException;
import javax.servlet.sip.Proxy;
import org.cipango.server.SipMessage;
import org.cipango.server.SipRequest;
import org.cipango.server.SipResponse;
import org.cipango.server.handler.SipHandlerWrapper;
import org.cipango.server.session.ApplicationSession;
import org.cipango.server.session.Session;
import org.cipango.server.session.SessionManager;
import org.cipango.server.sipapp.SipAppContext;
import org.cipango.server.transaction.ServerTransaction;
import org.cipango.server.transaction.TransactionImpl;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Session  handler")
public class SessionHandler
extends SipHandlerWrapper {
    public static final String APP_ID = "appid";
    private static final int MAX_TRY_LOCK_TIME = 64 * TransactionImpl.__T1 / 1000;
    private static final Logger LOG = Log.getLogger(SessionHandler.class);
    private SessionManager _sessionManager;
    private Method _sipApplicationKeyMethod;

    public SessionHandler() {
        this(new SessionManager());
    }

    public SessionHandler(SessionManager sessionManager) {
        this.setSessionManager(sessionManager);
    }

    protected void doStart() throws Exception {
        this._sessionManager.setSipAppContext(SipAppContext.getCurrentContext());
        super.doStart();
    }

    public void setSessionManager(SessionManager sessionManager) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this.updateBean((Object)this._sessionManager, (Object)sessionManager);
        this._sessionManager = sessionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(SipMessage message) throws IOException, ServletException {
        if (message instanceof SipRequest) {
            this.handleRequest((SipRequest)message);
        } else {
            SessionManager.ApplicationSessionScope scope = this.getSessionManager().openScope(message.appSession(), MAX_TRY_LOCK_TIME);
            if (!scope.isLocked()) {
                LOG.warn("Drop message {} as could not lock the session after {} seconds (the transaction should be now expired)", new Object[]{message, MAX_TRY_LOCK_TIME});
                return;
            }
            try {
                this._handler.handle(message);
            }
            finally {
                scope.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(SipRequest request) throws IOException, ServletException {
        boolean forwarded;
        ApplicationSession appSession = null;
        Session session = request.session();
        boolean bl = forwarded = session != null;
        if (!forwarded) {
            if (request.isInitial()) {
                if (this._sipApplicationKeyMethod != null) {
                    try {
                        String id;
                        String key = (String)this._sipApplicationKeyMethod.invoke(null, request);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("routing initial request to key {}", new Object[]{key});
                        }
                        if (key != null && (appSession = this._sessionManager.getApplicationSession(id = this._sessionManager.getApplicationSessionIdByKey(key))) == null) {
                            appSession = this._sessionManager.createApplicationSession(id);
                        }
                    }
                    catch (Exception e) {
                        LOG.debug("failed to get SipApplicationKey", (Throwable)e);
                    }
                }
                if (appSession == null) {
                    appSession = this._sessionManager.createApplicationSession();
                }
                session = appSession.createSession(request);
                session.addServerTransaction((ServerTransaction)request.getTransaction());
                session.setSubscriberURI(request.getSubscriberURI());
                session.setRegion(request.getRegion());
            } else {
                String tag;
                int i;
                String appId = request.getParameter(APP_ID);
                if (appId == null && (i = (tag = request.getToTag()).indexOf(45)) != -1) {
                    appId = tag.substring(0, i);
                }
                if (appId == null) {
                    this.notFound(request, "No Application Session Identifier");
                    return;
                }
                appSession = this._sessionManager.getApplicationSession(appId);
                if (appSession == null) {
                    this.notFound(request, "No Application Session");
                    return;
                }
                session = appSession.getSession(request);
            }
            if (session == null) {
                this.notFound(request, "No SIP Session");
                return;
            }
        }
        try (SessionManager.ApplicationSessionScope scope = this._sessionManager.openScope(session.appSession());){
            if (!forwarded) {
                if (request.isInvite()) {
                    SipResponse response = (SipResponse)request.createResponse(100);
                    ((ServerTransaction)request.getTransaction()).send(response);
                }
                session.access();
                request.setSession(session);
                if (!request.isInitial() && session.isUA()) {
                    session.getUa().handleRequest(request);
                }
            }
            if (!request.isHandled()) {
                this._handler.handle(request);
            }
            if (!request.isInitial() && session.isProxy() && !request.isCancel()) {
                Proxy proxy = request.getProxy();
                proxy.proxyTo(request.getRequestURI());
            }
        }
    }

    protected void notFound(SipRequest request, String reason) {
        if (!request.isAck()) {
            try {
                SipResponse response = (SipResponse)request.createResponse(481, reason);
                ((ServerTransaction)response.getTransaction()).send(response);
            }
            catch (Exception e) {
                LOG.ignore((Throwable)e);
            }
        }
    }

    protected String getApplicationId(String s) {
        return s.substring(s.lastIndexOf(45));
    }

    @ManagedAttribute(value="Session manager")
    public SessionManager getSessionManager() {
        return this._sessionManager;
    }

    public void addEventListener(EventListener listener) {
        this._sessionManager.addEventListener(listener);
    }

    public void removeEventListener(EventListener listener) {
        this._sessionManager.removeEventListener(listener);
    }

    public void clearEventListeners() {
        this._sessionManager.clearEventListeners();
    }

    public Method getSipApplicationKeyMethod() {
        return this._sipApplicationKeyMethod;
    }

    public void setSipApplicationKeyMethod(Method sipApplicationKeyMethod) {
        this._sipApplicationKeyMethod = sipApplicationKeyMethod;
    }
}

