/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.session;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipErrorEvent;
import javax.servlet.sip.SipErrorListener;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipSessionBindingEvent;
import javax.servlet.sip.SipSessionBindingListener;
import javax.servlet.sip.SipSessionEvent;
import javax.servlet.sip.SipSessionListener;
import javax.servlet.sip.TooManyHopsException;
import javax.servlet.sip.UAMode;
import javax.servlet.sip.URI;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;
import org.cipango.server.RequestCustomizer;
import org.cipango.server.SipConnection;
import org.cipango.server.SipConnector;
import org.cipango.server.SipMessage;
import org.cipango.server.SipRequest;
import org.cipango.server.SipResponse;
import org.cipango.server.SipServer;
import org.cipango.server.servlet.SipServletHolder;
import org.cipango.server.session.ApplicationSession;
import org.cipango.server.session.SessionManager;
import org.cipango.server.session.scoped.ScopedClientTransactionListener;
import org.cipango.server.session.scoped.ScopedServerTransactionListener;
import org.cipango.server.sipapp.SipAppContext;
import org.cipango.server.transaction.ClientTransaction;
import org.cipango.server.transaction.ClientTransactionListener;
import org.cipango.server.transaction.ServerTransaction;
import org.cipango.server.transaction.ServerTransactionListener;
import org.cipango.server.transaction.Transaction;
import org.cipango.server.transaction.TransactionImpl;
import org.cipango.server.util.ReadOnlyAddress;
import org.cipango.sip.AddressImpl;
import org.cipango.sip.RAck;
import org.cipango.sip.SipException;
import org.cipango.sip.SipFields;
import org.cipango.sip.SipHeader;
import org.cipango.sip.SipMethod;
import org.cipango.util.TimerTask;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Session
implements SessionManager.SipSessionIf,
Dumpable {
    private static final Logger LOG = Log.getLogger(Session.class);
    private final String _id;
    private final ApplicationSession _applicationSession;
    protected SipSession.State _state = SipSession.State.INITIAL;
    protected Role _role = Role.UNDEFINED;
    protected final String _callId;
    protected Address _localParty;
    protected Address _remoteParty;
    protected Map<String, Object> _attributes;
    protected List<ServerTransaction> _serverTransactions = new ArrayList<ServerTransaction>(1);
    protected List<ClientTransaction> _clientTransactions = new ArrayList<ClientTransaction>(1);
    protected String _linkedSessionId;
    private boolean _valid = true;
    private final long _created;
    private long _lastAccessed;
    private DialogInfo _dialog;
    private SipServletHolder _handler;
    private boolean _invalidateWhenReady = true;
    protected SipApplicationRoutingRegion _region;
    protected URI _subscriberURI;

    public Session(ApplicationSession applicationSession, String id, SipRequest request) {
        this(applicationSession, id, request.getCallId(), request.to().clone(), (Address)request.getFrom().clone());
    }

    public Session(ApplicationSession applicationSession, String id, String callId, Address local, Address remote) {
        this(applicationSession, id, callId, local, remote, System.currentTimeMillis(), 0L);
    }

    protected Session(ApplicationSession applicationSession, String id, String callId, Address local, Address remote, long created, long lastAccessed) {
        this._applicationSession = applicationSession;
        this._id = id;
        this._created = created;
        this._lastAccessed = lastAccessed;
        this._callId = callId;
        this._localParty = local;
        this._remoteParty = remote;
        if (applicationSession.getContext().getSpecVersion() == 10) {
            this._invalidateWhenReady = false;
        }
    }

    public Session(String id, Session other) {
        this(other._applicationSession, id, other.getCallId(), (Address)other.getLocalParty().clone(), (Address)other.getRemoteParty().clone());
        this._invalidateWhenReady = other._invalidateWhenReady;
        this._handler = other._handler;
        this._role = other._role;
        if (this._role == Role.UAS) {
            this._localParty.setParameter("tag", this._applicationSession.newUASTag());
        } else {
            this._remoteParty.removeParameter("tag");
        }
        if (other._dialog != null) {
            this._dialog = new DialogInfo();
            this._dialog._localCSeq = other._dialog._localCSeq;
        }
        if (other._attributes != null) {
            this._attributes = new HashMap<String, Object>();
            this._attributes.putAll(other._attributes);
        }
    }

    public ApplicationSession appSession() {
        return this._applicationSession;
    }

    public boolean isUA() {
        return this._role == Role.UAS || this._role == Role.UAC;
    }

    public boolean isProxy() {
        return this._role == Role.PROXY_RECORD_ROUTE || this._role == Role.PROXY_NO_RECORD_ROUTE;
    }

    public void setLinkedSession(Session session) {
        this._linkedSessionId = session != null ? session.getId() : null;
    }

    public Session getLinkedSession() {
        return this._linkedSessionId != null ? (Session)this._applicationSession.getSipSession(this._linkedSessionId) : null;
    }

    protected SipServer getServer() {
        return this._applicationSession.getSessionManager().getSipAppContext().getServer();
    }

    private void checkValid() {
        if (!this._valid) {
            throw new IllegalStateException("SipSession has been invalidated");
        }
    }

    protected Object doPutOrRemove(String name, Object value) {
        if (value == null) {
            return this._attributes != null ? this._attributes.remove(name) : null;
        }
        if (this._attributes == null) {
            this._attributes = new HashMap<String, Object>();
        }
        return this._attributes.put(name, value);
    }

    private void bindValue(String name, Object value) {
        if (value != null && value instanceof SipSessionBindingListener) {
            ((SipSessionBindingListener)value).valueBound(new SipSessionBindingEvent((SipSession)this, name));
        }
    }

    private void unbindValue(String name, Object value) {
        if (value != null && value instanceof SipSessionBindingListener) {
            ((SipSessionBindingListener)value).valueUnbound(new SipSessionBindingEvent((SipSession)this, name));
        }
    }

    public void setProxy() {
        if (this.isUA()) {
            throw new IllegalStateException("Session is " + (Object)((Object)this._role));
        }
        this._role = Role.PROXY_RECORD_ROUTE;
        Address tmp = this._remoteParty;
        this._remoteParty = this._localParty;
        this._localParty = tmp;
    }

    public void setRecordRoute(boolean recordRoute) {
        if (!this.isProxy()) {
            throw new IllegalStateException("Session is " + (Object)((Object)this._role));
        }
        this._role = recordRoute ? Role.PROXY_RECORD_ROUTE : Role.PROXY_NO_RECORD_ROUTE;
    }

    public void setUAS() {
        if (this.isUA()) {
            return;
        }
        if (this._role != Role.UNDEFINED) {
            throw new IllegalStateException("session is " + (Object)((Object)this._role));
        }
        this._role = Role.UAS;
        String tag = this._localParty.getParameter("tag");
        if (tag == null) {
            tag = this._applicationSession.newUASTag();
            this._localParty.setParameter("tag", tag);
        }
        this._dialog = this.newDialogInfo();
    }

    public void createUA(UAMode mode) {
        if (this._role != Role.UNDEFINED) {
            throw new IllegalStateException("Session is " + (Object)((Object)this._role));
        }
        this._role = mode == UAMode.UAC ? Role.UAC : Role.UAS;
        this._dialog = this.newDialogInfo();
    }

    protected DialogInfo newDialogInfo() {
        return new DialogInfo();
    }

    public void sendResponse(SipResponse response, boolean reliable) throws IOException {
        this.access();
        if (this._role == Role.UNDEFINED) {
            this.createUA(UAMode.UAS);
        }
        if (this.isProxy()) {
            if (!response.getRequest().isInitial()) {
                throw new IllegalStateException("Session is proxy");
            }
            this._role = Role.UAS;
            this._dialog = new DialogInfo();
            Address tmp = this._remoteParty;
            this._remoteParty = this._localParty;
            this._localParty = tmp;
            String tag = this._applicationSession.newUASTag();
            this._localParty.setParameter("tag", tag);
            response.to().setParameter("tag", tag);
            LOG.debug("Create a virtual branch on session {}", new Object[]{this});
        }
        if (this.isUA()) {
            this._dialog.sendResponse(response, reliable);
        }
    }

    public ClientTransaction sendRequest(SipRequest request, ClientTransactionListener listener) throws IOException {
        SipServer server = this.getServer();
        this.access();
        if (server.getHandler() instanceof RequestCustomizer) {
            ((RequestCustomizer)((Object)server.getHandler())).customizeRequest(request);
        }
        request.setCommitted(true);
        ClientTransaction tx = server.getTransactionManager().sendRequest(request, new ScopedClientTransactionListener(this, listener));
        if (!request.isAck()) {
            this.addClientTransaction(tx);
        }
        return tx;
    }

    public ClientTransaction sendRequest(SipRequest request) throws IOException {
        if (!this.isUA()) {
            throw new IllegalStateException("Session is not UA");
        }
        return this.sendRequest(request, this._dialog);
    }

    private void setState(SipSession.State state) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} -> {}", new Object[]{this, state});
        }
        this._state = state;
    }

    public void invokeServlet(SipRequest request) throws SipException {
        try {
            this._applicationSession.getSessionManager().getSipAppContext().handle(request);
        }
        catch (TooManyHopsException e) {
            throw new SipException(483);
        }
        catch (Throwable t) {
            throw new SipException(500, t);
        }
    }

    public void invokeServlet(SipResponse response) {
        try {
            if (this.isValid()) {
                this._applicationSession.getSessionManager().getSipAppContext().handle(response);
            }
        }
        catch (Throwable t) {
            LOG.debug(t);
        }
    }

    public void access() {
        this._lastAccessed = System.currentTimeMillis();
        this._applicationSession.access(this._lastAccessed);
    }

    public void updateStateOnProxyComplete(boolean forceTerminated) {
        if (!this.isProxy()) {
            LOG.debug("Could not update state as role is no more proxy", new Object[0]);
            return;
        }
        this.access();
        switch (this._state) {
            case INITIAL: {
                this.setState(SipSession.State.TERMINATED);
                break;
            }
            case EARLY: {
                if (!forceTerminated) break;
                this.setState(SipSession.State.TERMINATED);
                break;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateState(SipResponse response, boolean uac) {
        SipRequest request = (SipRequest)response.getRequest();
        int status = response.getStatus();
        if (request.isInitial() && (request.isInvite() || request.isSubscribe())) {
            switch (this._state) {
                case INITIAL: {
                    if (status < 300) {
                        if ((uac || !this.isUA()) && response.to().getTag() == null) return;
                        if (this._dialog != null) {
                            this._dialog.createDialog(response, uac);
                        } else if (this.isProxy()) {
                            this.createProxyDialog(response);
                        }
                        if (status < 200) {
                            this.setState(SipSession.State.EARLY);
                            return;
                        }
                        this.setState(SipSession.State.CONFIRMED);
                        return;
                    }
                    if (this.isProxy()) return;
                    if (uac) {
                        this.setState(SipSession.State.INITIAL);
                        return;
                    }
                    this.setState(SipSession.State.TERMINATED);
                    return;
                }
                case EARLY: {
                    if (200 <= status && status < 300) {
                        this.setState(SipSession.State.CONFIRMED);
                        return;
                    }
                    if (status < 300) return;
                    if (this.isProxy()) {
                        this._remoteParty.removeParameter("tag");
                        this.setState(SipSession.State.INITIAL);
                        return;
                    }
                    if (uac) {
                        this.setState(SipSession.State.INITIAL);
                        return;
                    }
                    this.setState(SipSession.State.TERMINATED);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        if (request.isBye() && response.is2xx()) {
            this.setState(SipSession.State.TERMINATED);
            return;
        }
        if (!response.isNotify()) return;
        try {
            Parameterable p = request.getParameterableHeader(SipHeader.SUBSCRIPTION_STATE.asString());
            if (p != null) {
                if (!"terminated".equalsIgnoreCase(p.getValue())) return;
                this.setState(SipSession.State.TERMINATED);
                return;
            } else {
                LOG.debug("Missing mandatory Subscription-State header in NOTIFY", new Object[0]);
            }
            return;
        }
        catch (Exception e) {
            LOG.ignore((Throwable)e);
        }
    }

    public boolean isSameDialog(SipResponse response) {
        String responseTag;
        String remoteTag = this._remoteParty.getParameter("tag");
        if (remoteTag != null && (responseTag = response.to().getTag()) != null && !remoteTag.equalsIgnoreCase(responseTag)) {
            LOG.debug("session: not same dialog tags are {} {}", new Object[]{remoteTag, responseTag});
            return false;
        }
        return true;
    }

    public boolean isDialog(String callId, String fromTag, String toTag) {
        if (!this._callId.equals(callId)) {
            return false;
        }
        String localTag = this._localParty.getParameter("tag");
        String remoteTag = this._remoteParty.getParameter("tag");
        if (fromTag.equals(localTag) && toTag.equals(remoteTag)) {
            return true;
        }
        return toTag.equals(localTag) && fromTag.equals(remoteTag);
    }

    protected void createProxyDialog(SipResponse response) {
        String tag = response.to().getTag();
        this._remoteParty.setParameter("tag", tag);
    }

    public Address getContact() {
        return this.getContact(this.getServer().getConnectors()[0]);
    }

    public Address getContact(SipConnector connector) {
        URI uri = connector.getURI().clone();
        uri.setParameter("appid", this._applicationSession.getId());
        return new AddressImpl(uri);
    }

    public Address getContact(SipConnection connection) {
        return this.getContact(connection.getConnector());
    }

    public SipServletRequest createRequest(String method) {
        this.checkValid();
        if (!this.isUA()) {
            throw new IllegalStateException("session is " + (Object)((Object)this._role));
        }
        return this._dialog.createRequest(method);
    }

    public SipServletHolder getHandler() {
        return this._handler;
    }

    public void setHandler(SipServletHolder handler) {
        this._handler = handler;
    }

    public SipApplicationSession getApplicationSession() {
        return this._applicationSession;
    }

    public synchronized Object getAttribute(String name) {
        this.checkValid();
        if (name == null) {
            throw new NullPointerException("Attribute name is null");
        }
        return this._attributes != null ? this._attributes.get(name) : null;
    }

    public synchronized Enumeration<String> getAttributeNames() {
        this.checkValid();
        if (this._attributes == null) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(new ArrayList<String>(this._attributes.keySet()));
    }

    public String getCallId() {
        return this._callId;
    }

    public long getCreationTime() {
        return this._created;
    }

    public String getId() {
        return this._id;
    }

    public boolean getInvalidateWhenReady() {
        this.checkValid();
        return this._invalidateWhenReady;
    }

    public long getLastAccessedTime() {
        return this._lastAccessed;
    }

    public Address getLocalParty() {
        return new ReadOnlyAddress(this._localParty);
    }

    public SipApplicationRoutingRegion getRegion() {
        this.checkValid();
        return this._region;
    }

    public Address getRemoteParty() {
        return new ReadOnlyAddress(this._remoteParty);
    }

    public String getLocalTag() {
        return this._localParty.getParameter("tag");
    }

    public ServletContext getServletContext() {
        return this._applicationSession.getSessionManager().getContext();
    }

    public SipSession.State getState() {
        this.checkValid();
        return this._state;
    }

    public URI getSubscriberURI() {
        this.checkValid();
        return this._subscriberURI;
    }

    public void invalidate() {
        this.checkValid();
        this._applicationSession.assertLocked();
        if (LOG.isDebugEnabled()) {
            LOG.debug("invalidating SipSession {}", new Object[]{this});
        }
        this._valid = false;
        this._applicationSession.removeSession(this);
    }

    public boolean isReadyToInvalidate() {
        this.checkValid();
        if (this._lastAccessed == 0L) {
            return false;
        }
        if (this._state == SipSession.State.TERMINATED || this._state == SipSession.State.INITIAL) {
            for (ClientTransaction clientTransaction : this._clientTransactions) {
                if (clientTransaction.getState() != Transaction.State.COMPLETED && clientTransaction.getState() != Transaction.State.CONFIRMED && clientTransaction.getState() != Transaction.State.ACCEPTED) {
                    return false;
                }
                if (!clientTransaction.isProcessingResponse()) continue;
                LOG.debug("Session {} is not ready to invalidate session, as client transaction {} is processing response", new Object[]{this, clientTransaction});
                return false;
            }
            for (Transaction transaction : this._serverTransactions) {
                if (transaction.getState() == Transaction.State.COMPLETED || transaction.getState() == Transaction.State.CONFIRMED || transaction.getState() == Transaction.State.ACCEPTED) continue;
                return false;
            }
            return true;
        }
        if (this._role == Role.PROXY_NO_RECORD_ROUTE) {
            for (Transaction transaction : this._clientTransactions) {
                if (transaction.getState() == Transaction.State.COMPLETED || transaction.getState() == Transaction.State.CONFIRMED) continue;
                return false;
            }
            for (Transaction transaction : this._serverTransactions) {
                if (transaction.getState() == Transaction.State.COMPLETED || transaction.getState() == Transaction.State.CONFIRMED) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void invalidateIfReady() {
        if (this.isValid() && this.getInvalidateWhenReady() && this.isReadyToInvalidate()) {
            SipAppContext context = this._applicationSession.getContext();
            List<SipSessionListener> listeners = this._applicationSession.getSessionManager().getSessionListeners();
            if (!listeners.isEmpty()) {
                context.fire(this._applicationSession, listeners, ApplicationSession.__sessionReadyToInvalidate, new SipSessionEvent((SipSession)this));
            }
            if (this.isValid() && this.getInvalidateWhenReady()) {
                this.invalidate();
            }
        }
    }

    public boolean isValid() {
        return this._valid;
    }

    public boolean isTerminated() {
        return this._state == SipSession.State.TERMINATED || !this._valid;
    }

    public void removeAttribute(String name) {
        this.putAttribute(name, null);
    }

    public void setAttribute(String name, Object value) {
        if (name == null || value == null) {
            throw new NullPointerException("Name or attribute is null");
        }
        this.putAttribute(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAttribute(String name, Object value) {
        Object old = null;
        Session session = this;
        synchronized (session) {
            this.checkValid();
            old = this.doPutOrRemove(name, value);
        }
        this._applicationSession.assertLocked();
        if (value == null || !value.equals(old)) {
            if (old != null) {
                this.unbindValue(name, old);
            }
            if (value != null) {
                this.bindValue(name, value);
            }
            this._applicationSession.getSessionManager().doSessionAttributeListeners(this, name, old, value);
        }
    }

    public void setHandler(String name) throws ServletException {
        this.checkValid();
        SipAppContext context = this._applicationSession.getContext();
        SipServletHolder handler = context.getServletHandler().getHolder(name);
        if (handler == null) {
            throw new ServletException("No handler named " + name);
        }
        this.setHandler(handler);
    }

    public void setInvalidateWhenReady(boolean invalidateWhenReady) {
        this.checkValid();
        this._invalidateWhenReady = invalidateWhenReady;
    }

    public void setOutboundInterface(InetSocketAddress address) {
        this.checkValid();
        if (address == null) {
            throw new NullPointerException("Null address");
        }
    }

    public void setOutboundInterface(InetAddress address) {
        this.checkValid();
        if (address == null) {
            throw new NullPointerException("Null address");
        }
    }

    public void addServerTransaction(ServerTransaction transaction) {
        this._serverTransactions.add(transaction);
    }

    public void removeTransaction(Transaction transaction) {
        if (transaction.isServer()) {
            this._serverTransactions.remove(transaction);
        } else {
            this._clientTransactions.remove(transaction);
        }
    }

    public List<ServerTransaction> getServerTransactions() {
        return this._serverTransactions;
    }

    public void addClientTransaction(ClientTransaction transaction) {
        this._clientTransactions.add(transaction);
    }

    public List<ClientTransaction> getClientTransactions() {
        return this._clientTransactions;
    }

    public void setSubscriberURI(URI uri) {
        this._subscriberURI = uri;
    }

    public void setRegion(SipApplicationRoutingRegion region) {
        this._region = region;
    }

    public DialogInfo getUa() {
        return this._dialog;
    }

    public String toString() {
        return String.format("%s{l(%s)<->r(%s),%s,%s}", new Object[]{this.getId(), this._localParty, this._remoteParty, this._state, this._role});
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SessionManager.SipSessionIf)) {
            return false;
        }
        Session session = ((SessionManager.SipSessionIf)o).getSession();
        return this == session;
    }

    @Override
    public Session getSession() {
        return this;
    }

    public String dump() {
        return ContainerLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        out.append(indent).append("+ ").append(this.getId()).append('\n');
        indent = indent + "  ";
        this.printAttr(out, "created", new Date(this.getCreationTime()), indent);
        this.printAttr(out, "accessed", new Date(this.getLastAccessedTime()), indent);
        this.printAttr(out, "role", (Object)this._role, indent);
        this.printAttr(out, "state", this._state, indent);
        this.printAttr(out, "invalidateWhenReady", this._invalidateWhenReady, indent);
        this.printAttr(out, "attributes", this._attributes, indent);
        this.printAttr(out, "localParty", this._localParty, indent);
        this.printAttr(out, "remoteParty", this._remoteParty, indent);
        this.printAttr(out, "region", this._region, indent);
        this.printAttr(out, "Call-ID", this._callId, indent);
        this.printAttr(out, "linkedSessionId", this._linkedSessionId, indent);
        this.printAttr(out, "subscriberURI", this._subscriberURI, indent);
        this.printAttr(out, "handler", this.getHandler(), indent);
        if (this._dialog != null) {
            this._dialog.dump(out, indent + "  ");
        }
        if (!this._serverTransactions.isEmpty() || !this._clientTransactions.isEmpty()) {
            out.append(indent).append("+ [transactions]\n");
            for (ServerTransaction serverTransaction : this._serverTransactions) {
                out.append(indent).append("  + ").append(serverTransaction.toString()).append("\n");
            }
            for (ClientTransaction clientTransaction : this._clientTransactions) {
                out.append(indent).append("  + ").append(clientTransaction.toString()).append("\n");
            }
        }
    }

    private void printAttr(Appendable sb, String name, Object value, String indent) throws IOException {
        sb.append(indent).append("- ").append(name).append(": ").append(String.valueOf(value)).append('\n');
    }

    public class DialogInfo
    implements ClientTransactionListener,
    ServerTransactionListener,
    Dumpable {
        protected long _localCSeq = 1L;
        protected long _remoteCSeq = -1L;
        protected long _localRSeq = 1L;
        protected long _remoteRSeq = -1L;
        protected URI _remoteTarget;
        protected LinkedList<String> _routeSet;
        private Object _serverInvites;
        private Object _clientInvites;
        protected boolean _secure = false;

        public SipServletRequest createRequest(String method) {
            SipMethod sipMethod = SipMethod.get((String)method);
            if (sipMethod == SipMethod.ACK || sipMethod == SipMethod.CANCEL) {
                throw new IllegalArgumentException("Forbidden request method " + method);
            }
            if (Session.this._state == SipSession.State.TERMINATED) {
                throw new IllegalStateException("Cannot create request in TERMINATED state");
            }
            if (Session.this._state == SipSession.State.INITIAL && Session.this._role == Role.UAS) {
                throw new IllegalStateException("Cannot create request in INITIAL state and UAS mode");
            }
            return this.createRequest(sipMethod, method, this._localCSeq++);
        }

        public SipRequest createRequest(SipRequest srcRequest) {
            SipRequest request = new SipRequest(srcRequest);
            request.getFields().remove(SipHeader.RECORD_ROUTE.asString());
            request.getFields().remove(SipHeader.VIA.asString());
            request.getFields().remove(SipHeader.CONTACT.asString());
            this.setDialogHeaders(request, this._localCSeq++);
            request.setSession(Session.this);
            return request;
        }

        public SipServletRequest createRequest(SipMethod sipMethod, long cseq) {
            return this.createRequest(sipMethod, sipMethod.asString(), cseq);
        }

        public SipServletRequest createRequest(SipMethod sipMethod, String method, long cseq) {
            SipRequest request = new SipRequest();
            request.setMethod(sipMethod, method);
            this.setDialogHeaders(request, cseq);
            request.setSession(Session.this);
            return request;
        }

        protected void setDialogHeaders(SipRequest request, long cseq) {
            SipFields fields = request.getFields();
            fields.set(SipHeader.FROM, Session.this._localParty.clone());
            fields.set(SipHeader.TO, Session.this._remoteParty.clone());
            if (this._remoteTarget != null) {
                request.setRequestURI(this._remoteTarget.clone());
            } else if (request.getRequestURI() == null) {
                request.setRequestURI(request.to().getURI());
            }
            if (this._routeSet != null) {
                fields.remove(SipHeader.ROUTE.asString());
                for (String route : this._routeSet) {
                    fields.add(SipHeader.ROUTE.asString(), route);
                }
            }
            fields.set(SipHeader.CALL_ID, (Object)Session.this._callId);
            fields.set(SipHeader.CSEQ, (Object)(cseq + " " + request.getMethod()));
            fields.set(SipHeader.MAX_FORWARDS, (Object)"70");
            if (request.needsContact()) {
                fields.set(SipHeader.CONTACT, (Object)Session.this.getContact());
            }
        }

        protected void createDialog(SipResponse response, boolean uac) {
            if (uac) {
                String tag = response.to().getTag();
                Session.this._remoteParty.setParameter("tag", tag);
                this.setRoute(response, true);
            } else {
                SipRequest request = (SipRequest)response.getRequest();
                this._remoteCSeq = request.getCSeq().getNumber();
                this._secure = request.isSecure() && request.getRequestURI().getScheme().equals("sips");
                this.setRoute(request, false);
            }
        }

        protected void setRoute(SipMessage message, boolean reverse) {
            ListIterator routes = message.getFields().getValues(SipHeader.RECORD_ROUTE.asString());
            this._routeSet = new LinkedList();
            while (routes.hasNext()) {
                if (reverse) {
                    this._routeSet.addFirst((String)routes.next());
                    continue;
                }
                this._routeSet.addLast((String)routes.next());
            }
        }

        public void handleRequest(SipRequest request) throws IOException, SipException {
            if (request.getCSeq().getNumber() <= this._remoteCSeq && !request.isAck() && !request.isCancel()) {
                throw new SipException(500, "Out of order request");
            }
            this._remoteCSeq = request.getCSeq().getNumber();
            if (this.isTargetRefresh(request)) {
                this.setRemoteTarget(request);
            }
            if (!request.isAck() && Session.this.isUA()) {
                Session.this.addServerTransaction((ServerTransaction)request.getTransaction());
            }
            if (request.isAck()) {
                ServerInvite invite = this.getServerInvite(this._remoteCSeq, false);
                if (invite == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("dropping ACK without INVITE context", new Object[0]);
                    }
                    request.setHandled(true);
                } else if (invite.getResponse() != null) {
                    invite.ack();
                } else {
                    request.setHandled(true);
                }
            } else if (request.isPrack()) {
                RAck rack = null;
                try {
                    rack = request.getRAck();
                }
                catch (Exception e) {
                    throw new SipException(400, e.getMessage());
                }
                ServerInvite invite = this.getServerInvite(rack.getCSeq(), false);
                if (invite == null || !invite.prack(rack.getRSeq())) {
                    throw new SipException(481, "No matching 100 rel for RAck " + rack);
                }
            }
        }

        @Override
        public void handleResponse(SipResponse response) {
            if (response.getStatus() == 100) {
                return;
            }
            if (!Session.this.isSameDialog(response)) {
                Session derived = Session.this._applicationSession.getSession(response);
                if (derived == null) {
                    derived = Session.this._applicationSession.createDerivedSession(Session.this);
                    if (Session.this._linkedSessionId != null) {
                        Session linkDerived = Session.this._applicationSession.createDerivedSession(Session.this.getLinkedSession());
                        linkDerived.setLinkedSession(derived);
                        derived.setLinkedSession(linkDerived);
                    }
                }
                derived._dialog.handleResponse(response);
                return;
            }
            response.setSession(Session.this);
            Session.this.access();
            if (response.isInvite() && response.is2xx()) {
                long cseq = response.getCSeq().getNumber();
                ClientInvite invite = this.getClientInvite(cseq, true);
                if (invite._2xx != null || invite._ack != null) {
                    if (invite._ack != null) {
                        try {
                            ClientTransaction tx = (ClientTransaction)invite._ack.getTransaction();
                            Session.this.getServer().sendRequest(invite._ack, tx.getConnection());
                        }
                        catch (Exception e) {
                            LOG.ignore((Throwable)e);
                        }
                    }
                    return;
                }
                invite._2xx = response;
            } else if (response.isReliable1xx()) {
                long rseq = response.getRSeq();
                if (this._remoteRSeq != -1L && this._remoteRSeq + 1L != rseq) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Dropping 100rel with rseq {} since expecting {}", new Object[]{rseq, this._remoteRSeq + 1L});
                    }
                    return;
                }
                this._remoteRSeq = rseq;
                long cseq = response.getCSeq().getNumber();
                ClientInvite invite = this.getClientInvite(cseq, true);
                invite.addReliable1xx(response);
            } else {
                response.setCommitted(true);
            }
            Session.this.updateState(response, true);
            if (this.isTargetRefresh(response)) {
                this.setRemoteTarget(response);
            }
            if (Session.this.isValid()) {
                Session.this.invokeServlet(response);
            }
        }

        @Override
        public void handleCancel(ServerTransaction tx, SipRequest cancel) throws IOException {
            cancel.setSession(tx.getRequest().session());
            if (tx.isCompleted()) {
                LOG.debug("ignoring late cancel {}", new Object[]{tx});
                cancel.createResponse(481).send();
            } else {
                try {
                    cancel.createResponse(200).send();
                    tx.getRequest().createResponse(487).send();
                    Session.this.setState(SipSession.State.TERMINATED);
                }
                catch (Exception e) {
                    LOG.debug("failed to cancel request", (Throwable)e);
                }
                Session.this.invokeServlet(cancel);
            }
        }

        public void sendResponse(SipResponse response, boolean reliable) throws IOException {
            boolean forked2xx;
            ServerTransaction tx = (ServerTransaction)response.getTransaction();
            SipRequest request = (SipRequest)response.getRequest();
            boolean bl = forked2xx = response.is2xx() && tx.getState() == Transaction.State.ACCEPTED;
            if (tx.isCompleted() && !forked2xx) {
                throw new IllegalStateException("no valid transaction");
            }
            tx.setListener(new ScopedServerTransactionListener(Session.this, this));
            Session.this.updateState(response, false);
            if (this.isTargetRefresh(request)) {
                this.setRemoteTarget(request);
            }
            if (request.isInvite()) {
                ServerInvite invite;
                int status = response.getStatus();
                long cseq = response.getCSeq().getNumber();
                if (200 <= status && status < 300) {
                    ServerInvite invite2 = Session.this._dialog.getServerInvite(cseq, true);
                    invite2.set2xx(response);
                } else if (100 < status && status < 200 && reliable) {
                    ServerInvite invite3 = Session.this._dialog.getServerInvite(cseq, true);
                    long rseq = this._localRSeq++;
                    response.getFields().addString(SipHeader.REQUIRE.toString(), "100rel", false);
                    response.setRSeq(rseq);
                    invite3.addReliable1xx(response);
                } else if (status >= 300 && (invite = Session.this._dialog.getServerInvite(cseq, false)) != null) {
                    invite.stop1xxRetrans();
                }
            }
            if (!forked2xx) {
                tx.send(response);
            } else {
                Session.this.getServer().sendResponse(response, tx.getConnection());
            }
        }

        private boolean isTargetRefresh(SipMessage message) {
            SipResponse response;
            if (message instanceof SipResponse && (response = (SipResponse)message).getStatus() >= 300) {
                return false;
            }
            return message.isInvite() || message.isSubscribe() || message.isNotify() || message.isNotify() || message.isMethod(SipMethod.REFER);
        }

        protected void setRemoteTarget(SipMessage message) {
            Address contact = null;
            try {
                SipFields.Field field = message.getFields().getField(SipHeader.CONTACT);
                if (field != null) {
                    contact = field.asAddress();
                }
            }
            catch (ServletParseException e) {
                LOG.debug((Throwable)e);
            }
            if (contact != null) {
                this._remoteTarget = contact.getURI();
            }
        }

        @Override
        public void customizeRequest(SipRequest request, SipConnection connection) {
        }

        @Override
        public void transactionTerminated(Transaction transaction) {
            Session.this.removeTransaction(transaction);
            if (transaction.isInvite()) {
                long cseq = transaction.getRequest().getCSeq().getNumber();
                if (transaction.isServer()) {
                    this.removeServerInvite(cseq);
                } else {
                    this.removeClientInvite(cseq);
                }
            }
        }

        private ClientInvite getClientInvite(long cseq, boolean create) {
            int i = LazyList.size((Object)this._clientInvites);
            while (i-- > 0) {
                ClientInvite invite = (ClientInvite)LazyList.get((Object)this._clientInvites, (int)i);
                if (invite.getCSeq() != cseq) continue;
                return invite;
            }
            if (create) {
                ClientInvite invite = new ClientInvite(cseq);
                this._clientInvites = LazyList.add((Object)this._clientInvites, (Object)invite);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("added client invite context with cseq " + cseq, new Object[0]);
                }
                return invite;
            }
            return null;
        }

        private ServerInvite getServerInvite(long cseq, boolean create) {
            int i = LazyList.size((Object)this._serverInvites);
            while (i-- > 0) {
                ServerInvite invite = (ServerInvite)LazyList.get((Object)this._serverInvites, (int)i);
                if (invite.getSeq() != cseq) continue;
                return invite;
            }
            if (create) {
                ServerInvite invite = new ServerInvite(cseq);
                this._serverInvites = LazyList.add((Object)this._serverInvites, (Object)invite);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("added server invite context with cseq " + cseq, new Object[0]);
                }
                return invite;
            }
            return null;
        }

        private ClientInvite removeClientInvite(long cseq) {
            int i = LazyList.size((Object)this._clientInvites);
            while (i-- > 0) {
                ClientInvite invite = (ClientInvite)LazyList.get((Object)this._clientInvites, (int)i);
                if (invite.getCSeq() != cseq) continue;
                this._clientInvites = LazyList.remove((Object)this._clientInvites, (int)i);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("removed client invite context for cseq " + cseq, new Object[0]);
                }
                return invite;
            }
            return null;
        }

        private ServerInvite removeServerInvite(long cseq) {
            int i = LazyList.size((Object)this._serverInvites);
            while (i-- > 0) {
                ServerInvite invite = (ServerInvite)LazyList.get((Object)this._serverInvites, (int)i);
                if (invite.getSeq() != cseq) continue;
                this._serverInvites = LazyList.remove((Object)this._serverInvites, (int)i);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("removed server invite context for cseq " + cseq, new Object[0]);
                }
                return invite;
            }
            return null;
        }

        public List<SipServletResponse> getUncommitted1xx(UAMode mode) {
            ArrayList<SipResponse> list = null;
            if (mode == UAMode.UAS) {
                int i = LazyList.size((Object)this._serverInvites);
                while (i-- > 0) {
                    ServerInvite invite = (ServerInvite)LazyList.get((Object)this._serverInvites, (int)i);
                    int j = LazyList.size((Object)invite._reliable1xxs);
                    while (j-- > 0) {
                        ServerInvite.Reliable1xx reliable1xx = (ServerInvite.Reliable1xx)LazyList.get((Object)invite._reliable1xxs, (int)j);
                        SipResponse response = reliable1xx.getResponse();
                        if (response == null || response.isCommitted()) continue;
                        if (list == null) {
                            list = new ArrayList<SipResponse>();
                        }
                        list.add(response);
                    }
                }
            } else {
                int i = LazyList.size((Object)this._clientInvites);
                while (i-- > 0) {
                    ClientInvite invite = (ClientInvite)LazyList.get((Object)this._clientInvites, (int)i);
                    int j = LazyList.size((Object)invite._reliable1xxs);
                    while (j-- > 0) {
                        ClientInvite.Reliable1xxClient reliable1xx = (ClientInvite.Reliable1xxClient)LazyList.get((Object)invite._reliable1xxs, (int)j);
                        SipResponse response = reliable1xx.getResponse();
                        if (response == null || response.isCommitted()) continue;
                        if (list == null) {
                            list = new ArrayList();
                        }
                        list.add(response);
                    }
                }
            }
            if (list == null) {
                return Collections.emptyList();
            }
            return list;
        }

        public List<SipServletResponse> getUncommitted2xx(UAMode mode) {
            ArrayList<SipResponse> list = null;
            if (mode == UAMode.UAS) {
                int i = LazyList.size((Object)this._serverInvites);
                while (i-- > 0) {
                    ServerInvite invite = (ServerInvite)LazyList.get((Object)this._serverInvites, (int)i);
                    SipResponse response = invite.getResponse();
                    if (response == null || response.isCommitted()) continue;
                    if (list == null) {
                        list = new ArrayList();
                    }
                    list.add(response);
                }
            } else {
                int i = LazyList.size((Object)this._clientInvites);
                while (i-- > 0) {
                    ClientInvite invite = (ClientInvite)LazyList.get((Object)this._clientInvites, (int)i);
                    if (invite._2xx == null || invite._2xx.isCommitted()) continue;
                    if (list == null) {
                        list = new ArrayList<SipResponse>();
                    }
                    list.add(invite._2xx);
                }
            }
            if (list == null) {
                return Collections.emptyList();
            }
            return list;
        }

        public String dump() {
            return ContainerLifeCycle.dump((Dumpable)this);
        }

        public void dump(Appendable sb, String indent) throws IOException {
            int i;
            sb.append(indent).append("+ [ua]\n");
            indent = indent + "  ";
            Session.this.printAttr(sb, "local CSeq", this._localCSeq, indent);
            Session.this.printAttr(sb, "Remote CSeq", this._remoteCSeq, indent);
            Session.this.printAttr(sb, "Remote Target", this._remoteTarget, indent);
            Session.this.printAttr(sb, "route Set", this._routeSet, indent);
            Session.this.printAttr(sb, "Secure", this._secure, indent);
            Session.this.printAttr(sb, "local RSeq", this._localRSeq, indent);
            Session.this.printAttr(sb, "Remote RSeq", this._remoteRSeq, indent);
            if (LazyList.size((Object)this._serverInvites) != 0) {
                sb.append(indent).append("+ [serveur INVITE]\n");
                for (i = 0; i < LazyList.size((Object)this._serverInvites); ++i) {
                    sb.append(indent + "  ").append("- ").append(LazyList.get((Object)this._serverInvites, (int)i).toString()).append('\n');
                }
            }
            if (LazyList.size((Object)this._clientInvites) != 0) {
                sb.append(indent).append("+ [client INVITE]\n");
                for (i = 0; i < LazyList.size((Object)this._clientInvites); ++i) {
                    sb.append(indent + "  ").append("- ").append(LazyList.get((Object)this._clientInvites, (int)i).toString()).append('\n');
                }
            }
        }

        class ServerInvite
        extends ReliableResponse {
            private Object _reliable1xxs;

            public ServerInvite(long cseq) {
                super(cseq);
            }

            public void set2xx(SipResponse response) {
                this.stop1xxRetrans();
                this.startRetrans(response);
            }

            public void addReliable1xx(SipResponse response) {
                Reliable1xx reliable1xx = new Reliable1xx(response.getRSeq());
                this._reliable1xxs = LazyList.add((Object)this._reliable1xxs, (Object)reliable1xx);
                reliable1xx.startRetrans(response);
            }

            public boolean prack(long rseq) {
                int i = LazyList.size((Object)this._reliable1xxs);
                while (i-- > 0) {
                    Reliable1xx reliable1xx = (Reliable1xx)LazyList.get((Object)this._reliable1xxs, (int)i);
                    if (reliable1xx.getSeq() != rseq) continue;
                    reliable1xx.ack();
                    this._reliable1xxs = LazyList.remove((Object)this._reliable1xxs, (int)i);
                    return true;
                }
                return false;
            }

            public void stop1xxRetrans() {
                int i = LazyList.size((Object)this._reliable1xxs);
                while (i-- > 0) {
                    Reliable1xx reliable1xx = (Reliable1xx)LazyList.get((Object)this._reliable1xxs, (int)i);
                    reliable1xx.stopRetrans();
                }
            }

            @Override
            public void noAck() {
                List<SipErrorListener> listeners;
                if (Session.this.isValid() && !(listeners = Session.this._applicationSession.getContext().getSipErrorListeners()).isEmpty()) {
                    Session.this._applicationSession.getContext().fire(Session.this._applicationSession, listeners, ApplicationSession.__noAck, new SipErrorEvent(this.getResponse().getRequest(), (SipServletResponse)this.getResponse()));
                }
            }

            @Override
            public long retransmit(long delay) {
                SipResponse response = this.getResponse();
                ServerTransaction tx = (ServerTransaction)response.getTransaction();
                if (tx != null) {
                    tx.send(response);
                } else {
                    try {
                        SipRequest request = (SipRequest)response.getRequest();
                        if (request != null) {
                            Session.this.getServer().sendResponse(response, request.getConnection());
                        }
                    }
                    catch (IOException e) {
                        LOG.debug((Throwable)e);
                    }
                }
                return Math.min(delay * 2L, (long)TransactionImpl.__T2);
            }

            @Override
            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("CSeq: ").append(this.getSeq());
                if (LazyList.size((Object)this._reliable1xxs) != 0) {
                    sb.append(", RSeq={");
                    for (int i = 0; i < LazyList.size((Object)this._reliable1xxs); ++i) {
                        sb.append(LazyList.get((Object)this._reliable1xxs, (int)i));
                    }
                    sb.append("}");
                }
                return sb.toString();
            }

            class Reliable1xx
            extends ReliableResponse {
                public Reliable1xx(long rseq) {
                    super(rseq);
                }

                @Override
                public long retransmit(long delay) {
                    ServerTransaction tx = (ServerTransaction)this.getResponse().getTransaction();
                    if (tx.getState() == Transaction.State.PROCEEDING) {
                        tx.send(this.getResponse());
                        return delay * 2L;
                    }
                    return -1L;
                }

                @Override
                public void noAck() {
                    List<SipErrorListener> listeners;
                    if (Session.this.isValid() && Session.this.isValid() && !(listeners = Session.this._applicationSession.getContext().getSipErrorListeners()).isEmpty()) {
                        Session.this._applicationSession.getContext().fire(Session.this._applicationSession, listeners, ApplicationSession.__noPrack, new SipErrorEvent(this.getResponse().getRequest(), (SipServletResponse)this.getResponse()));
                    }
                }
            }
        }

        abstract class ReliableResponse {
            private static final int TIMER_RETRANS = 0;
            private static final int TIMER_WAIT_ACK = 1;
            private long _seq;
            protected SipResponse _response;
            private TimerTask[] _timers;
            private long _retransDelay = TransactionImpl.__T1;

            public ReliableResponse(long seq) {
                this._seq = seq;
            }

            public long getSeq() {
                return this._seq;
            }

            public SipResponse getResponse() {
                return this._response;
            }

            public void startRetrans(SipResponse response) {
                this._response = response;
                this._timers = new TimerTask[2];
                this._timers[0] = Session.this.appSession().getSessionManager().schedule(new Timer(0), this._retransDelay);
                this._timers[1] = Session.this.appSession().getSessionManager().schedule(new Timer(1), 64 * TransactionImpl.__T1);
            }

            public void stopRetrans() {
                this.cancelTimer(0);
                this._response = null;
            }

            public void ack() {
                this.stopRetrans();
                this.cancelTimer(1);
            }

            private void cancelTimer(int id) {
                TimerTask timer = this._timers[id];
                if (timer != null) {
                    timer.cancel();
                }
                this._timers[id] = null;
            }

            public abstract long retransmit(long var1);

            public abstract void noAck();

            protected void timeout(int id) {
                switch (id) {
                    case 0: {
                        if (this._response == null) break;
                        this._retransDelay = this.retransmit(this._retransDelay);
                        if (this._retransDelay <= 0L) break;
                        this._timers[0] = Session.this.appSession().getSessionManager().schedule(new Timer(0), this._retransDelay);
                        break;
                    }
                    case 1: {
                        this.cancelTimer(0);
                        if (this._response == null) break;
                        this.noAck();
                        this._response = null;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown id " + id);
                    }
                }
            }

            public String toString() {
                return String.valueOf(this.getSeq());
            }

            class Timer
            implements Runnable {
                private int _id;

                public Timer(int id) {
                    this._id = id;
                }

                @Override
                public void run() {
                    ReliableResponse.this.timeout(this._id);
                }

                public String toString() {
                    return this._id == 0 ? "retrans" : "wait-ack";
                }
            }
        }

        class ClientInvite {
            private long _cseq;
            private SipRequest _ack;
            private SipResponse _2xx;
            private Object _reliable1xxs;

            public ClientInvite(long cseq) {
                this._cseq = cseq;
            }

            public long getCSeq() {
                return this._cseq;
            }

            public void addReliable1xx(SipResponse response) {
                Reliable1xxClient reliable1xx = new Reliable1xxClient(response);
                this._reliable1xxs = LazyList.add((Object)this._reliable1xxs, (Object)reliable1xx);
            }

            public boolean prack(long rseq) {
                int i = LazyList.size((Object)this._reliable1xxs);
                while (i-- > 0) {
                    Reliable1xxClient reliable1xx = (Reliable1xxClient)LazyList.get((Object)this._reliable1xxs, (int)i);
                    if (reliable1xx.getRSeq() != rseq) continue;
                    this._reliable1xxs = LazyList.remove((Object)this._reliable1xxs, (int)i);
                    return true;
                }
                return false;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("CSeq: ").append(this._cseq);
                if (LazyList.size((Object)this._reliable1xxs) != 0) {
                    sb.append(", RSeq={");
                    for (int i = 0; i < LazyList.size((Object)this._reliable1xxs); ++i) {
                        sb.append(LazyList.get((Object)this._reliable1xxs, (int)i));
                    }
                    sb.append("}");
                }
                return sb.toString();
            }

            class Reliable1xxClient {
                private SipResponse _1xx;

                public Reliable1xxClient(SipResponse response) {
                    this._1xx = response;
                }

                public long getRSeq() {
                    return this._1xx.getRSeq();
                }

                public SipResponse getResponse() {
                    return this._1xx;
                }

                public String toString() {
                    return String.valueOf(this.getRSeq());
                }
            }
        }
    }

    public static enum Role {
        UNDEFINED,
        UAC,
        UAS,
        PROXY_RECORD_ROUTE,
        PROXY_NO_RECORD_ROUTE;

    }
}

