/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.session;

import java.security.SecureRandom;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.cipango.server.session.IdManager;
import org.cipango.util.StringUtil;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HashIdManager
extends AbstractLifeCycle
implements IdManager {
    private static final Logger LOG = Log.getLogger(HashIdManager.class);
    private final Set<String> _ids = new ConcurrentSkipListSet<String>();
    private String _prefix;
    private String _postfix;
    private Random _random;

    protected void doStart() throws Exception {
        this.initRandom();
    }

    protected void doStop() throws Exception {
        int size = this._ids.size();
        if (size > 0) {
            LOG.warn("Id manager has {} elements at stop", new Object[]{size});
        }
    }

    public void initRandom() {
        if (this._random == null) {
            try {
                this._random = new SecureRandom();
            }
            catch (Exception e) {
                LOG.warn("Could not generate SecureRandom for session-id randomness", (Throwable)e);
                this._random = new Random();
            }
        } else {
            this._random.setSeed(this._random.nextLong() ^ System.currentTimeMillis() ^ (long)this.hashCode() ^ Runtime.getRuntime().freeMemory());
        }
    }

    @Override
    public String newId() {
        boolean added;
        String id = null;
        do {
            long r;
            if ((r = this._random.nextLong()) < 0L) {
                r = -r;
            }
            id = StringUtil.toBase62String2((long)r);
            if (this._prefix != null) {
                id = this._prefix + id;
            }
            if (this._postfix != null) {
                id = id + this._postfix;
            }
            if (added = this._ids.add(id)) continue;
            LOG.warn("Id already in use: " + id, new Object[0]);
        } while (!added);
        return id;
    }

    @Override
    public void releaseId(String id) {
        this._ids.remove(id);
    }

    @Override
    public String getPrefix() {
        return this._prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this._prefix = prefix;
    }

    public Random getRandom() {
        return this._random;
    }

    public void setRandom(Random random) {
        this._random = random;
    }

    @Override
    public boolean idInUse(String id) {
        return this._ids.contains(id);
    }

    @Override
    public String getPostfix() {
        return this._postfix;
    }

    @Override
    public void setPostfix(String postfix) {
        this._postfix = postfix;
    }
}

