/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.session;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpSession;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipApplicationSessionBindingEvent;
import javax.servlet.sip.SipApplicationSessionBindingListener;
import javax.servlet.sip.SipApplicationSessionEvent;
import javax.servlet.sip.SipApplicationSessionListener;
import javax.servlet.sip.SipErrorEvent;
import javax.servlet.sip.SipErrorListener;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipSessionEvent;
import javax.servlet.sip.SipSessionListener;
import javax.servlet.sip.TimerListener;
import javax.servlet.sip.UAMode;
import javax.servlet.sip.URI;
import org.cipango.server.SipMessage;
import org.cipango.server.SipRequest;
import org.cipango.server.session.Session;
import org.cipango.server.session.SessionManager;
import org.cipango.server.session.scoped.ScopedRunable;
import org.cipango.server.sipapp.SipAppContext;
import org.cipango.util.TimerTask;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ApplicationSession
implements SipApplicationSession,
SessionManager.AppSessionIf,
Dumpable {
    private static final Logger LOG = Log.getLogger(ApplicationSession.class);
    private final String _id;
    protected final List<Session> _sessions = new CopyOnWriteArrayList<Session>();
    protected List<Object> _otherSessions;
    private final long _created;
    private long _accessed;
    private long _timeoutMs = 30000L;
    private boolean _valid = true;
    protected Map<String, Object> _attributes;
    private final SessionManager _sessionManager;
    protected List<ServletTimer> _timers;
    protected boolean _invalidateWhenReady = true;
    private final ReentrantLock _lock = new ReentrantLock();
    protected static Method __noAck;
    protected static Method __noPrack;
    protected static Method __appSessionReadyToInvalidate;
    protected static Method __sessionCreated;
    protected static Method __sessionReadyToInvalidate;
    protected static Method __sessionDestroyed;

    public ApplicationSession(SessionManager sessionManager, String id) {
        this(sessionManager, id, System.currentTimeMillis(), 0L);
    }

    public ApplicationSession(SessionManager sessionManager, String id, long created, long access) {
        this._sessionManager = sessionManager;
        this._created = created;
        this._accessed = access;
        this._id = id;
        if (this.getContext().getSpecVersion() == 10) {
            this._invalidateWhenReady = false;
        }
    }

    public SessionManager getSessionManager() {
        return this._sessionManager;
    }

    protected ReentrantLock getLock() {
        return this._lock;
    }

    public Session createSession(SipRequest initial) {
        Session session = new Session(this, this._sessionManager.newSessionId(), initial);
        this.addSession(session);
        return session;
    }

    public Session createUacSession(String callId, Address from, Address to) {
        Session session = new Session(this, this._sessionManager.newSessionId(), callId, from, to);
        this.addSession(session);
        session.createUA(UAMode.UAC);
        return session;
    }

    public Session createDerivedSession(Session session) {
        if (session.appSession() != this) {
            throw new IllegalArgumentException("SipSession " + session.getId() + " does not belong to SipApplicationSession " + this.getId());
        }
        Session derived = new Session(this._sessionManager.newSessionId(), session);
        derived.setInvalidateWhenReady(this._invalidateWhenReady);
        this.addSession(derived);
        return derived;
    }

    public void addSession(Object session) {
        if (session instanceof Session) {
            this._sessions.add((Session)session);
            List<SipSessionListener> listeners = this.getSessionManager().getSessionListeners();
            if (!listeners.isEmpty()) {
                SipSessionEvent event = new SipSessionEvent((SipSession)session);
                this.getContext().fire(this, listeners, __sessionCreated, event);
            }
        } else {
            if (this._otherSessions == null) {
                this._otherSessions = new ArrayList<Object>();
            }
            this._otherSessions.add(session);
        }
    }

    protected String newSessionId() {
        return this._sessionManager.newSessionId();
    }

    public String newUASTag() {
        return this._sessionManager.newUASTag(this);
    }

    public String newBranch() {
        return this._sessionManager.newBranch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putAttribute(String name, Object value) {
        this.assertLocked();
        Object old = null;
        ApplicationSession applicationSession = this;
        synchronized (applicationSession) {
            this.checkValid();
            old = this.doPutOrRemove(name, value);
        }
        if (value == null || !value.equals(old)) {
            if (old != null) {
                this.unbindValue(name, old);
            }
            if (value != null) {
                this.bindValue(name, value);
            }
            this._sessionManager.doApplicationSessionAttributeListeners(this, name, old, value);
        }
    }

    public void unbindValue(String name, Object value) {
        if (value != null && value instanceof SipApplicationSessionBindingListener) {
            ((SipApplicationSessionBindingListener)value).valueUnbound(new SipApplicationSessionBindingEvent((SipApplicationSession)this, name));
        }
    }

    public void bindValue(String name, Object value) {
        if (value != null && value instanceof SipApplicationSessionBindingListener) {
            ((SipApplicationSessionBindingListener)value).valueBound(new SipApplicationSessionBindingEvent((SipApplicationSession)this, name));
        }
    }

    protected Object doPutOrRemove(String name, Object value) {
        if (value == null) {
            return this._attributes != null ? this._attributes.remove(name) : null;
        }
        if (this._attributes == null) {
            this._attributes = new HashMap<String, Object>();
        }
        return this._attributes.put(name, value);
    }

    public void removeSession(Object session) {
        this.assertLocked();
        if (session instanceof SipSession) {
            this._sessions.remove((SipSession)session);
            List<SipSessionListener> listeners = this.getSessionManager().getSessionListeners();
            if (!listeners.isEmpty()) {
                SipSessionEvent event = new SipSessionEvent((SipSession)session);
                this.getContext().fire(this, listeners, __sessionDestroyed, event);
            }
            this._sessionManager.removeSipSession((Session)session);
        } else if (this._otherSessions != null) {
            this._otherSessions.remove(session);
        }
    }

    public long getTimeoutMs() {
        return this._timeoutMs;
    }

    public SipAppContext getContext() {
        return this._sessionManager.getSipAppContext();
    }

    public long getCreationTime() {
        this.checkValid();
        return this._created;
    }

    public void access(long time) {
        this.assertLocked();
        this._accessed = time;
    }

    public long getExpirationTime() {
        this.checkValid();
        if (this._timeoutMs == 0L) {
            return 0L;
        }
        long expirationTime = this._accessed + this._timeoutMs;
        if (expirationTime < System.currentTimeMillis()) {
            return Long.MIN_VALUE;
        }
        return expirationTime;
    }

    public long getLastAccessedTime() {
        return this._accessed;
    }

    public int setExpires(int deltaMinutes) {
        this.checkValid();
        if (deltaMinutes < 0) {
            deltaMinutes = 0;
        }
        this._timeoutMs = deltaMinutes * 60 * 1000;
        if (deltaMinutes == 0) {
            return Integer.MAX_VALUE;
        }
        return deltaMinutes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        this.checkValid();
        this.assertLocked();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("invalidating SipApplicationSession: " + this, new Object[0]);
            }
            ApplicationSession applicationSession = this;
            synchronized (applicationSession) {
                for (Session session : this._sessions) {
                    if (!session.isValid()) continue;
                    session.invalidate();
                }
                if (this._otherSessions != null) {
                    ArrayList<Object> otherSessions = new ArrayList<Object>(this._otherSessions);
                    for (Object e : otherSessions) {
                        if (!(e instanceof HttpSession)) continue;
                        ((HttpSession)e).invalidate();
                    }
                    this._otherSessions = null;
                }
                while (this._timers != null && !this._timers.isEmpty()) {
                    this._timers.get(0).cancel();
                }
                this._timers = null;
                this._sessionManager.removeApplicationSession(this);
                while (this._attributes != null && this._attributes.size() > 0) {
                    ArrayList<String> keys = new ArrayList<String>(this._attributes.keySet());
                    for (String string : keys) {
                        this.removeAttribute(string);
                    }
                }
            }
        }
        finally {
            this._valid = false;
        }
    }

    private void checkValid() {
        if (!this._valid) {
            throw new IllegalStateException("SipApplicationSession has been invalidated");
        }
    }

    protected void assertLocked() {
        if (!this._lock.isHeldByCurrentThread()) {
            LOG.warn("Application session " + this.toString() + " is not locked by thread " + Thread.currentThread(), (Throwable)new IllegalStateException());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Application session " + this.toString() + " is not locked by thread " + Thread.currentThread(), (Throwable)new IllegalStateException());
            }
        }
    }

    public void encodeURI(URI uri) {
        this.checkValid();
        uri.setParameter("appid", this.getId());
    }

    public URL encodeURL(URL url) {
        this.checkValid();
        String appIdPrefix = ";appid=";
        try {
            String sUrl = url.toExternalForm();
            String id = this.getId().replace(";", "%3B");
            int prefix = sUrl.indexOf(appIdPrefix);
            if (prefix != -1) {
                int suffix = sUrl.indexOf("?", prefix);
                if (suffix < 0) {
                    suffix = sUrl.indexOf("#", prefix);
                }
                if (suffix <= prefix) {
                    return new URL(sUrl.substring(0, prefix + appIdPrefix.length()) + id);
                }
                return new URL(sUrl.substring(0, prefix + appIdPrefix.length()) + id + sUrl.substring(suffix));
            }
            int suffix = sUrl.indexOf(63);
            if (suffix < 0) {
                suffix = sUrl.indexOf(35);
            }
            if (suffix < 0) {
                return new URL(sUrl + appIdPrefix + id);
            }
            return new URL(sUrl.substring(0, suffix) + appIdPrefix + id + sUrl.substring(suffix));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public String getApplicationName() {
        if (this.getContext() == null) {
            return null;
        }
        return this.getContext().getName();
    }

    public synchronized Object getAttribute(String name) {
        this.checkValid();
        return this._attributes != null ? this._attributes.get(name) : null;
    }

    public Iterator<String> getAttributeNames() {
        this.checkValid();
        if (this._attributes == null) {
            return Collections.emptyIterator();
        }
        return new ArrayList<String>(this._attributes.keySet()).iterator();
    }

    public String getId() {
        return this._id;
    }

    public boolean getInvalidateWhenReady() {
        this.checkValid();
        return this._invalidateWhenReady;
    }

    public Object getSession(String id, SipApplicationSession.Protocol protocol) {
        block4: {
            block3: {
                this.checkValid();
                if (id == null || protocol == null) {
                    throw new NullPointerException(id == null ? "null id" : "null protocol");
                }
                if (protocol != SipApplicationSession.Protocol.SIP) break block3;
                for (Session session : this._sessions) {
                    if (!session.getId().equals(id)) continue;
                    return session;
                }
                break block4;
            }
            if (protocol != SipApplicationSession.Protocol.HTTP || this._otherSessions == null) break block4;
            for (Object session : this._otherSessions) {
                if (!(session instanceof HttpSession) || !((HttpSession)session).getId().equals(id)) continue;
                return session;
            }
        }
        return null;
    }

    public Iterator<?> getSessions() {
        this.checkValid();
        ArrayList<Session> list = new ArrayList<Session>(this._sessions);
        if (this._otherSessions != null) {
            list.addAll(this._otherSessions);
        }
        return list.iterator();
    }

    public Iterator<?> getSessions(String protocol) {
        this.checkValid();
        if (protocol == null) {
            throw new NullPointerException("null protocol");
        }
        if ("sip".equalsIgnoreCase(protocol)) {
            return new ArrayList<Session>(this._sessions).iterator();
        }
        if ("http".equalsIgnoreCase(protocol)) {
            if (this._otherSessions == null) {
                return Collections.emptyIterator();
            }
            ArrayList<HttpSession> sessions = new ArrayList<HttpSession>();
            for (Object session : this._otherSessions) {
                if (!(session instanceof HttpSession)) continue;
                sessions.add((HttpSession)session);
            }
            return sessions.iterator();
        }
        throw new IllegalArgumentException("Unknown protocol " + protocol);
    }

    public SipSession getSipSession(String id) {
        this.checkValid();
        for (Session session : this._sessions) {
            if (!session.getId().equals(id)) continue;
            return session;
        }
        return null;
    }

    public ServletTimer getTimer(String id) {
        this.checkValid();
        if (this._timers != null) {
            for (ServletTimer timer : this._timers) {
                if (!timer.getId().equals(id)) continue;
                return timer;
            }
        }
        return null;
    }

    public Collection<ServletTimer> getTimers() {
        this.checkValid();
        if (this._timers == null) {
            return Collections.emptyList();
        }
        return new ArrayList<ServletTimer>(this._timers);
    }

    public boolean isReadyToInvalidate() {
        this.checkValid();
        if (this._accessed == 0L) {
            return false;
        }
        for (int i = 0; i < this._sessions.size(); ++i) {
            Session session = this._sessions.get(i);
            if (session.isReadyToInvalidate()) continue;
            return false;
        }
        if (this._otherSessions != null && !this._otherSessions.isEmpty()) {
            return false;
        }
        return this._timers == null || this._timers.isEmpty();
    }

    public boolean isValid() {
        return this._valid;
    }

    public void removeAttribute(String name) {
        this.putAttribute(name, null);
    }

    public void setAttribute(String name, Object value) {
        if (name == null || value == null) {
            throw new NullPointerException("Name or attribute is null");
        }
        this.putAttribute(name, value);
    }

    public void setInvalidateWhenReady(boolean invalidateWhenReady) {
        this.checkValid();
        this._invalidateWhenReady = invalidateWhenReady;
    }

    public String toString() {
        return this._id + "/" + this.getApplicationName() + "(" + this._sessions.size() + ")";
    }

    @Override
    public ApplicationSession getAppSession() {
        return this;
    }

    private void addTimer(Timer timer) {
        if (this._timers == null) {
            this._timers = new ArrayList<ServletTimer>(1);
        }
        this._timers.add(timer);
    }

    private void removeTimer(Timer timer) {
        if (this._timers != null) {
            this._timers.remove(timer);
        }
    }

    public synchronized Session getSession(SipMessage message) {
        String ftag = message.from().getTag();
        String ttag = message.to().getTag();
        String callId = message.getCallId();
        for (int i = 0; i < this._sessions.size(); ++i) {
            Session session = this._sessions.get(i);
            if (!session.isDialog(callId, ftag, ttag)) continue;
            return session;
        }
        return null;
    }

    public void invalidateIfReady() {
        boolean invalidateSessionsWhenReady = true;
        for (Session session : this._sessions) {
            if (session.getInvalidateWhenReady()) {
                session.invalidateIfReady();
                continue;
            }
            invalidateSessionsWhenReady = false;
        }
        if (this.isValid() && this.getInvalidateWhenReady() && invalidateSessionsWhenReady && this.isReadyToInvalidate()) {
            List<SipApplicationSessionListener> listeners = this.getSessionManager().getApplicationSessionListeners();
            if (!listeners.isEmpty()) {
                this.getContext().fire(this, listeners, __appSessionReadyToInvalidate, new SipApplicationSessionEvent((SipApplicationSession)this));
            }
            if (this.getInvalidateWhenReady() && this.isValid()) {
                this.invalidate();
            }
        }
    }

    public List<Session> getDerivedSessions(Session session) {
        String tag = session.getLocalTag();
        String callID = session.getCallId();
        ArrayList<Session> list = new ArrayList<Session>(1);
        for (Session sipSession : this._sessions) {
            if (!tag.equals(sipSession.getLocalTag()) || !callID.equals(sipSession.getCallId())) continue;
            list.add(sipSession);
        }
        return list;
    }

    public String dump() {
        return ContainerLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        Iterator<Session> it;
        out.append(indent).append("+ ").append(this.getId()).append('\n');
        indent = indent + "  ";
        this.printAttr(out, "created", new Date(this.getCreationTime()), indent);
        this.printAttr(out, "accessed", new Date(this.getLastAccessedTime()), indent);
        this.printAttr(out, "expirationTime", new Date(this.getExpirationTime()), indent);
        this.printAttr(out, "context", this.getContext().getName(), indent);
        this.printAttr(out, "invalidateWhenReady", this.getInvalidateWhenReady(), indent);
        this.printAttr(out, "lock", this._lock, indent);
        this.printAttr(out, "attributes", this._attributes, indent);
        if (this._timers != null && !this._timers.isEmpty()) {
            Iterator<ServletTimer> it4 = this._timers.iterator();
            out.append(indent).append("+ [Timers]\n");
            while (it4.hasNext()) {
                out.append(indent).append("  + ").append(it4.next().toString()).append('\n');
            }
        }
        if ((it = this._sessions.iterator()).hasNext()) {
            out.append(indent).append("+ [sipSessions]\n");
        }
        while (it.hasNext()) {
            it.next().dump(out, indent + "  ");
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SessionManager.AppSessionIf)) {
            return false;
        }
        ApplicationSession session = ((SessionManager.AppSessionIf)o).getAppSession();
        return this == session;
    }

    private void printAttr(Appendable out, String name, Object value, String indent) throws IOException {
        out.append(indent).append("- ").append(name).append(": ").append(String.valueOf(value)).append('\n');
    }

    public Timer newTimer(long delay, boolean isPersistent, Serializable info) {
        return new Timer(this, delay, -1L, false, isPersistent, info);
    }

    public Timer newTimer(long delay, long period, boolean fixedDelay, boolean isPersistent, Serializable info) {
        return new Timer(this, delay, period, fixedDelay, isPersistent, info);
    }

    static {
        try {
            __noAck = SipErrorListener.class.getMethod("noAckReceived", SipErrorEvent.class);
            __noPrack = SipErrorListener.class.getMethod("noPrackReceived", SipErrorEvent.class);
            __appSessionReadyToInvalidate = SipApplicationSessionListener.class.getMethod("sessionReadyToInvalidate", SipApplicationSessionEvent.class);
            __sessionCreated = SipSessionListener.class.getMethod("sessionCreated", SipSessionEvent.class);
            __sessionReadyToInvalidate = SipSessionListener.class.getMethod("sessionReadyToInvalidate", SipSessionEvent.class);
            __sessionDestroyed = SipSessionListener.class.getMethod("sessionDestroyed", SipSessionEvent.class);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static class Timer
    extends ScopedRunable
    implements ServletTimer,
    Runnable {
        private Serializable _info;
        private long _period;
        private TimerTask _timerTask;
        private boolean _persistent;
        private final String _id;
        private long _scheduleExecutionTime = -1L;
        private boolean _fixedDelay;

        public Timer(ApplicationSession session, long delay, long period, boolean fixedDelay, boolean isPersistent, Serializable info) {
            this(session, delay, period, fixedDelay, isPersistent, info, session.getSessionManager().newTimerId());
        }

        public Timer(ApplicationSession session, long delay, long period, boolean fixedDelay, boolean isPersistent, Serializable info, String id) {
            super(session);
            session.checkValid();
            session.addTimer(this);
            this._info = info;
            this._period = period;
            this._timerTask = session.getSessionManager().schedule(this, delay);
            this._persistent = isPersistent;
            this._id = id;
            this._fixedDelay = fixedDelay;
        }

        public Serializable getInfo() {
            return this._info;
        }

        public long scheduledExecutionTime() {
            return this._scheduleExecutionTime;
        }

        public String getId() {
            return this._id;
        }

        public long getTimeRemaining() {
            return this._timerTask.getExecutionTime() - System.currentTimeMillis();
        }

        public long getPeriod() {
            return this._period;
        }

        public boolean isPersistent() {
            return this._persistent;
        }

        public void cancel() {
            if (this._session != null) {
                this._timerTask.cancel();
                this._session.removeTimer(this);
                this._period = -1L;
            }
        }

        public String toString() {
            long remaining = this.getTimeRemaining();
            return "ServletTimer {" + this._info + "}@" + (Math.abs(remaining) > 2000L ? remaining / 1000L + "s" : remaining + "ms");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doRun() {
            ApplicationSession session = this._session;
            try (SessionManager.ApplicationSessionScope scope = session.getSessionManager().openScope(session, 10);){
                this._scheduleExecutionTime = this._timerTask.getExecutionTime();
                List<TimerListener> listeners = session.getContext().getTimerListeners();
                if (!listeners.isEmpty()) {
                    for (TimerListener l : listeners) {
                        try {
                            l.timeout((ServletTimer)this);
                        }
                        catch (Throwable t) {
                            LOG.debug("Failed to invoke listener " + l, t);
                        }
                    }
                } else {
                    LOG.warn("The timer {} has been created by application {} but no timer listeners defined", new Object[]{this.toString(), session.getApplicationName()});
                }
                if (this._period != -1L) {
                    long delay = this._fixedDelay ? this._period + this._scheduleExecutionTime - System.currentTimeMillis() : this._period;
                    this._timerTask = session.getSessionManager().schedule(this, delay);
                } else {
                    session.removeTimer(this);
                }
            }
        }

        public SipApplicationSession getApplicationSession() {
            return this._session;
        }
    }
}

