/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.servlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import org.cipango.server.SipMessage;
import org.cipango.server.servlet.SipServletHandler;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="SIP servlet holder")
public class SipServletHolder
extends Holder<SipServlet>
implements UserIdentity.Scope,
Comparable<SipServletHolder> {
    private static final Logger LOG = Log.getLogger(SipServletHolder.class);
    private transient SipServlet _servlet;
    private transient Config _config;
    private long _unavailable;
    private int _initOrder;
    private boolean _initOnStartup = false;
    private SipServletHandler _servletHandler;
    private transient UnavailableException _unavailableEx;
    private Map<String, String> _roleMap;
    private String _runAsRole;

    public SipServletHolder() {
        super(Holder.Source.EMBEDDED);
    }

    public SipServletHolder(Holder.Source source) {
        super(source);
    }

    public void doStart() throws Exception {
        this._unavailable = 0L;
        try {
            super.doStart();
            if (this._class == null || !SipServlet.class.isAssignableFrom(this._class)) {
                throw new UnavailableException("Servlet " + this._class + " is not a javax.servlet.sip.SipServlet");
            }
        }
        catch (UnavailableException ue) {
            this.makeUnavailable(ue);
            throw ue;
        }
        this._config = new Config();
        if (this._extInstance || this._initOnStartup) {
            this.initServlet();
        }
    }

    public void doStop() throws Exception {
        if (this._servlet != null) {
            try {
                this._servlet.destroy();
                if (this._servletHandler != null) {
                    this._servletHandler.destroyServlet((Servlet)this._servlet);
                }
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
        this._servlet = null;
        this._config = null;
    }

    public UnavailableException getUnavailableException() {
        return this._unavailableEx;
    }

    public synchronized void setServlet(SipServlet servlet) {
        if (servlet == null) {
            throw new IllegalArgumentException();
        }
        this._servlet = servlet;
        this.setHeldClass(servlet.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(SipMessage message) throws ServletException, IOException {
        if (this._class == null) {
            throw new UnavailableException("Servlet not initialized");
        }
        SipServlet servlet = this._servlet;
        SipServletHolder sipServletHolder = this;
        synchronized (sipServletHolder) {
            if (this._unavailable != 0L || !this._initOnStartup) {
                servlet = this.getServlet();
            }
            if (servlet == null) {
                throw new UnavailableException("Could not instantiate " + this._class);
            }
        }
        if (message.isRequest()) {
            servlet.service((ServletRequest)((SipServletRequest)message), null);
        } else {
            servlet.service(null, (ServletResponse)((SipServletResponse)message));
        }
    }

    public synchronized Servlet getServlet() throws ServletException {
        if (this._servlet == null) {
            this.initServlet();
        }
        return this._servlet;
    }

    public Servlet getServletInstance() {
        return this._servlet;
    }

    protected SipServlet newInstance() throws InstantiationException, IllegalAccessException, ServletException {
        try {
            ServletContext ctx = this._servletHandler.getServletContext();
            if (ctx == null) {
                return (SipServlet)this._class.newInstance();
            }
            return (SipServlet)ctx.createServlet(this._class);
        }
        catch (ServletException se) {
            Throwable cause = se.getRootCause();
            if (cause instanceof InstantiationException) {
                throw (InstantiationException)cause;
            }
            if (cause instanceof IllegalAccessException) {
                throw (IllegalAccessException)cause;
            }
            throw se;
        }
    }

    private void initServlet() throws ServletException {
        try {
            if (this._servlet == null) {
                this._servlet = this.newInstance();
            }
            if (this._config == null) {
                this._config = new Config();
            }
            this._servlet.init((ServletConfig)this._config);
            if (this._servletHandler != null && this._servletHandler.getServer() != null && this._servletHandler.getServer().isStarted()) {
                this._servletHandler.getAppContext().fireServletInitialized(this._servlet);
            }
        }
        catch (UnavailableException e) {
            this.makeUnavailable(e);
            this._servlet = null;
            this._config = null;
            throw e;
        }
        catch (ServletException e) {
            this.makeUnavailable(e.getCause() == null ? e : e.getCause());
            this._servlet = null;
            this._config = null;
            throw e;
        }
        catch (Exception e) {
            this.makeUnavailable(e);
            this._servlet = null;
            this._config = null;
            throw new ServletException(this.toString(), (Throwable)e);
        }
    }

    private void makeUnavailable(UnavailableException e) {
        if (this._unavailableEx == e && this._unavailable != 0L) {
            return;
        }
        this._servletHandler.getServletContext().log("unavailable", (Throwable)e);
        this._unavailableEx = e;
        this._unavailable = -1L;
        this._unavailable = e.isPermanent() ? -1L : (this._unavailableEx.getUnavailableSeconds() > 0 ? System.currentTimeMillis() + (long)(1000 * this._unavailableEx.getUnavailableSeconds()) : System.currentTimeMillis() + 5000L);
    }

    private void makeUnavailable(final Throwable e) {
        if (e instanceof UnavailableException) {
            this.makeUnavailable((UnavailableException)e);
        } else {
            ServletContext ctx = this._servletHandler.getServletContext();
            if (ctx == null) {
                LOG.info("unavailable", e);
            } else {
                ctx.log("unavailable", e);
            }
            this._unavailableEx = new UnavailableException(String.valueOf(e), -1){
                {
                    super(x0, x1);
                    this.initCause(e);
                }
            };
            this._unavailable = -1L;
        }
    }

    public void setServletHandler(SipServletHandler servletHandler) {
        this._servletHandler = servletHandler;
    }

    @ManagedAttribute(value="Init order", readonly=true)
    public int getInitOrder() {
        return this._initOrder;
    }

    public void setInitOrder(int initOrder) {
        this._initOnStartup = true;
        this._initOrder = initOrder;
    }

    @Override
    public int compareTo(SipServletHolder sh) {
        int c;
        if (sh == this) {
            return 0;
        }
        if (sh._initOrder < this._initOrder) {
            return 1;
        }
        if (sh._initOrder > this._initOrder) {
            return -1;
        }
        int n = c = this._className != null && sh._className != null ? this._className.compareTo(sh._className) : 0;
        if (c == 0) {
            c = this._name.compareTo(sh._name);
        }
        if (c == 0) {
            c = this.hashCode() > sh.hashCode() ? 1 : -1;
        }
        return c;
    }

    public String toString() {
        return String.format("%s@%x==%s,%d,%b", this._name, this.hashCode(), this._className, this._initOrder, this._servlet != null);
    }

    public synchronized void setUserRoleLink(String name, String link) {
        if (this._roleMap == null) {
            this._roleMap = new HashMap<String, String>();
        }
        this._roleMap.put(name, link);
    }

    public String getUserRoleLink(String name) {
        if (this._roleMap == null) {
            return name;
        }
        String link = this._roleMap.get(name);
        return link == null ? name : link;
    }

    public Map<String, String> getRoleMap() {
        return this._roleMap == null ? ServletHolder.NO_MAPPED_ROLES : this._roleMap;
    }

    public String getContextPath() {
        return this._config.getServletContext().getContextPath();
    }

    public Map<String, String> getRoleRefMap() {
        return this._roleMap;
    }

    @ManagedAttribute(value="role to run servlet as", readonly=true)
    public String getRunAsRole() {
        return this._runAsRole;
    }

    public void setRunAsRole(String role) {
        this._runAsRole = role;
    }

    class Config
    implements ServletConfig {
        Config() {
        }

        public String getServletName() {
            return SipServletHolder.this.getName();
        }

        public ServletContext getServletContext() {
            return SipServletHolder.this._servletHandler.getServletContext();
        }

        public String getInitParameter(String name) {
            return SipServletHolder.this.getInitParameter(name);
        }

        public Enumeration<String> getInitParameterNames() {
            return SipServletHolder.this.getInitParameterNames();
        }
    }
}

