/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.servlet;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.cipango.server.SipMessage;
import org.cipango.server.SipRequest;
import org.cipango.server.handler.AbstractSipHandler;
import org.cipango.server.servlet.SipServletHolder;
import org.cipango.server.sipapp.SipAppContext;
import org.cipango.server.sipapp.SipServletMapping;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="SIP Servlet handler")
public class SipServletHandler
extends AbstractSipHandler {
    private final Logger LOG = Log.getLogger(SipServletHandler.class);
    private SipServletHolder[] _servlets = new SipServletHolder[0];
    private Map<String, SipServletHolder> _nameMap = new HashMap<String, SipServletHolder>();
    private ServletContext _servletContext;
    private SipServletHolder _mainServlet;
    private SipServletMapping[] _servletMappings;
    private SipServletHolder _defaultServlet;
    private SipAppContext _appContext;

    protected void doStart() throws Exception {
        this._appContext = SipAppContext.getCurrentContext();
        if (this._appContext != null) {
            this._servletContext = this._appContext.getServletContext();
        }
        super.doStart();
        if (this._appContext == null) {
            this.initialize();
        }
        if (this._servlets != null && this._servlets.length > 0) {
            this._defaultServlet = this._servlets[0];
        }
    }

    protected void start(LifeCycle l) throws Exception {
        if (!(l instanceof SipServletHolder)) {
            super.start(l);
        }
    }

    @ManagedAttribute(value="SIP servlets", readonly=true)
    public SipServletHolder[] getServlets() {
        return this._servlets;
    }

    public SipServletHolder addServlet(String className) {
        SipServletHolder holder = this.newSipServletHolder();
        holder.setClassName(className);
        holder.setName(className + "-" + this._servlets.length);
        this.addServlet(holder);
        return holder;
    }

    public void addServlet(SipServletHolder holder) {
        this.setServlets((SipServletHolder[])ArrayUtil.addToArray((Object[])this.getServlets(), (Object)holder, SipServletHolder.class));
    }

    public SipServletHolder newSipServletHolder() {
        return new SipServletHolder();
    }

    public synchronized void updateNameMappings() {
        this._nameMap.clear();
        if (this._servlets != null) {
            for (SipServletHolder servlet : this._servlets) {
                this._nameMap.put(servlet.getName(), servlet);
            }
        }
    }

    public void setServlets(SipServletHolder[] holders) {
        this.updateBeans(this._servlets, holders);
        this._servlets = holders;
        this.updateNameMappings();
    }

    public void initialize() throws Exception {
        MultiException mex = new MultiException();
        this.updateSipMappings();
        if (this._servlets != null) {
            Object[] servlets = (SipServletHolder[])this._servlets.clone();
            Arrays.sort(servlets);
            for (Object servlet : servlets) {
                try {
                    servlet.start();
                }
                catch (Exception e) {
                    this.LOG.debug("EXCEPTION ", (Throwable)e);
                    mex.add((Throwable)e);
                }
            }
        }
        if (this._mainServlet == null && this._servlets != null && (this._servletMappings == null || this._servletMappings.length == 0)) {
            if (this._servlets.length == 1) {
                this._mainServlet = this._servlets[0];
            } else if (this._servlets.length != 0) {
                mex.add((Throwable)new IllegalStateException("Multiple servlets and no SIP servlet mappping defined."));
            }
        }
        mex.ifExceptionThrow();
    }

    protected void updateSipMappings() throws ServletException {
        if (this._servlets == null) {
            this._nameMap = null;
        } else {
            HashMap<String, SipServletHolder> nm = new HashMap<String, SipServletHolder>();
            for (int i = 0; i < this._servlets.length; ++i) {
                if (nm.containsKey(this._servlets[i].getName())) {
                    throw new ServletException("A servlet with name " + this._servlets[i].getName() + " is already registered");
                }
                nm.put(this._servlets[i].getName(), this._servlets[i]);
                this._servlets[i].setServletHandler(this);
            }
            this._nameMap = nm;
        }
    }

    @Override
    public void handle(SipMessage message) throws IOException, ServletException {
        SipServletHolder holder = message.getHandler();
        if (message.isRequest()) {
            SipRequest request = (SipRequest)message;
            if (holder != null) {
                holder.handle(request);
            } else {
                this.notFound(request);
            }
        } else if (holder != null) {
            holder.handle(message);
        } else {
            this.LOG.warn("No holder for response:\n{}", new Object[]{message});
        }
    }

    public SipServletHolder getHolder(String name) {
        return this._nameMap == null ? null : this._nameMap.get(name);
    }

    public SipServletHolder getHolder(SipRequest request) {
        if (request.isInitial()) {
            if (this._mainServlet != null) {
                request.session().setHandler(this._mainServlet);
                return this._mainServlet;
            }
            if (this._servletMappings != null) {
                for (int i = 0; i < this._servletMappings.length; ++i) {
                    SipServletMapping mapping = this._servletMappings[i];
                    if (!mapping.getMatchingRule().matches(request)) continue;
                    SipServletHolder holder = this._nameMap.get(mapping.getServletName());
                    request.session().setHandler(holder);
                    return holder;
                }
            }
            return null;
        }
        return request.session().getHandler();
    }

    protected void notFound(SipRequest request) throws IOException {
        if (!request.isAck()) {
            request.createResponse(404).send();
        }
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public void addServletMapping(SipServletMapping mapping) {
        this.setServletMappings((SipServletMapping[])ArrayUtil.addToArray((Object[])this.getServletMappings(), (Object)mapping, SipServletMapping.class));
    }

    @ManagedAttribute(value="SIP servlet mappings", readonly=true)
    public SipServletMapping[] getServletMappings() {
        return this._servletMappings;
    }

    public void setServletMappings(SipServletMapping[] servletMappings) {
        this.updateBeans(this._servletMappings, servletMappings);
        this._servletMappings = servletMappings;
    }

    public void setMainServletName(String name) {
        this._mainServlet = this.getServlet(name);
    }

    @ManagedAttribute(value="Main servlet", readonly=true)
    public SipServletHolder getMainServlet() {
        return this._mainServlet;
    }

    public SipServletHolder getServlet(String name) {
        return this._nameMap.get(name);
    }

    public SipServletHolder getDefaultServlet() {
        if (this._mainServlet == null) {
            return this._defaultServlet;
        }
        return this._mainServlet;
    }

    public SipAppContext getAppContext() {
        return this._appContext;
    }

    protected void destroyServlet(Servlet servlet) {
        if (this._appContext != null && this._appContext.getWebAppContext() != null) {
            for (ServletContextHandler.Decorator decorator : this._appContext.getWebAppContext().getDecorators()) {
                decorator.destroyServletInstance(servlet);
            }
        }
    }
}

