/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.servlet;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.cipango.server.SipMessage;
import org.cipango.server.servlet.SipServletHolder;
import org.cipango.server.sipapp.SipAppContext;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SipDispatcher
implements RequestDispatcher {
    private static final Logger LOG = Log.getLogger(SipDispatcher.class);
    private SipServletHolder _holder;
    private SipAppContext _context;

    public SipDispatcher(SipAppContext context, SipServletHolder holder) {
        this._context = context;
        this._holder = holder;
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Forwarding to handler: " + this._holder.getName(), new Object[0]);
        }
        SipMessage message = request != null ? (SipMessage)request : (SipMessage)response;
        SipServletHolder previous = message.getHandler();
        message.setHandler(this._holder);
        this._context.handle(message);
        message.setHandler(previous);
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        throw new UnsupportedOperationException("RequestDispatcher.include(ServletRequest, ServletResponse) is not supported in SIP Servlet API");
    }
}

