/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.security;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.sip.SipServletResponse;
import org.cipango.server.SipHandler;
import org.cipango.server.SipMessage;
import org.cipango.server.SipRequest;
import org.cipango.server.handler.SipHandlerWrapper;
import org.cipango.server.security.DefaultAuthenticatorFactory;
import org.cipango.server.security.SipAuthenticator;
import org.cipango.server.servlet.SipServletHolder;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="SIP security handler")
public abstract class SipSecurityHandler<T>
extends SipHandlerWrapper
implements SipHandler,
SipAuthenticator.AuthConfiguration {
    private static final Logger LOG = Log.getLogger(SipSecurityHandler.class);
    private SipAuthenticator.Factory _authenticatorFactory = new DefaultAuthenticatorFactory();
    private String _realmName;
    private String _authMethod;
    private LoginService _loginService;
    private boolean _discoveredLoginService;
    private final Map<String, String> _initParameters = new HashMap<String, String>();
    private SipAuthenticator _authenticator;
    private IdentityService _identityService;
    private IdentityAssertionScheme _identityAssertionScheme;
    private boolean _identityAssertionRequired;

    protected void doStart() throws Exception {
        ContextHandler.Context context = ContextHandler.getCurrentContext();
        if (context != null) {
            Enumeration names = context.getInitParameterNames();
            while (names != null && names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!name.startsWith("org.eclipse.jetty.security.") || this.getInitParameter(name) != null) continue;
                this.setInitParameter(name, context.getInitParameter(name));
            }
        }
        if (this._loginService == null) {
            this._loginService = this.findLoginService();
            this._discoveredLoginService = true;
        }
        if (this._identityService == null) {
            if (this._loginService != null) {
                this._identityService = this._loginService.getIdentityService();
            }
            if (this._identityService == null) {
                this._identityService = this.findIdentityService();
            }
            if (this._identityService == null && this._realmName != null) {
                this._identityService = new DefaultIdentityService();
            }
        }
        if (this._loginService != null) {
            if (this._loginService.getIdentityService() == null) {
                this._loginService.setIdentityService(this._identityService);
            } else if (this._loginService.getIdentityService() != this._identityService) {
                throw new IllegalStateException("LoginService has different IdentityService to " + this);
            }
        }
        if (this._authenticator == null && this._authenticatorFactory != null && this._identityService != null) {
            this._authenticator = this._authenticatorFactory.getAuthenticator(this.getServer(), (ServletContext)ContextHandler.getCurrentContext(), this, this._identityService, this._loginService);
            if (this._authenticator != null) {
                this._authMethod = this._authenticator.getAuthMethod();
            }
        }
        if (this._authenticator == null) {
            if (this._realmName != null) {
                LOG.warn("No ServerAuthentication for " + this, new Object[0]);
                throw new IllegalStateException("No ServerAuthentication");
            }
        } else {
            this._authenticator.setAuthConfiguration(this);
            if (this._authenticator instanceof LifeCycle) {
                ((LifeCycle)this._authenticator).start();
            }
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this._discoveredLoginService) {
            this.removeBean(this._loginService);
            this._loginService = null;
        }
        super.doStop();
    }

    @Override
    @ManagedAttribute(name="Login service", readonly=true)
    public LoginService getLoginService() {
        return this._loginService;
    }

    public void setLoginService(LoginService loginService) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this.updateBean(this._loginService, loginService);
        this._loginService = loginService;
    }

    @Override
    @ManagedAttribute(name="Realm name", readonly=true)
    public String getRealmName() {
        return this._realmName;
    }

    public void setRealmName(String realmName) {
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        this._realmName = realmName;
    }

    @Override
    @ManagedAttribute(name="Authentication method", readonly=true)
    public String getAuthMethod() {
        return this._authMethod;
    }

    public void setAuthMethod(String authMethod) {
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        this._authMethod = authMethod;
    }

    protected LoginService findLoginService() {
        Collection list = this.getServer().getBeans(LoginService.class);
        for (LoginService service : list) {
            if (service.getName() == null || !service.getName().equals(this.getRealmName())) continue;
            return service;
        }
        if (list.size() == 1) {
            return (LoginService)list.iterator().next();
        }
        return null;
    }

    protected IdentityService findIdentityService() {
        return (IdentityService)this.getServer().getBean(IdentityService.class);
    }

    protected abstract T prepareConstraintInfo(SipServletHolder var1, SipRequest var2);

    protected abstract boolean checkUserDataPermissions(SipServletHolder var1, SipRequest var2, T var3) throws IOException;

    protected abstract boolean isAuthMandatory(SipRequest var1, T var2);

    protected abstract boolean isProxyMode(SipRequest var1, T var2);

    protected abstract boolean checkSipResourcePermissions(SipServletHolder var1, SipRequest var2, T var3, UserIdentity var4) throws IOException;

    @Override
    public void handle(SipMessage message) throws IOException, ServletException {
        if (message instanceof SipRequest && this._authenticator != null && !((SipRequest)message).isAck() && !((SipRequest)message).isCancel()) {
            SipRequest request = (SipRequest)message;
            SipServletHolder holder = request.getHandler();
            if (holder == null) {
                LOG.debug("No holder for session " + request.session(), new Object[0]);
            } else {
                T constraintInfo = this.prepareConstraintInfo(holder, request);
                LOG.debug("Got constraint: {} for holder {}", new Object[]{constraintInfo, holder.getName()});
                if (!this.checkUserDataPermissions(holder, request, constraintInfo)) {
                    if (!request.isHandled()) {
                        SipServletResponse response = request.createResponse(403);
                        response.send();
                    }
                    return;
                }
                boolean isAuthMandatory = this.isAuthMandatory(request, constraintInfo);
                if (isAuthMandatory) {
                    UserIdentity user = this._authenticator.authenticate(request, this.isProxyMode(request, constraintInfo), isAuthMandatory);
                    request.setUserIdentity(user);
                    if (user == null) {
                        return;
                    }
                    boolean authorized = this.checkSipResourcePermissions(holder, request, constraintInfo, user);
                    if (!authorized) {
                        SipServletResponse response = request.createResponse(403, "!role");
                        response.send();
                        return;
                    }
                }
            }
        }
        this.getHandler().handle(message);
    }

    @Override
    public String getInitParameter(String key) {
        return this._initParameters.get(key);
    }

    @Override
    public Set<String> getInitParameterNames() {
        return this._initParameters.keySet();
    }

    public String setInitParameter(String key, String value) {
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        return this._initParameters.put(key, value);
    }

    @Override
    public IdentityService getIdentityService() {
        return this._identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this._identityService = identityService;
    }

    @ManagedAttribute(value="SIP Authenticator", readonly=true)
    public SipAuthenticator getAuthenticator() {
        return this._authenticator;
    }

    public void setAuthenticator(SipAuthenticator authenticator) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this._authenticator = authenticator;
    }

    public SipAuthenticator.Factory getAuthenticatorFactory() {
        return this._authenticatorFactory;
    }

    public void setAuthenticatorFactory(SipAuthenticator.Factory authenticatorFactory) {
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        this._authenticatorFactory = authenticatorFactory;
    }

    public IdentityAssertionScheme getIdentityAssertionScheme() {
        return this._identityAssertionScheme;
    }

    public void setIdentityAssertionScheme(IdentityAssertionScheme identityAssertionScheme) {
        this._identityAssertionScheme = identityAssertionScheme;
    }

    public boolean isIdentityAssertionRequired() {
        return this._identityAssertionRequired;
    }

    public void setIdentityAssertionRequired(boolean identityAssertionRequired) {
        this._identityAssertionRequired = identityAssertionRequired;
    }

    public static enum IdentityAssertionScheme {
        P_ASSERTED_IDENTITY("P-Asserted-Identity"),
        IDENTITY("Identity");

        private String _name;

        private IdentityAssertionScheme(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public static IdentityAssertionScheme getByName(String name) {
            for (IdentityAssertionScheme scheme : IdentityAssertionScheme.values()) {
                if (!scheme.getName().equalsIgnoreCase(name)) continue;
                return scheme;
            }
            return null;
        }
    }
}

