/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.processor;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.cipango.server.SipConnection;
import org.cipango.server.SipConnector;
import org.cipango.server.SipMessage;
import org.cipango.server.SipProcessor;
import org.cipango.server.SipRequest;
import org.cipango.server.SipResponse;
import org.cipango.server.Transport;
import org.cipango.server.dns.BlackList;
import org.cipango.server.dns.DnsResolver;
import org.cipango.server.dns.EmptyBlackList;
import org.cipango.server.dns.Hop;
import org.cipango.server.dns.Rfc3263DnsResolver;
import org.cipango.server.processor.SipProcessorWrapper;
import org.cipango.sip.SipHeader;
import org.cipango.sip.Via;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject
public class TransportProcessor
extends SipProcessorWrapper {
    private Logger LOG = Log.getLogger(TransportProcessor.class);
    private DnsResolver _dnsResolver;
    private BlackList _blackList;

    public TransportProcessor(SipProcessor processor) {
        super(processor);
    }

    @Override
    protected void doStart() throws Exception {
        if (this._dnsResolver == null) {
            this.setDnsResolver(new Rfc3263DnsResolver());
        }
        if (this._blackList == null) {
            this.setBlackList(new EmptyBlackList());
        }
        ArrayList<Transport> transports = new ArrayList<Transport>();
        if (this.getServer().getConnectors() != null) {
            for (SipConnector connector : this.getServer().getConnectors()) {
                if (transports.contains((Object)connector.getTransport())) continue;
                transports.add(connector.getTransport());
            }
        }
        this._dnsResolver.setEnableTransports(transports);
        super.doStart();
    }

    public Address popLocalRoute(SipRequest request) throws ServletParseException {
        Address route = request.getTopRoute();
        if (route != null && this.getServer().isLocalURI(route.getURI())) {
            request.removeTopRoute();
            String ddr = route.getURI().getParameter("drr");
            if (ddr != null) {
                Address route2 = request.getTopRoute();
                String appId = route.getURI().getParameter("appid");
                if (route2 != null && appId != null && appId.equals(route2.getURI().getParameter("appid")) && this.getServer().isLocalURI(route2.getURI())) {
                    this.LOG.debug("Remove second top route {} due to RFC 5658", new Object[]{route2});
                    request.removeTopRoute();
                    if ("2".equals(ddr)) {
                        route = route2;
                    }
                }
            }
        }
        return route;
    }

    @Override
    public void doProcess(SipMessage message) throws Exception {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("handling message {}", new Object[]{message.toStringCompact()});
        }
        if (message.isRequest()) {
            Address route;
            SipRequest request = (SipRequest)message;
            Via via = message.getTopVia();
            String remoteAddress = message.getRemoteAddr();
            if (!via.getHost().equals(remoteAddress)) {
                via.setReceived(remoteAddress);
            }
            if (via.hasRPort()) {
                via.setRPort(message.getRemotePort());
            }
            if ((route = this.popLocalRoute(request)) != null) {
                request.setPoppedRoute(route);
            }
        }
        super.doProcess(message);
    }

    public boolean preValidateMessage(SipMessage message) {
        SipRequest request;
        boolean valid = true;
        try {
            if (!(this.isUnique(SipHeader.FROM, message) && this.isUnique(SipHeader.TO, message) && this.isUnique(SipHeader.CALL_ID, message) && this.isUnique(SipHeader.CSEQ, message))) {
                valid = false;
            } else if (message.getTopVia() == null || message.getCSeq() == null) {
                this.LOG.info("Received bad message: unparsable required headers", new Object[0]);
                valid = false;
            }
            message.getAddressHeader("contact");
            if (message instanceof SipRequest) {
                request = (SipRequest)message;
                if (request.getRequestURI() == null) {
                    valid = false;
                }
                request.getTopRoute();
                if (!request.getCSeq().getMethod().equals(request.getMethod())) {
                    this.LOG.info("Received bad request: CSeq method does not match", new Object[0]);
                    valid = false;
                }
            } else {
                int status = ((SipResponse)message).getStatus();
                if (status < 100 || status > 699) {
                    this.LOG.info("Received bad response: Invalid status code: " + status, new Object[0]);
                    valid = false;
                }
            }
        }
        catch (Exception e) {
            this.LOG.info("Received bad message: Some headers are not parsable: {}", (Throwable)e);
            this.LOG.debug("Received bad message: Some headers are not parsable", (Throwable)e);
            valid = false;
        }
        try {
            if (!valid && message instanceof SipRequest && !((SipRequest)message).isAck() && message.getTopVia() != null) {
                request = (SipRequest)message;
                SipResponse response = (SipResponse)request.createResponse(400);
                this.getServer().sendResponse(response, request.getConnection());
            }
        }
        catch (Exception e) {
            this.LOG.ignore((Throwable)e);
        }
        return valid;
    }

    private boolean isUnique(SipHeader header, SipMessage message) {
        String name = header.asString();
        ListIterator it = message.getFields().getValues(name);
        if (!it.hasNext()) {
            this.LOG.info("Received bad message: Missing required header: " + name, new Object[0]);
            return false;
        }
        it.next();
        if (it.hasNext()) {
            this.LOG.info("Received bad message: Duplicate header: " + name, new Object[0]);
        }
        return !it.hasNext();
    }

    public SipConnection getConnection(SipRequest request, Transport transport) throws IOException {
        ListIterator<Hop> it = request.getHops();
        List<Hop> hops = null;
        if (it == null) {
            Address route;
            URI uri = null;
            try {
                route = request.getTopRoute();
            }
            catch (ServletParseException e) {
                throw new IOException("Invalid top route", e);
            }
            uri = route != null && !request.isNextHopStrictRouting() ? route.getURI() : request.getRequestURI();
            if (!uri.isSipURI()) {
                throw new IOException("Cannot route on URI: " + uri);
            }
            SipURI target = (SipURI)uri;
            Hop hop = new Hop();
            if (target.getMAddrParam() != null) {
                hop.setHost(target.getMAddrParam());
            } else {
                hop.setHost(target.getHost());
            }
            if (transport == null && target.getTransportParam() != null) {
                try {
                    transport = Transport.valueOf(target.getTransportParam().toUpperCase());
                }
                catch (Exception e) {
                    this.LOG.debug("Unknown transport: " + target.getTransportParam(), (Throwable)e);
                }
            }
            hop.setTransport(transport);
            hop.setPort(target.getPort());
            hops = this._dnsResolver.getHops(hop);
            this.LOG.debug("Physical hops are {} for hop {}", new Object[]{hops, hop});
            it = hops.listIterator();
            request.setHops(it);
        }
        while (it.hasNext()) {
            Hop bestHop = it.next();
            if (this._blackList.isBlacklisted(bestHop)) {
                this.LOG.debug("Do no send request to hop {} as it is blacklisted", new Object[]{bestHop});
                continue;
            }
            return this.getConnection(request, bestHop.getTransport(), bestHop.getAddress(), bestHop.getPort());
        }
        if (hops != null) {
            Hop firstHop = (Hop)hops.get(0);
            return this.getConnection(request, firstHop.getTransport(), firstHop.getAddress(), firstHop.getPort());
        }
        throw new IOException("All remaining hops are backlisted");
    }

    public SipConnection getConnection(SipRequest request, Transport transport, InetAddress address, int port) throws IOException {
        SipConnector connector = this.findConnector(transport, address);
        Via via = request.getTopVia();
        via.setTransport(connector.getTransport().getName());
        via.setHost(connector.getURI().getHost());
        via.setPort(connector.getURI().getPort());
        SipConnection connection = connector.getConnection(address, port);
        if (connection == null) {
            throw new IOException("Could not find connection to " + address + ":" + port + "/" + (Object)((Object)connector.getTransport()));
        }
        return connection;
    }

    public SipConnector findConnector(Transport transport, InetAddress addr) {
        boolean ipv4 = addr instanceof Inet4Address;
        SipConnector[] connectors = this.getServer().getConnectors();
        for (int i = 0; i < connectors.length; ++i) {
            SipConnector c = connectors[i];
            if (c.getTransport() != transport || addr != null && c.getAddress() instanceof Inet4Address != ipv4) continue;
            return c;
        }
        return connectors[0];
    }

    @ManagedAttribute(value="DNS resolver", readonly=true)
    public DnsResolver getDnsResolver() {
        return this._dnsResolver;
    }

    public void setDnsResolver(DnsResolver dnsResolver) {
        this.updateBean(this._dnsResolver, dnsResolver);
        this._dnsResolver = dnsResolver;
    }

    @ManagedAttribute(value="Black list", readonly=true)
    public BlackList getBlackList() {
        return this._blackList;
    }

    public void setBlackList(BlackList blackList) {
        this.updateBean(this._blackList, blackList);
        this._blackList = blackList;
    }
}

