/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.Executor;
import org.cipango.server.AbstractSipConnector;
import org.cipango.server.MessageTooLongException;
import org.cipango.server.SipConnection;
import org.cipango.server.SipConnector;
import org.cipango.server.SipMessage;
import org.cipango.server.SipMessageGenerator;
import org.cipango.server.SipServer;
import org.cipango.server.Transport;
import org.cipango.server.util.FixedBufferPool;
import org.cipango.sip.SipParser;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class UdpConnector
extends AbstractSipConnector {
    private static final Logger LOG = Log.getLogger(UdpConnector.class);
    public static final int MAX_UDP_SIZE = 65536;
    public static final int DEFAULT_MTU = 1500;
    private DatagramChannel _channel;
    private InetAddress _localAddr;
    private ByteBuffer[] _inBuffers;
    private ByteBufferPool _outBuffers;
    private int _mtu = 65536;
    private final SipMessageGenerator _sipGenerator = new SipMessageGenerator();

    public UdpConnector(@Name(value="sipServer") SipServer server) {
        this(server, null, Math.max(1, Runtime.getRuntime().availableProcessors() / 2));
    }

    public UdpConnector(@Name(value="sipServer") SipServer server, @Name(value="acceptors") int acceptors) {
        this(server, null, acceptors);
    }

    public UdpConnector(@Name(value="sipServer") SipServer server, @Name(value="executor") Executor executor, @Name(value="acceptors") int acceptors) {
        super(server, executor, acceptors);
    }

    public int getMtu() {
        return this._mtu;
    }

    public void setMtu(int mtu) {
        this._mtu = mtu;
    }

    @Override
    public Transport getTransport() {
        return Transport.UDP;
    }

    @Override
    protected void doStart() throws Exception {
        this._inBuffers = new ByteBuffer[this.getAcceptors()];
        int i = this._inBuffers.length;
        while (i-- > 0) {
            this._inBuffers[i] = BufferUtil.allocateDirect((int)65536);
        }
        this._outBuffers = new FixedBufferPool(this._mtu);
        super.doStart();
    }

    @Override
    public synchronized void open() throws IOException {
        this._channel = DatagramChannel.open();
        this._channel.configureBlocking(true);
        this._channel.socket().bind(new InetSocketAddress(InetAddress.getByName(this.getHost()), this.getPort()));
        this._localAddr = this._channel.socket().getLocalAddress();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this._channel != null) {
            this._channel.close();
        }
        this._channel = null;
    }

    @Override
    public InetAddress getAddress() {
        return this._localAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void accept(int id) throws IOException {
        DatagramChannel channel;
        UdpConnector udpConnector = this;
        synchronized (udpConnector) {
            channel = this._channel;
        }
        if (channel != null && channel.isOpen()) {
            ByteBuffer buffer = this._inBuffers[id];
            BufferUtil.clearToFill((ByteBuffer)buffer);
            InetSocketAddress address = (InetSocketAddress)channel.receive(buffer);
            BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
            new UdpConnection(address).process(buffer);
        }
    }

    @Override
    public SipConnection getConnection(InetAddress address, int port) {
        return new UdpConnection(new InetSocketAddress(address, port));
    }

    public static void main(String[] args) throws Exception {
        SipServer sipServer = new SipServer();
        UdpConnector connector = new UdpConnector(sipServer);
        connector.setHost("192.168.2.127");
        connector.setPort(5060);
        connector.start();
    }

    public class UdpConnection
    implements SipConnection {
        private InetSocketAddress _address;

        public UdpConnection(InetSocketAddress address) {
            this._address = address;
        }

        @Override
        public SipConnector getConnector() {
            return UdpConnector.this;
        }

        @Override
        public Transport getTransport() {
            return Transport.UDP;
        }

        @Override
        public InetAddress getRemoteAddress() {
            return this._address.getAddress();
        }

        @Override
        public int getRemotePort() {
            return this._address.getPort();
        }

        @Override
        public InetAddress getLocalAddress() {
            return UdpConnector.this._localAddr;
        }

        @Override
        public int getLocalPort() {
            return UdpConnector.this.getPort();
        }

        @Override
        public void send(SipMessage message) throws MessageTooLongException {
            this.send(message, false);
        }

        public void send(SipMessage message, boolean ignoreMtu) throws MessageTooLongException {
            ByteBuffer buffer = ignoreMtu ? BufferUtil.allocate((int)65536) : UdpConnector.this._outBuffers.acquire(UdpConnector.this._mtu, false);
            buffer.clear();
            UdpConnector.this._sipGenerator.generateMessage(buffer, message);
            if (!ignoreMtu && message.isRequest() && buffer.position() + 200 > UdpConnector.this._mtu) {
                throw new MessageTooLongException();
            }
            buffer.flip();
            try {
                UdpConnector.this._channel.send(buffer, this._address);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
            if (!ignoreMtu) {
                UdpConnector.this._outBuffers.release(buffer);
            }
        }

        @Override
        public void write(ByteBuffer buffer) throws IOException {
            UdpConnector.this._channel.send(buffer, this._address);
        }

        public void process(ByteBuffer buffer) throws IOException {
            AbstractSipConnector.MessageBuilder builder = new AbstractSipConnector.MessageBuilder(UdpConnector.this.getServer(), this);
            SipParser parser = new SipParser((SipParser.SipMessageHandler)builder);
            boolean done = parser.parseNext(buffer);
            if (!done) {
                builder.badMessage(400, "Parser in state " + parser.getState() + " after processing UDP packet");
            }
        }

        @Override
        public boolean isOpen() {
            return UdpConnector.this._channel.isOpen();
        }
    }
}

