/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.nio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;
import org.cipango.server.MessageTooLongException;
import org.cipango.server.SipConnection;
import org.cipango.server.SipConnector;
import org.cipango.server.SipMessage;
import org.cipango.server.SipMessageGenerator;
import org.cipango.server.Transport;
import org.cipango.server.nio.SelectSipConnection;
import org.cipango.server.nio.TlsChannelConnector;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class TlsChannelConnection
extends SslConnection
implements SipConnection {
    private static final Logger LOG = Log.getLogger(SelectSipConnection.class);
    private final TlsChannelConnector _connector;
    private final EndPoint _endpoint;
    private final SipMessageGenerator _sipGenerator;
    private final ByteBufferPool _bufferPool;

    public TlsChannelConnection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endpoint, SSLEngine sslEngine, TlsChannelConnector connector) {
        super(byteBufferPool, executor, endpoint, sslEngine);
        this._connector = connector;
        this._endpoint = endpoint;
        this._bufferPool = byteBufferPool;
        this._sipGenerator = new SipMessageGenerator();
    }

    @Override
    public SipConnector getConnector() {
        return this._connector;
    }

    @Override
    public Transport getTransport() {
        return Transport.TLS;
    }

    @Override
    public InetAddress getLocalAddress() {
        return this._endpoint.getLocalAddress().getAddress();
    }

    @Override
    public int getLocalPort() {
        return this._endpoint.getLocalAddress().getPort();
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this._endpoint.getRemoteAddress().getAddress();
    }

    @Override
    public int getRemotePort() {
        return this._endpoint.getRemoteAddress().getPort();
    }

    @Override
    public void send(SipMessage message) throws MessageTooLongException {
        ByteBuffer buffer = null;
        int bufferSize = 2048;
        while (true) {
            buffer = this._bufferPool.acquire(bufferSize, false);
            buffer.clear();
            try {
                this._sipGenerator.generateMessage(buffer, message);
            }
            catch (MessageTooLongException e) {
                if (bufferSize < 0x1000000) {
                    bufferSize += 2048 + message.getContentLength();
                    continue;
                }
                throw e;
            }
            break;
        }
        buffer.flip();
        try {
            this.write(buffer);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        this._bufferPool.release(buffer);
    }

    @Override
    public void write(ByteBuffer buffer) throws IOException {
        try {
            FutureCallback fcb = new FutureCallback();
            if (BufferUtil.hasContent((ByteBuffer)buffer)) {
                this.getDecryptedEndPoint().write((Callback)fcb, new ByteBuffer[]{buffer});
            }
            fcb.get();
        }
        catch (InterruptedException x) {
            throw (IOException)new InterruptedIOException().initCause(x);
        }
        catch (ExecutionException x) {
            Throwable cause = x.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof Exception) {
                throw new IOException(cause);
            }
            throw (Error)cause;
        }
    }

    @Override
    public boolean isOpen() {
        return this.getEndPoint().isOpen() && !this.getSSLEngine().isInboundDone();
    }

    public void onClose() {
        this._connector.removeConnection(this);
        super.onClose();
    }
}

