/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.cipango.server.AbstractSipConnector;
import org.cipango.server.MessageTooLongException;
import org.cipango.server.SipConnection;
import org.cipango.server.SipConnector;
import org.cipango.server.SipMessage;
import org.cipango.server.SipMessageGenerator;
import org.cipango.server.SipRequest;
import org.cipango.server.SipResponse;
import org.cipango.server.SipServer;
import org.cipango.server.Transport;
import org.cipango.server.servlet.DefaultServlet;
import org.cipango.server.sipapp.SipAppContext;
import org.cipango.server.transaction.TransactionImpl;
import org.cipango.sip.SipHeader;
import org.cipango.sip.SipParser;
import org.eclipse.jetty.io.ArrayByteBufferPool;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@Deprecated
public class TcpConnector
extends AbstractSipConnector {
    private static final Logger LOG = Log.getLogger(TcpConnector.class);
    public static final int MINIMAL_BUFFER_LENGTH = 2048;
    public static final int DEFAULT_SO_TIMEOUT = 2 * TransactionImpl.__T1 * 64;
    private ServerSocketChannel _channel;
    private ByteBufferPool _outBuffers;
    private Map<String, TcpConnection> _connections;
    private int _connectionTimeout = DEFAULT_SO_TIMEOUT;

    public TcpConnector(@Name(value="sipServer") SipServer server) {
        this(server, null, Math.max(1, Runtime.getRuntime().availableProcessors() / 2));
    }

    public TcpConnector(@Name(value="sipServer") SipServer server, @Name(value="acceptors") int acceptors) {
        this(server, null, acceptors);
    }

    public TcpConnector(@Name(value="sipServer") SipServer server, @Name(value="executor") Executor executor, @Name(value="acceptors") int acceptors) {
        super(server, executor, acceptors);
    }

    @Override
    protected void doStart() throws Exception {
        this._connections = new HashMap<String, TcpConnection>();
        this._outBuffers = new ArrayByteBufferPool(2048, 4096, 65536);
        super.doStart();
    }

    @Override
    public Transport getTransport() {
        return Transport.TCP;
    }

    @Override
    public void open() throws IOException {
        this._channel = ServerSocketChannel.open();
        this._channel.configureBlocking(true);
        this._channel.socket().bind(new InetSocketAddress(InetAddress.getByName(this.getHost()), this.getPort()));
    }

    @Override
    public void close() throws IOException {
        this._channel.close();
    }

    @Override
    protected void accept(int id) throws IOException {
        TcpConnection connection = new TcpConnection(this._channel.accept(), id);
        this.addConnection(connection);
        connection.dispatch();
    }

    protected ServerSocketChannel getChannel() {
        return this._channel;
    }

    public int getConnectionTimeout() {
        return this._connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this._connectionTimeout = connectionTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SipConnection getConnection(InetAddress address, int port) throws IOException {
        Map<String, TcpConnection> map = this._connections;
        synchronized (map) {
            TcpConnection cnx = this._connections.get(address + ":" + port);
            if (cnx == null) {
                cnx = null;
                this.addConnection(cnx);
                cnx.dispatch();
            }
            return cnx;
        }
    }

    @Override
    public InetAddress getAddress() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addConnection(TcpConnection connection) {
        LOG.debug("Opened connection {}", new Object[]{connection});
        Map<String, TcpConnection> map = this._connections;
        synchronized (map) {
            this._connections.put(connection.toString(), connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConnection(TcpConnection connection) {
        LOG.debug("Closing connection {}", new Object[]{connection});
        Map<String, TcpConnection> map = this._connections;
        synchronized (map) {
            this._connections.remove(connection.toString());
        }
    }

    public static void main(String[] args) throws Exception {
        String host = null;
        try {
            host = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            LOG.ignore((Throwable)e);
            host = "127.0.0.1";
        }
        SipServer sipServer = new SipServer();
        TcpConnector connector = new TcpConnector(sipServer);
        connector.setHost(host);
        connector.setPort(5060);
        sipServer.addConnector(connector);
        SipAppContext context = new SipAppContext();
        context.getServletHandler().addServlet(DefaultServlet.class.getName());
        sipServer.setHandler(context);
        sipServer.start();
    }

    public static class MessageBuilder
    extends AbstractSipConnector.MessageBuilder {
        public MessageBuilder(SipServer server, SipConnection connection) {
            super(server, connection);
        }

        @Override
        public boolean headerComplete() {
            if (!this._message.getFields().containsKey(SipHeader.CONTENT_LENGTH.toString())) {
                if (this._message.isRequest()) {
                    SipRequest request = (SipRequest)this._message;
                    SipResponse response = (SipResponse)request.createResponse(400, "Content-Length is mandatory");
                    try {
                        this._connection.send(response);
                    }
                    catch (MessageTooLongException e) {
                        LOG.warn((Throwable)e);
                    }
                }
                this.reset();
                return true;
            }
            return false;
        }

        @Override
        public void badMessage(int status, String reason) {
        }
    }

    class TcpConnection
    implements SipConnection,
    Runnable {
        private ByteBuffer _buffer = BufferUtil.allocateDirect((int)2048);
        private SocketChannel _channel;
        private InetSocketAddress _localAddr;
        private InetSocketAddress _remoteAddr;
        private final SipMessageGenerator _sipGenerator;

        public TcpConnection(SocketChannel channel, int id) throws IOException {
            this._channel = channel;
            this._localAddr = (InetSocketAddress)this._channel.getLocalAddress();
            this._remoteAddr = (InetSocketAddress)this._channel.getRemoteAddress();
            this._channel.socket().setTcpNoDelay(true);
            this._channel.socket().setSoTimeout(TcpConnector.this._connectionTimeout);
            this._sipGenerator = new SipMessageGenerator();
        }

        public void dispatch() throws IOException {
            try {
                TcpConnector.this.getExecutor().execute(this);
            }
            catch (RejectedExecutionException e) {
                LOG.warn("dispatch failed for {}", new Object[]{this});
                TcpConnector.this.close();
            }
        }

        @Override
        public SipConnector getConnector() {
            return TcpConnector.this;
        }

        @Override
        public Transport getTransport() {
            return Transport.TCP;
        }

        @Override
        public InetAddress getLocalAddress() {
            return this._localAddr.getAddress();
        }

        @Override
        public int getLocalPort() {
            return this._localAddr.getPort();
        }

        @Override
        public InetAddress getRemoteAddress() {
            return this._remoteAddr.getAddress();
        }

        @Override
        public int getRemotePort() {
            return this._remoteAddr.getPort();
        }

        @Override
        public void send(SipMessage message) throws MessageTooLongException {
            ByteBuffer buffer = TcpConnector.this._outBuffers.acquire(2048, false);
            buffer.clear();
            this._sipGenerator.generateMessage(buffer, message);
            buffer.flip();
            try {
                this._channel.write(buffer);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
            TcpConnector.this._outBuffers.release(buffer);
        }

        @Override
        public void write(ByteBuffer buffer) throws IOException {
            this._channel.write(buffer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MessageBuilder builder = new MessageBuilder(TcpConnector.this.getServer(), this);
            SipParser parser = new SipParser((SipParser.SipMessageHandler)builder);
            int read = 0;
            try {
                while (read >= 0) {
                    this._buffer.clear();
                    read = this._channel.read(this._buffer);
                    if (read <= 0) {
                        break;
                    }
                    this._buffer.flip();
                    while (this._buffer.hasRemaining()) {
                        if (!parser.parseNext(this._buffer)) continue;
                        parser.reset();
                    }
                }
            }
            catch (IOException e) {
                LOG.ignore((Throwable)e);
            }
            finally {
                TcpConnector.this.removeConnection(this);
                try {
                    this._channel.close();
                }
                catch (IOException e) {
                    LOG.ignore((Throwable)e);
                }
            }
        }

        @Override
        public boolean isOpen() {
            return this._channel.isOpen();
        }

        public String toString() {
            return this.getRemoteAddress() + ":" + this.getRemotePort();
        }
    }
}

