/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.nio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import org.cipango.server.AbstractSipConnector;
import org.cipango.server.MessageTooLongException;
import org.cipango.server.SipConnection;
import org.cipango.server.SipConnector;
import org.cipango.server.SipMessage;
import org.cipango.server.SipMessageGenerator;
import org.cipango.server.SipRequest;
import org.cipango.server.SipResponse;
import org.cipango.server.SipServer;
import org.cipango.server.Transport;
import org.cipango.server.nio.SelectChannelConnector;
import org.cipango.sip.SipHeader;
import org.cipango.sip.SipParser;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SelectSipConnection
extends AbstractConnection
implements SipConnection {
    private static final Logger LOG = Log.getLogger(SelectSipConnection.class);
    public static final int MINIMAL_BUFFER_LENGTH = 2048;
    public static final int MAXIMAL_BUFFER_LENGTH = 0x1000000;
    private final ByteBufferPool _bufferPool;
    private final SelectChannelConnector _connector;
    private final EndPoint _endpoint;
    private SipParser _parser;
    private ByteBuffer _buffer;
    private final SipMessageGenerator _sipGenerator;

    public SelectSipConnection(SelectChannelConnector connector, EndPoint endpoint) {
        super(endpoint, connector.getExecutor());
        this._connector = connector;
        this._endpoint = endpoint;
        this._bufferPool = this._connector.getByteBufferPool();
        MessageBuilder builder = new MessageBuilder(this.getServer(), this);
        this._parser = new SipParser((SipParser.SipMessageHandler)builder);
        this._sipGenerator = new SipMessageGenerator();
    }

    public SipServer getServer() {
        return this._connector.getServer();
    }

    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    public void onClose() {
        super.onClose();
        this._connector.removeConnection(this);
    }

    public void onFillable() {
        LOG.debug("{} onReadable", new Object[]{this});
        try {
            while (true) {
                if (BufferUtil.isEmpty((ByteBuffer)this._buffer)) {
                    if (this._buffer == null) {
                        this._buffer = this._bufferPool.acquire(2048, true);
                    }
                    int filled = this.getEndPoint().fill(this._buffer);
                    LOG.debug("{} filled {}", new Object[]{this, filled});
                    if (filled == 0) {
                        this.releaseBuffer();
                        this.fillInterested();
                        return;
                    }
                    if (filled < 0) {
                        this._parser.reset();
                        this.getEndPoint().shutdownOutput();
                        this.releaseBuffer();
                        return;
                    }
                }
                if (!this._parser.parseNext(this._buffer)) continue;
                this._parser.reset();
            }
        }
        catch (IOException e) {
            LOG.warn(this.toString(), (Throwable)e);
            this.getEndPoint().close();
        }
        catch (Exception e) {
            LOG.warn(this.toString(), (Throwable)e);
            this.getEndPoint();
        }
    }

    @Override
    public SipConnector getConnector() {
        return this._connector;
    }

    @Override
    public Transport getTransport() {
        return Transport.TCP;
    }

    @Override
    public InetAddress getLocalAddress() {
        return this._endpoint.getLocalAddress().getAddress();
    }

    @Override
    public int getLocalPort() {
        return this._endpoint.getLocalAddress().getPort();
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this._endpoint.getRemoteAddress().getAddress();
    }

    @Override
    public int getRemotePort() {
        return this._endpoint.getRemoteAddress().getPort();
    }

    @Override
    public void send(SipMessage message) throws MessageTooLongException {
        ByteBuffer buffer = null;
        int bufferSize = 2048;
        while (true) {
            buffer = this._bufferPool.acquire(bufferSize, false);
            buffer.clear();
            try {
                this._sipGenerator.generateMessage(buffer, message);
            }
            catch (MessageTooLongException e) {
                if (bufferSize < 0x1000000) {
                    bufferSize += 2048 + message.getContentLength();
                    continue;
                }
                throw e;
            }
            break;
        }
        buffer.flip();
        try {
            this.write(buffer);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        this._bufferPool.release(buffer);
    }

    @Override
    public synchronized void write(ByteBuffer buffer) throws IOException {
        try {
            FutureCallback fcb = new FutureCallback();
            if (BufferUtil.hasContent((ByteBuffer)buffer)) {
                this.getEndPoint().write((Callback)fcb, new ByteBuffer[]{buffer});
            }
            fcb.get();
        }
        catch (InterruptedException x) {
            throw (IOException)new InterruptedIOException().initCause(x);
        }
        catch (ExecutionException x) {
            Throwable cause = x.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof Exception) {
                throw new IOException(cause);
            }
            throw (Error)cause;
        }
    }

    @Override
    public boolean isOpen() {
        return this.getEndPoint().isOpen();
    }

    public String toString() {
        return this.getRemoteAddress() + ":" + this.getRemotePort();
    }

    private void releaseBuffer() {
        if (this._buffer != null && !this._buffer.hasRemaining()) {
            this._bufferPool.release(this._buffer);
            this._buffer = null;
        }
    }

    public static class MessageBuilder
    extends AbstractSipConnector.MessageBuilder {
        public MessageBuilder(SipServer server, SipConnection connection) {
            super(server, connection);
        }

        @Override
        public boolean headerComplete() {
            if (!this._message.getFields().containsKey(SipHeader.CONTENT_LENGTH.toString())) {
                if (this._message.isRequest()) {
                    SipRequest request = (SipRequest)this._message;
                    SipResponse response = (SipResponse)request.createResponse(400, "Content-Length is mandatory");
                    try {
                        this._connection.send(response);
                    }
                    catch (MessageTooLongException e) {
                        LOG.warn((Throwable)e);
                    }
                }
                this.reset();
                return true;
            }
            return false;
        }

        @Override
        public void badMessage(int status, String reason) {
            ((AbstractConnection)this._connection).close();
        }
    }
}

