/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.cipango.server.AbstractSipConnector;
import org.cipango.server.SipConnection;
import org.cipango.server.SipServer;
import org.cipango.server.Transport;
import org.cipango.server.nio.SelectSipConnection;
import org.cipango.server.servlet.DefaultServlet;
import org.cipango.server.sipapp.SipAppContext;
import org.cipango.server.transaction.TransactionImpl;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ArrayByteBufferPool;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.SelectChannelEndPoint;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.TimerScheduler;

public class SelectChannelConnector
extends AbstractSipConnector {
    private static final Logger LOG = Log.getLogger(SelectChannelConnector.class);
    public static final int DEFAULT_SO_TIMEOUT = 2 * TransactionImpl.__T1 * 64;
    private final Scheduler _scheduler;
    private final ByteBufferPool _byteBufferPool;
    private final SelectorManager _manager;
    private ServerSocketChannel _acceptChannel;
    private int _localPort = -1;
    private volatile int _acceptQueueSize = 128;
    private volatile long _idleTimeout = DEFAULT_SO_TIMEOUT;
    private volatile boolean _reuseAddress = true;
    private volatile int _soLingerTime = -1;
    private InetAddress _address;
    private final ConcurrentMap<String, SipConnection> _connections;

    public SelectChannelConnector(@Name(value="sipServer") SipServer server) {
        this(server, Math.max(1, Runtime.getRuntime().availableProcessors() / 4), Math.max(1, Runtime.getRuntime().availableProcessors() / 4));
    }

    public SelectChannelConnector(@Name(value="sipServer") SipServer server, @Name(value="acceptors") int acceptors, @Name(value="selectors") int selectors) {
        this(server, null, null, null, acceptors, selectors);
    }

    public SelectChannelConnector(@Name(value="sipServer") SipServer server, @Name(value="executor") Executor executor, @Name(value="scheduler") Scheduler scheduler, @Name(value="bufferPool") ByteBufferPool pool, @Name(value="acceptors") int acceptors, @Name(value="selectors") int selectors) {
        super(server, executor, acceptors);
        this._scheduler = scheduler != null ? scheduler : new TimerScheduler();
        this._byteBufferPool = pool != null ? pool : new ArrayByteBufferPool(2048, 4096, 65536);
        this._manager = new ConnectorSelectorManager(this.getExecutor(), this._scheduler, selectors);
        this._connections = new ConcurrentHashMap<String, SipConnection>();
        this.addBean(this._manager, true);
        this.addBean(this._scheduler, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocalPort() {
        SelectChannelConnector selectChannelConnector = this;
        synchronized (selectChannelConnector) {
            return this._localPort;
        }
    }

    public ByteBufferPool getByteBufferPool() {
        return this._byteBufferPool;
    }

    public int getAcceptQueueSize() {
        return this._acceptQueueSize;
    }

    public void setAcceptQueueSize(int acceptQueueSize) {
        this._acceptQueueSize = acceptQueueSize;
    }

    public long getIdleTimeout() {
        return this._idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this._idleTimeout = idleTimeout;
    }

    public boolean getReuseAddress() {
        return this._reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this._reuseAddress = reuseAddress;
    }

    public int getSoLingerTime() {
        return this._soLingerTime;
    }

    public void setSoLingerTime(int soLingerTime) {
        this._soLingerTime = soLingerTime;
    }

    public Scheduler getScheduler() {
        return this._scheduler;
    }

    @Override
    public Transport getTransport() {
        return Transport.TCP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws IOException {
        SelectChannelConnector selectChannelConnector = this;
        synchronized (selectChannelConnector) {
            if (this._acceptChannel == null) {
                this._acceptChannel = ServerSocketChannel.open();
                this._acceptChannel.configureBlocking(true);
                this._acceptChannel.socket().setReuseAddress(this.getReuseAddress());
                this._address = InetAddress.getByName(this.getHost());
                InetSocketAddress addr = new InetSocketAddress(this._address, this.getPort());
                this._acceptChannel.socket().bind(addr, this.getAcceptQueueSize());
                this._localPort = this._acceptChannel.socket().getLocalPort();
                if (this._localPort <= 0) {
                    throw new IOException("Server channel not bound");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        SelectChannelConnector selectChannelConnector = this;
        synchronized (selectChannelConnector) {
            if (this._acceptChannel != null && this._acceptChannel.isOpen()) {
                this._acceptChannel.close();
            }
            this._acceptChannel = null;
            this._localPort = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void accept(int id) throws IOException {
        ServerSocketChannel server;
        SelectChannelConnector selectChannelConnector = this;
        synchronized (selectChannelConnector) {
            server = this._acceptChannel;
        }
        if (server != null && server.isOpen() && this._manager.isStarted()) {
            SocketChannel channel = server.accept();
            channel.configureBlocking(false);
            Socket socket = channel.socket();
            this.configure(socket);
            this._manager.accept(channel);
        }
    }

    protected void configure(Socket socket) {
        try {
            socket.setTcpNoDelay(true);
            if (this._soLingerTime >= 0) {
                socket.setSoLinger(true, this._soLingerTime / 1000);
            } else {
                socket.setSoLinger(false, 0);
            }
        }
        catch (Exception e) {
            LOG.ignore((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SipConnection getConnection(InetAddress address, int port) throws IOException {
        SipConnection connection = (SipConnection)this._connections.get(this.getKey(address, port));
        if (connection == null || !connection.isOpen()) {
            SelectChannelConnector selectChannelConnector = this;
            synchronized (selectChannelConnector) {
                connection = (SipConnection)this._connections.get(this.getKey(address, port));
                if (connection == null || !connection.isOpen()) {
                    connection = this.newConnection(address, port);
                }
            }
        }
        return connection;
    }

    protected void removeConnection(SipConnection connection) {
        if (connection.getConnector() == this) {
            String key = this.getKey(connection.getRemoteAddress(), connection.getRemotePort());
            SipConnection c = (SipConnection)this._connections.remove(key);
            if (c == null) {
                LOG.debug("Could not remove unknown connection {}", new Object[]{connection});
            } else if (c != connection) {
                LOG.warn("Try to remove connection {} but remove {}", new Object[]{connection, c});
            } else {
                LOG.debug("Removed connection {} on {}", new Object[]{connection, this});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SipConnection newConnection(InetAddress address, int port) throws IOException {
        SocketChannel channel = SocketChannel.open();
        channel.connect(new InetSocketAddress(address, port));
        channel.configureBlocking(false);
        this.configure(channel.socket());
        SocketChannel socketChannel = channel;
        synchronized (socketChannel) {
            this._manager.accept(channel);
            try {
                channel.wait(this.getIdleTimeout());
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return (SipConnection)this._connections.get(this.getKey(address, port));
    }

    protected Connection newConnection(EndPoint endpoint) {
        SelectSipConnection connection = new SelectSipConnection(this, endpoint);
        return connection;
    }

    protected String getKey(InetAddress address, int port) {
        return address.getHostAddress() + ":" + port;
    }

    protected String getKey(Connection connection) {
        InetSocketAddress addr = connection.getEndPoint().getRemoteAddress();
        return this.getKey(addr.getAddress(), addr.getPort());
    }

    @Override
    public InetAddress getAddress() {
        return this._address;
    }

    public static void main(String[] args) throws Exception {
        String host = null;
        try {
            host = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            LOG.ignore((Throwable)e);
            host = "127.0.0.1";
        }
        SipServer sipServer = new SipServer();
        SelectChannelConnector connector = new SelectChannelConnector(sipServer);
        connector.setHost(host);
        connector.setPort(5060);
        sipServer.addConnector(connector);
        SipAppContext context = new SipAppContext();
        context.getServletHandler().addServlet(DefaultServlet.class.getName());
        sipServer.setHandler(context);
        sipServer.start();
    }

    private final class ConnectorSelectorManager
    extends SelectorManager {
        private ConnectorSelectorManager(Executor executor, Scheduler scheduler, int selectSets) {
            super(executor, scheduler, selectSets);
        }

        protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.ManagedSelector selectSet, SelectionKey selectionKey) throws IOException {
            return new SelectChannelEndPoint(channel, selectSet, selectionKey, this.getScheduler(), SelectChannelConnector.this.getIdleTimeout());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Connection newConnection(SocketChannel channel, EndPoint endpoint, Object attachment) {
            Connection connection = SelectChannelConnector.this.newConnection(endpoint);
            SelectChannelConnector.this._connections.put(SelectChannelConnector.this.getKey(connection), (SipConnection)connection);
            SocketChannel socketChannel = channel;
            synchronized (socketChannel) {
                channel.notify();
            }
            return connection;
        }

        protected void doStop() throws Exception {
            for (SipConnection connection : SelectChannelConnector.this._connections.values()) {
                connection.toString();
                if (!(connection instanceof AbstractConnection)) continue;
                ((AbstractConnection)connection).close();
            }
            SelectChannelConnector.this._connections.clear();
            super.doStop();
        }
    }
}

