/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.log;

import org.cipango.server.SipConnection;
import org.cipango.server.SipMessage;
import org.cipango.server.log.AccessLog;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;

@ManagedObject(value="Access log collection")
public class AccessLogCollection
extends ContainerLifeCycle
implements AccessLog {
    private AccessLog[] _loggers;

    @Override
    public void messageReceived(SipMessage message, SipConnection connection) {
        for (int i = 0; this._loggers != null && i < this._loggers.length; ++i) {
            this._loggers[i].messageReceived(message, connection);
        }
    }

    @Override
    public void messageSent(SipMessage message, SipConnection connection) {
        for (int i = 0; this._loggers != null && i < this._loggers.length; ++i) {
            this._loggers[i].messageSent(message, connection);
        }
    }

    @ManagedAttribute(value="logggers", readonly=true)
    public AccessLog[] getLoggers() {
        return this._loggers;
    }

    public void setLoggers(AccessLog[] loggers) {
        this.updateBeans(this._loggers, loggers);
        this._loggers = loggers;
    }

    public void addLogger(AccessLog accessLog) {
        this.setLoggers((AccessLog[])ArrayUtil.addToArray((Object[])this.getLoggers(), (Object)accessLog, AccessLog.class));
    }

    public void removeLogger(AccessLog accessLog) {
        Object[] loggers = this.getLoggers();
        if (loggers != null && loggers.length > 0) {
            this.setLoggers((AccessLog[])ArrayUtil.removeFromArray((Object[])loggers, (Object)accessLog));
        }
    }
}

