/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.log;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.TimeZone;
import org.cipango.server.MessageTooLongException;
import org.cipango.server.SipConnection;
import org.cipango.server.SipMessage;
import org.cipango.server.SipMessageGenerator;
import org.cipango.server.log.AccessLog;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class AbstractMessageLog
extends AbstractLifeCycle
implements AccessLog {
    private static final Logger LOG = Log.getLogger(AbstractMessageLog.class);
    public static final int MAXIMAL_BUFFER_LENGTH = 0x1000000;
    private DateCache _logDateCache;
    private String _logDateFormat = "yyyy-MM-dd HH:mm:ss";
    private Locale _logLocale = Locale.getDefault();
    private String _logTimeZone = TimeZone.getDefault().getID();
    private SipMessageGenerator _generator;
    private StringBuilder _buf = new StringBuilder();
    private ByteBuffer _buffer;
    public static final int IN = 0;
    public static final int OUT = 1;

    protected void doStart() throws Exception {
        try {
            this._logDateCache = new DateCache(this._logDateFormat, this._logLocale);
            this._logDateCache.setTimeZoneID(this._logTimeZone);
            this._generator = new SipMessageGenerator();
            this._buffer = ByteBuffer.allocate(65536);
            super.doStart();
        }
        catch (Exception e) {
            LOG.warn("Unable to log SIP messages: " + e.getMessage(), new Object[0]);
        }
    }

    @Override
    public void messageReceived(SipMessage message, SipConnection connection) {
        if (!this.isStarted()) {
            return;
        }
        try {
            this.doLog(message, 0, connection);
        }
        catch (Exception e) {
            LOG.warn("Failed to log message", (Throwable)e);
        }
    }

    @Override
    public void messageSent(SipMessage message, SipConnection connection) {
        if (!this.isStarted()) {
            return;
        }
        try {
            this.doLog(message, 1, connection);
        }
        catch (Exception e) {
            LOG.warn("Failed to log message", (Throwable)e);
        }
    }

    public abstract void doLog(SipMessage var1, int var2, SipConnection var3) throws IOException;

    protected String generateInfoLine(int direction, SipConnection connection, long date) {
        this._buf.setLength(0);
        this._buf.append(this._logDateCache.format(date));
        if (direction == 0) {
            this._buf.append(" IN  ");
        } else {
            this._buf.append(" OUT ");
        }
        this._buf.append((Object)connection.getConnector().getTransport());
        this._buf.append(" ");
        this._buf.append(connection.getLocalAddress());
        this._buf.append(':');
        this._buf.append(connection.getLocalPort());
        if (direction == 0) {
            this._buf.append(" < ");
        } else {
            this._buf.append(" > ");
        }
        this._buf.append(connection.getRemoteAddress());
        this._buf.append(':');
        this._buf.append(connection.getRemotePort());
        this._buf.append(StringUtil.__LINE_SEPARATOR);
        this._buf.append(StringUtil.__LINE_SEPARATOR);
        return this._buf.toString();
    }

    protected ByteBuffer generateMessage(SipMessage message) {
        this._buffer.clear();
        while (true) {
            try {
                this._generator.generateMessage(this._buffer, message);
            }
            catch (MessageTooLongException e) {
                if (this._buffer.capacity() < 0x1000000) {
                    this._buffer = ByteBuffer.allocate(this._buffer.capacity() * 2);
                    continue;
                }
                LOG.warn("Failed to log message", (Throwable)e);
                continue;
            }
            break;
        }
        return this._buffer;
    }
}

