/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import org.cipango.server.SipHandler;
import org.cipango.server.SipMessage;
import org.cipango.server.SipServer;
import org.cipango.server.handler.AbstractSipHandler;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject(value="SipHandler wrapping another SipHandler")
public class SipHandlerWrapper
extends AbstractSipHandler {
    protected SipHandler _handler;

    @ManagedAttribute(value="Wrapped Handler", readonly=true)
    public SipHandler getHandler() {
        return this._handler;
    }

    public void setHandler(SipHandler handler) {
        if (this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        if (handler != null) {
            handler.setServer(this.getServer());
        }
        this.updateBean(this._handler, handler);
        this._handler = handler;
    }

    @Override
    public void handle(SipMessage message) throws IOException, ServletException {
        if (this._handler != null && this.isStarted()) {
            this._handler.handle(message);
        }
    }

    @Override
    public void setServer(SipServer server) {
        if (server == this.getServer()) {
            return;
        }
        if (this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        super.setServer(server);
        SipHandler h = this.getHandler();
        if (h != null) {
            h.setServer(server);
        }
    }

    public void destroy() {
        if (!this.isStopped()) {
            throw new IllegalStateException("!STOPPED");
        }
        SipHandler child = this.getHandler();
        if (child != null) {
            this.setHandler(null);
        }
        super.destroy();
    }
}

