/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.handler;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.ar.SipApplicationRouter;
import javax.servlet.sip.ar.SipApplicationRouterInfo;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;
import javax.servlet.sip.ar.SipRouteModifier;
import org.cipango.server.RequestCustomizer;
import org.cipango.server.SipConnector;
import org.cipango.server.SipMessage;
import org.cipango.server.SipRequest;
import org.cipango.server.SipResponse;
import org.cipango.server.ar.ApplicationRouterLoader;
import org.cipango.server.ar.InitialRequestUtil;
import org.cipango.server.ar.RouterInfoUtil;
import org.cipango.server.handler.AbstractSipHandler;
import org.cipango.server.sipapp.SipAppContext;
import org.cipango.server.transaction.ServerTransaction;
import org.cipango.server.util.ExceptionUtil;
import org.cipango.sip.AddressImpl;
import org.cipango.sip.SipURIImpl;
import org.cipango.sip.URIFactory;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.WebAppContext;

@ManagedObject(value="Sip context handler collection")
public class SipContextHandlerCollection
extends AbstractSipHandler
implements RequestCustomizer {
    private static final Logger LOG = Log.getLogger(SipContextHandlerCollection.class);
    private SipAppContext[] _sipContexts;
    private HandlerCollection _webHandlerCollection;
    private SipApplicationRouter _applicationRouter;
    private BeanListener _beanListener = new BeanListener();
    private SipAppLifecycleListener _lifecycleListener = new SipAppLifecycleListener();

    public SipContextHandlerCollection(@Name(value="contexts") HandlerCollection contexts) {
        if (contexts != null) {
            contexts.addBean((Object)this._beanListener, false);
        }
        this._webHandlerCollection = contexts;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this._applicationRouter == null) {
            this.setApplicationRouter(ApplicationRouterLoader.loadApplicationRouter());
        }
        this._applicationRouter.init();
        ArrayList<String> appNames = new ArrayList<String>();
        SipAppContext[] contexts = this.getSipContexts();
        if (contexts != null) {
            for (SipAppContext context : contexts) {
                if (!this.isSipDeployed(context)) continue;
                appNames.add(context.getName());
            }
        }
        this._applicationRouter.applicationDeployed(appNames);
    }

    protected void doStop() throws Exception {
        if (this._applicationRouter != null) {
            this._applicationRouter.destroy();
        }
        if (this._webHandlerCollection != null) {
            this._webHandlerCollection.removeBean((Object)this);
        }
        super.doStop();
    }

    @Override
    public void handle(SipMessage message) throws IOException, ServletException {
        block16: {
            SipAppContext appContext;
            SipRequest request;
            block18: {
                String contextId;
                block17: {
                    if (!message.isRequest()) break block16;
                    request = (SipRequest)message;
                    appContext = null;
                    if (!request.isInitial()) break block17;
                    SipApplicationRouterInfo routerInfo = null;
                    Address route = request.getPoppedRoute();
                    try {
                        SipURI uri;
                        if (route != null && "X-Cipango-Router-Info".equals((uri = (SipURI)route.getURI()).getUser())) {
                            routerInfo = RouterInfoUtil.decode(uri);
                            InitialRequestUtil.decode(uri, request);
                            route = this.getServer().getTransportProcessor().popLocalRoute(request);
                            if (route != null) {
                                request.setPoppedRoute(route);
                            }
                        }
                        if (routerInfo == null) {
                            routerInfo = this.getApplicationRouter().getNextApplication((SipServletRequest)request, null, SipApplicationRoutingDirective.NEW, null, null);
                        }
                    }
                    catch (Throwable t) {
                        if (!request.isAck()) {
                            SipResponse response = new SipResponse(request, 500, "Application router error: " + t.getMessage());
                            ExceptionUtil.fillStackTrace(response, t);
                            this.sendResponse(response);
                        }
                        return;
                    }
                    if (routerInfo == null || routerInfo.getNextApplicationName() == null) break block18;
                    boolean handle = this.handlingRoute(request, routerInfo);
                    if (handle) {
                        return;
                    }
                    request.setStateInfo(routerInfo.getStateInfo());
                    request.setRegion(routerInfo.getRoutingRegion());
                    String s = routerInfo.getSubscriberURI();
                    if (s != null) {
                        try {
                            request.setSubscriberURI(URIFactory.parseURI((String)s));
                        }
                        catch (ParseException e) {
                            LOG.debug((Throwable)e);
                        }
                    }
                    String applicationName = routerInfo.getNextApplicationName();
                    appContext = this.getContext(applicationName);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("application router returned application {} for initial request {}", new Object[]{applicationName, request.getMethod()});
                    }
                    if (appContext == null && applicationName != null) {
                        LOG.debug("No application with name {} returned by application router could be found", new Object[]{applicationName, null});
                    }
                    break block18;
                }
                if (this._sipContexts != null && (contextId = this.getContextId(request)) != null) {
                    for (SipAppContext context : this._sipContexts) {
                        if (!contextId.equals(context.getContextId())) continue;
                        appContext = context;
                        break;
                    }
                }
            }
            if (appContext == null) {
                if (!request.isAck()) {
                    this.sendResponse(new SipResponse(request, 404, null));
                }
                return;
            }
            appContext.handle(message);
        }
    }

    private String getContextId(SipRequest request) {
        int index;
        String appId = request.getParameter("appid");
        if (appId == null) {
            appId = request.getToTag();
        }
        if (appId != null && (index = appId.indexOf(46)) != -1) {
            return appId.substring(0, index);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handlingRoute(SipRequest request, SipApplicationRouterInfo routerInfo) {
        if (routerInfo.getRouteModifier() == null) return false;
        if (SipRouteModifier.NO_ROUTE == routerInfo.getRouteModifier()) {
            return false;
        }
        String[] routes = routerInfo.getRoutes();
        try {
            if (SipRouteModifier.ROUTE == routerInfo.getRouteModifier() && routes != null) {
                AddressImpl topRoute = new AddressImpl(routes[0], true);
                if (this.getServer().isLocalURI(topRoute.getURI())) {
                    request.setPoppedRoute((Address)topRoute);
                    return false;
                }
                int i = routes.length;
                while (true) {
                    if (i < 0) {
                        request.send();
                        return true;
                    }
                    request.pushRoute((Address)new AddressImpl(routes[i]));
                    --i;
                }
            }
            if (SipRouteModifier.ROUTE_BACK == routerInfo.getRouteModifier() && routes != null) {
                SipURI ownRoute = (SipURI)this.getServer().getConnectors()[0].getURI().clone();
                RouterInfoUtil.encode(ownRoute, routerInfo);
                ownRoute.setLrParam(true);
                request.pushRoute(ownRoute);
                int i = routes.length;
                while (true) {
                    if (i < 0) {
                        request.send();
                        return true;
                    }
                    request.pushRoute((Address)new AddressImpl(routes[i]));
                    --i;
                }
            }
            if (routes != null) return false;
            if (SipRouteModifier.ROUTE_BACK != routerInfo.getRouteModifier()) {
                if (SipRouteModifier.ROUTE != routerInfo.getRouteModifier()) return false;
            }
            LOG.debug("Router info set route modifier to {} but no route provided, assume NO_ROUTE", new Object[]{routerInfo.getRouteModifier()});
            return false;
        }
        catch (Exception e) {
            if (request.isAck()) return true;
            SipResponse response = (SipResponse)request.createResponse(500, "Error in handler: " + e.getMessage());
            ExceptionUtil.fillStackTrace(response, e);
            try {
                this.sendResponse(response);
                return true;
            }
            catch (Exception e1) {
                LOG.ignore((Throwable)e1);
            }
            return true;
        }
    }

    private void sendResponse(SipResponse response) {
        if (response.to().getTag() == null) {
            response.to().setParameter("tag", "123");
        }
        ServerTransaction tx = (ServerTransaction)response.getTransaction();
        tx.send(response);
    }

    public SipAppContext getContext(String name) {
        if (this._sipContexts != null) {
            for (int i = 0; i < this._sipContexts.length; ++i) {
                if (!this._sipContexts[i].getName().equals(name)) continue;
                return this._sipContexts[i];
            }
        }
        return null;
    }

    @ManagedAttribute(value="SIP contexts", readonly=true)
    public SipAppContext[] getSipContexts() {
        return this._sipContexts;
    }

    public void addContext(SipAppContext context) {
        LOG.info("Add SIP context {}", new Object[]{context});
        this.setSipContexts((SipAppContext[])ArrayUtil.addToArray((Object[])this.getSipContexts(), (Object)context, SipAppContext.class));
        if (this.isStarted() && this.isSipDeployed(context)) {
            this._applicationRouter.applicationDeployed(Arrays.asList(context.getName()));
        }
        context.addLifeCycleListener((LifeCycle.Listener)this._lifecycleListener);
    }

    protected boolean isSipDeployed(SipAppContext context) {
        return context.isStarted() && context.hasSipServlets();
    }

    public void removeContext(SipAppContext context) {
        LOG.info("Remove SIP context {}", new Object[]{context});
        this.setSipContexts((SipAppContext[])ArrayUtil.removeFromArray((Object[])this.getSipContexts(), (Object)context));
        if (this.isStarted() && context.hasSipServlets()) {
            this._applicationRouter.applicationUndeployed(Arrays.asList(context.getName()));
        }
        context.removeLifeCycleListener((LifeCycle.Listener)this._lifecycleListener);
        this.removeBean(context);
    }

    private void setSipContexts(SipAppContext[] sipContexts) {
        if (sipContexts != null) {
            for (SipAppContext handler : sipContexts) {
                if (handler.getServer() == this.getServer()) continue;
                handler.setServer(this.getServer());
            }
        }
        this._sipContexts = sipContexts;
    }

    @ManagedAttribute(value="SIP application router", readonly=true)
    public SipApplicationRouter getApplicationRouter() {
        return this._applicationRouter;
    }

    public void setApplicationRouter(SipApplicationRouter applicationRouter) {
        this.updateBean(this._applicationRouter, applicationRouter);
        this._applicationRouter = applicationRouter;
    }

    @Override
    public void customizeRequest(SipRequest request) throws IOException {
        if (!request.isInitial()) {
            return;
        }
        SipApplicationRouterInfo routerInfo = this._applicationRouter.getNextApplication((SipServletRequest)request, request.getRegion(), request.getRoutingDirective(), null, request.getStateInfo());
        if (routerInfo != null && routerInfo.getNextApplicationName() != null) {
            SipConnector connector = this.getServer().getConnectors()[0];
            SipURIImpl route = new SipURIImpl(null, connector.getHost(), connector.getPort());
            RouterInfoUtil.encode((SipURI)route, routerInfo);
            InitialRequestUtil.encode((SipURI)route, request);
            route.setLrParam(true);
            request.pushRoute((SipURI)route);
        }
    }

    private class BeanListener
    implements Container.Listener {
        private BeanListener() {
        }

        public void beanAdded(Container parent, Object child) {
            WebAppContext context;
            SipAppContext appContext;
            if (child instanceof WebAppContext && (appContext = (SipAppContext)(context = (WebAppContext)child).getBean(SipAppContext.class)) != null) {
                SipContextHandlerCollection.this.addContext(appContext);
            }
        }

        public void beanRemoved(Container parent, Object child) {
            WebAppContext context;
            SipAppContext appContext;
            if (child instanceof WebAppContext && (appContext = (SipAppContext)(context = (WebAppContext)child).getBean(SipAppContext.class)) != null) {
                SipContextHandlerCollection.this.removeContext(appContext);
            }
        }
    }

    private class SipAppLifecycleListener
    extends AbstractLifeCycle.AbstractLifeCycleListener {
        private SipAppLifecycleListener() {
        }

        public void lifeCycleStarted(LifeCycle event) {
            SipAppContext context = (SipAppContext)event;
            if (SipContextHandlerCollection.this.isSipDeployed(context) && SipContextHandlerCollection.this.getServer().isStarted()) {
                SipContextHandlerCollection.this._applicationRouter.applicationDeployed(Arrays.asList(context.getName()));
            }
            SipContextHandlerCollection.this.addBean(context);
            SipContextHandlerCollection.this.manage(context);
        }

        public void lifeCycleStopped(LifeCycle event) {
            SipAppContext context = (SipAppContext)event;
            if (SipContextHandlerCollection.this.isStarted()) {
                SipContextHandlerCollection.this._applicationRouter.applicationUndeployed(Arrays.asList(context.getName()));
            }
        }
    }
}

