/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.dns;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import org.cipango.dns.DnsService;
import org.cipango.dns.Name;
import org.cipango.dns.record.NaptrRecord;
import org.cipango.dns.record.Record;
import org.cipango.dns.record.SrvRecord;
import org.cipango.dns.util.Inet6Util;
import org.cipango.server.Transport;
import org.cipango.server.dns.DnsResolver;
import org.cipango.server.dns.Hop;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="RFC 3263 DNS resolver")
public class Rfc3263DnsResolver
extends ContainerLifeCycle
implements DnsResolver {
    private static final Logger LOG = Log.getLogger(Rfc3263DnsResolver.class);
    private DnsService _dnsService;
    private boolean _useNaptr = true;
    private final List<String> _enableNaptrTransports = new ArrayList<String>();
    private final List<Transport> _enableTransports = new ArrayList<Transport>();
    private final Random _random = new Random();

    public Rfc3263DnsResolver() {
        this.setEnableTransports(Arrays.asList(Transport.TCP, Transport.UDP, Transport.TLS));
    }

    protected void doStart() throws Exception {
        if (this._dnsService == null) {
            this.setDnsService(new DnsService());
        }
        super.doStart();
    }

    @Override
    public List<Hop> getHops(Hop hop) throws UnknownHostException {
        Transport transport = hop.getTransport();
        if (Inet6Util.isValidIPV4Address((String)hop.getHost()) || Inet6Util.isValidIP6Address((String)hop.getHost())) {
            hop.setAddress(InetAddress.getByName(hop.getHost()));
            if (transport == null) {
                hop.setTransport(hop.isSecure() ? Transport.TLS : Transport.UDP);
            }
            if (!hop.isPortSet()) {
                hop.setPort(hop.getTransport().getDefaultPort());
            }
            return Arrays.asList(hop);
        }
        List<Hop> hops = null;
        if (hop.isPortSet()) {
            return this.lookupAllHostAddr(hop, transport);
        }
        if (transport == null) {
            List records = null;
            if (this._useNaptr) {
                try {
                    records = this._dnsService.lookup((Record)new NaptrRecord(hop.getHost()));
                }
                catch (IOException e) {
                    LOG.debug("Could not get NAPTR records for name {}, SRV resolution will be done.", new Object[]{hop.getHost()});
                }
            }
            if (records != null && !records.isEmpty()) {
                TreeSet<NaptrRecord> sipRecords = new TreeSet<NaptrRecord>();
                int minOrder = Integer.MAX_VALUE;
                for (Record record : records) {
                    NaptrRecord naptrRecord = (NaptrRecord)record;
                    String service = naptrRecord.getService();
                    if (!this._enableNaptrTransports.contains(service) || hop.isSecure() && !Transport.TLS.getService().equals(service)) continue;
                    if (naptrRecord.getOrder() < minOrder) {
                        sipRecords.clear();
                        minOrder = naptrRecord.getOrder();
                        sipRecords.add(naptrRecord);
                        continue;
                    }
                    if (naptrRecord.getOrder() != minOrder) continue;
                    sipRecords.add(naptrRecord);
                }
                for (NaptrRecord naptrRecord : sipRecords) {
                    Transport transport2 = this.getTransport(naptrRecord);
                    List<Hop> tmpHosts = this.resolveSrv(naptrRecord.getReplacement(), transport2);
                    if (hops == null) {
                        hops = tmpHosts;
                        continue;
                    }
                    hops.addAll(tmpHosts);
                }
            } else {
                for (Transport transport2 : this._enableTransports) {
                    if (transport2.isSecure() != hop.isSecure()) continue;
                    List<Hop> tmpHosts = this.resolveSrv(hop, transport2);
                    if (hops == null) {
                        hops = tmpHosts;
                        continue;
                    }
                    hops.addAll(tmpHosts);
                }
            }
        } else {
            hops = this.resolveSrv(hop, transport);
        }
        if (hops == null || hops.isEmpty()) {
            hops = this.lookupAllHostAddr(hop, transport);
        }
        return hops;
    }

    private List<Hop> lookupAllHostAddr(Hop hop, Transport transport) throws UnknownHostException {
        InetAddress[] addresses;
        ArrayList<Hop> hops = new ArrayList<Hop>();
        if (transport == null) {
            transport = hop.isSecure() ? Transport.TLS : Transport.UDP;
        }
        int port = hop.isPortSet() ? hop.getPort() : transport.getDefaultPort();
        for (InetAddress address : addresses = this._dnsService.lookupAllHostAddr(hop.getHost())) {
            Hop hop2 = new Hop();
            hop2.setHost(hop.getHost());
            hop2.setPort(port);
            hop2.setTransport(transport);
            hop2.setAddress(address);
            hops.add(hop2);
        }
        return hops;
    }

    private Transport getTransport(NaptrRecord record) {
        String service = record.getService();
        for (Transport transport : Transport.values()) {
            if (!transport.getService().equalsIgnoreCase(service)) continue;
            return transport;
        }
        return null;
    }

    private List<Hop> resolveSrv(Hop hop, Transport transport) {
        Name srvName = new Name(transport.getSrvPrefix() + hop.getHost());
        return this.resolveSrv(srvName, transport);
    }

    private List<Hop> resolveSrv(Name srvName, Transport transport) {
        Collection<SrvRecord> records;
        try {
            records = this.sortSrv(this._dnsService.lookup((Record)new SrvRecord(srvName)));
        }
        catch (Exception e1) {
            LOG.debug("Could not get SRV record for name {}", new Object[]{srvName});
            return null;
        }
        ArrayList<Hop> hops = new ArrayList<Hop>();
        for (SrvRecord record : records) {
            try {
                InetAddress[] addresses;
                for (InetAddress address : addresses = this._dnsService.lookupAllHostAddr(record.getTarget().toString())) {
                    Hop hop = new Hop();
                    hop.setHost(record.getTarget().toString());
                    hop.setPort(record.getPort());
                    hop.setAddress(address);
                    hop.setTransport(transport);
                    hops.add(hop);
                }
            }
            catch (UnknownHostException e) {
                LOG.debug("Could not get IP address for {} retrieve for SRV name {}", new Object[]{record.getTarget(), srvName});
            }
        }
        return hops;
    }

    protected Collection<SrvRecord> sortSrv(List<Record> original) {
        ArrayList<Record> list = new ArrayList<Record>(original);
        Collections.sort(list);
        ArrayList<SrvRecord> result = new ArrayList<SrvRecord>(list.size());
        block0: while (!list.isEmpty()) {
            SrvRecord r;
            int priority = ((SrvRecord)list.get(0)).getPriority();
            int totalWeight = 0;
            int count = 0;
            Iterator i$ = list.iterator();
            while (i$.hasNext() && (r = (SrvRecord)i$.next()).getPriority() == priority) {
                totalWeight += r.getWeight();
                ++count;
            }
            if (count == 1) {
                result.add((SrvRecord)list.remove(0));
                continue;
            }
            int w = this._random.nextInt(totalWeight);
            Iterator i = list.iterator();
            while (i.hasNext()) {
                SrvRecord r2 = (SrvRecord)i.next();
                if ((w -= r2.getWeight()) >= 0) continue;
                result.add(r2);
                i.remove();
                continue block0;
            }
        }
        return result;
    }

    public List<String> getEnableNaptrTransports() {
        return this._enableNaptrTransports;
    }

    @Override
    public void setEnableTransports(Collection<Transport> transports) {
        this._enableNaptrTransports.clear();
        for (Transport transport : transports) {
            this._enableNaptrTransports.add(transport.getService());
        }
        this._enableTransports.clear();
        this._enableTransports.addAll(transports);
    }

    @Override
    @ManagedAttribute(value="Enabled transport", readonly=true)
    public Collection<Transport> getEnableTransports() {
        return Collections.unmodifiableList(this._enableTransports);
    }

    @ManagedAttribute(value="DNS service")
    public DnsService getDnsService() {
        return this._dnsService;
    }

    public void setDnsService(DnsService dnsService) {
        this.updateBean(this._dnsService, dnsService);
        this._dnsService = dnsService;
    }

    @ManagedAttribute(value="Use NAPTR")
    public boolean getUseNaptr() {
        return this._useNaptr;
    }

    public void setUseNaptr(boolean useNaptr) {
        this.updateBean(this._useNaptr, useNaptr);
        this._useNaptr = useNaptr;
    }
}

