/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.dns;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.cipango.server.SipResponse;
import org.cipango.server.dns.BlackList;
import org.cipango.server.dns.Hop;
import org.cipango.sip.SipHeader;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Black list")
public class BlackListImpl
implements BlackList,
Dumpable {
    private static final Logger LOG = Log.getLogger(BlackListImpl.class);
    public static final long DEFAULT_BLACK_LIST_DURATION = 300L;
    private long _blackListDuration;
    private ConcurrentHashMap<String, ExpirableHop> _map = new ConcurrentHashMap();
    private Criteria _criteria = Criteria.IP_ADDRESS;
    private long _scavengePeriod = 60000L;
    private long _nextScavenge = System.currentTimeMillis() + this._scavengePeriod;

    public BlackListImpl() {
        this.setBlackListDuration(300L);
    }

    @Override
    public boolean isBlacklisted(Hop hop) {
        String key;
        ExpirableHop expirableHop;
        if (System.currentTimeMillis() < this._nextScavenge) {
            this.scavenge();
        }
        if ((expirableHop = this._map.get(key = this.getKey(hop))) == null) {
            return false;
        }
        if (expirableHop.isExpired()) {
            LOG.debug("The hop {} is no more blacklisted", new Object[]{expirableHop.getHop()});
            this._map.remove(key);
            return false;
        }
        return true;
    }

    private String getKey(Hop hop) {
        String criteria;
        switch (this._criteria) {
            case IP_ADDRESS: {
                criteria = hop.getAddress().getHostAddress();
                break;
            }
            case IP_PORT: {
                criteria = hop.getAddress().getHostAddress() + ":" + hop.getPort();
                break;
            }
            case IP_PORT_TRANSPORT: {
                criteria = hop.getAddress().getHostAddress() + ":" + hop.getPort() + "/" + (Object)((Object)hop.getTransport());
                break;
            }
            default: {
                criteria = hop.getAddress().getHostAddress();
            }
        }
        return criteria;
    }

    @Override
    public void hopFailed(Hop hop, BlackList.Reason reason, SipResponse response) {
        this.blackListHop(hop, this.getBlacklistDuration(response));
    }

    protected long getBlacklistDuration(SipResponse response) {
        if (response == null) {
            return this._blackListDuration;
        }
        int retryAfter = -1;
        String sRetryAfter = response.getHeader(SipHeader.RETRY_AFTER.asString());
        if (sRetryAfter != null) {
            try {
                retryAfter = Integer.parseInt(sRetryAfter);
            }
            catch (Exception e) {
                LOG.debug("Failed to parse Retry-After header", (Throwable)e);
                return this._blackListDuration;
            }
            if (retryAfter >= 0) {
                return retryAfter * 1000;
            }
            LOG.debug("Negative Retry-After header in 503 response, blacklist server for " + this.getBlackListDuration() + "s", new Object[0]);
            return this._blackListDuration;
        }
        LOG.debug("No Retry-After header in 503 response, blacklist server for " + this.getBlackListDuration() + "s", new Object[0]);
        return this._blackListDuration;
    }

    protected void blackListHop(Hop hop, long duration) {
        LOG.debug("The hop {} is now blacklisted for {} seconds", new Object[]{hop, duration / 1000L});
        this._map.putIfAbsent(this.getKey(hop), new ExpirableHop(hop, duration));
    }

    @ManagedOperation(value="Remove hops that are no more blacklisted", impact="ACTION")
    public void scavenge() {
        this._nextScavenge = System.currentTimeMillis() + this._scavengePeriod;
        Iterator<ExpirableHop> it = this._map.values().iterator();
        while (it.hasNext()) {
            ExpirableHop expirableHop = it.next();
            if (!expirableHop.isExpired()) continue;
            LOG.debug("The hop {} is no more blacklisted", new Object[]{expirableHop.getHop()});
            it.remove();
        }
    }

    @ManagedAttribute(value="Black list duration in seconds")
    public long getBlackListDuration() {
        return this._blackListDuration / 1000L;
    }

    public void setBlackListDuration(long blackListDuration) {
        this._blackListDuration = blackListDuration * 1000L;
    }

    @ManagedAttribute(value="Criteria")
    public Criteria getCriteria() {
        return this._criteria;
    }

    public void setCriteria(Criteria criteria) {
        this._criteria = criteria;
    }

    public void setBlackListCriteria(String criteria) {
        this._criteria = Criteria.valueOf(criteria.toUpperCase());
    }

    @ManagedAttribute(value="Scavenge period")
    public long getScavengePeriod() {
        return this._scavengePeriod;
    }

    public void setScavengePeriod(long scavengePeriod) {
        this._scavengePeriod = scavengePeriod;
    }

    public String dump() {
        return ContainerLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        out.append(this.toString()).append('\n');
        for (Map.Entry<String, ExpirableHop> entry : this._map.entrySet()) {
            out.append(indent).append("  - ");
            out.append(entry.getKey()).append("@").append(String.valueOf(entry.getValue().getRemaining() / 1000L)).append("s\n");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{c=" + (Object)((Object)this._criteria) + ", d=" + this.getBlackListDuration() + ", size=" + this._map.size() + "}";
    }

    protected static class ExpirableHop {
        private Hop _hop;
        private long _expirationDate;

        public ExpirableHop(Hop hop, long duration) {
            this._hop = hop;
            this._expirationDate = System.currentTimeMillis() + duration;
        }

        public Hop getHop() {
            return this._hop;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() > this._expirationDate;
        }

        public long getRemaining() {
            return this._expirationDate - System.currentTimeMillis();
        }

        public String toString() {
            return this._hop.toString() + "@" + this.getRemaining() / 1000L + "s";
        }
    }

    public static enum Criteria {
        IP_ADDRESS,
        IP_PORT,
        IP_PORT_TRANSPORT;

    }
}

