/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server.ar;

import java.io.IOException;
import javax.servlet.sip.Address;
import javax.servlet.sip.SipURI;
import org.cipango.server.SipRequest;
import org.cipango.sip.AddressImpl;

public class InitialRequestUtil {
    private static final String POPPED_ROUTE = "popped-route";
    private static final String REMOTE_ADDR = "remote-addr";
    private static final String REMOTE_PORT = "remote-port";
    private static final String TRANSPORT = "transport";

    public static void encode(SipURI uri, SipRequest request) throws IOException {
        InitialRequestUtil.setParameter(uri, POPPED_ROUTE, request.getInitialPoppedRoute());
        if (request.getInitialRemoteAddr() != null) {
            InitialRequestUtil.setParameter(uri, REMOTE_ADDR, request.getInitialRemoteAddr());
            InitialRequestUtil.setParameter(uri, REMOTE_PORT, request.getInitialRemotePort());
            InitialRequestUtil.setParameter(uri, TRANSPORT, request.getInitialTransport());
        }
    }

    private static void setParameter(SipURI uri, String name, Object value) {
        if (value != null) {
            uri.setParameter(name, value.toString());
        }
    }

    public static void decode(SipURI uri, SipRequest request) throws Exception {
        String remoteAddr;
        String route = uri.getParameter(POPPED_ROUTE);
        if (route != null) {
            request.setInitialPoppedRoute((Address)new AddressImpl(route, true));
        }
        if ((remoteAddr = uri.getParameter(REMOTE_ADDR)) != null) {
            request.setInitialRemoteAddr(remoteAddr);
            request.setInitialRemotePort(Integer.parseInt(uri.getParameter(REMOTE_PORT)));
            request.setInitialTransport(uri.getParameter(TRANSPORT));
        }
    }
}

