/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletException;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.cipango.server.MessageTooLongException;
import org.cipango.server.SipConnection;
import org.cipango.server.SipConnector;
import org.cipango.server.SipHandler;
import org.cipango.server.SipMessage;
import org.cipango.server.SipProcessor;
import org.cipango.server.SipRequest;
import org.cipango.server.SipResponse;
import org.cipango.server.Transport;
import org.cipango.server.dns.Hop;
import org.cipango.server.handler.SipContextHandlerCollection;
import org.cipango.server.log.AccessLog;
import org.cipango.server.log.event.Events;
import org.cipango.server.nio.UdpConnector;
import org.cipango.server.processor.TransportProcessor;
import org.cipango.server.sipapp.SipAppContext;
import org.cipango.server.transaction.RetryableTransactionManager;
import org.cipango.server.transaction.TransactionManager;
import org.cipango.sip.Via;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

@ManagedObject(value="SIP server")
public class SipServer
extends ContainerLifeCycle {
    private static final Logger LOG = Log.getLogger(SipServer.class);
    private static final String __version = SipServer.class.getPackage() != null && SipServer.class.getPackage().getImplementationVersion() != null ? SipServer.class.getPackage().getImplementationVersion() : System.getProperty("cipango.version", "3.x.y-SNAPSHOT");
    private final ThreadPool _threadPool;
    private SipConnector[] _connectors;
    private SipHandler _handler;
    private SipProcessor _processor;
    private TransportProcessor _transportProcessor;
    private TransactionManager _transactionManager;
    private AccessLog _accessLog;
    private final AtomicLong _messagesReceived = new AtomicLong();
    private final AtomicLong _messagesSent = new AtomicLong();
    private Server _server;

    public SipServer() {
        this(null);
    }

    public SipServer(@Name(value="port") int port) {
        this(null);
        UdpConnector connector = new UdpConnector(this);
        connector.setPort(port);
        this.setConnectors(new SipConnector[]{connector});
    }

    public SipServer(@Name(value="threadpool") ThreadPool pool) {
        this(pool, null);
    }

    public SipServer(@Name(value="threadpool") ThreadPool pool, @Name(value="transactionManager") TransactionManager transactionManager) {
        this._threadPool = pool != null ? pool : new QueuedThreadPool();
        this.addBean(this._threadPool);
        this._transactionManager = transactionManager != null ? transactionManager : new RetryableTransactionManager();
        this._transportProcessor = new TransportProcessor(this._transactionManager);
        this._transactionManager.setTransportProcessor(this._transportProcessor);
        this.addBean(this._transactionManager);
        this.addBean(this._transportProcessor);
        this._processor = this._transportProcessor;
        this._processor.setServer(this);
    }

    protected void doStart() throws Exception {
        LOG.info("cipango-" + __version, new Object[0]);
        MultiException mex = new MultiException();
        try {
            super.doStart();
        }
        catch (Throwable e) {
            mex.add(e);
        }
        this._handler.start();
        if (this._connectors != null) {
            for (int i = 0; i < this._connectors.length; ++i) {
                try {
                    this._connectors[i].start();
                    continue;
                }
                catch (Exception e) {
                    mex.add((Throwable)e);
                }
            }
        }
        mex.ifExceptionThrow();
        Events.fire(0, "Cipango " + __version + " started");
    }

    protected void doStop() throws Exception {
        Events.fire(1, "Stopping Cipango " + __version);
        MultiException mex = new MultiException();
        this._handler.stop();
        if (this._connectors != null) {
            int i = this._connectors.length;
            while (i-- > 0) {
                try {
                    this._connectors[i].stop();
                }
                catch (Exception e) {
                    mex.add((Throwable)e);
                }
            }
        }
        super.doStop();
        mex.ifExceptionThrow();
    }

    @ManagedAttribute(value="Cipango version")
    public String getVersion() {
        return __version;
    }

    @ManagedAttribute(value="SIP connectors", readonly=true)
    public SipConnector[] getConnectors() {
        return this._connectors;
    }

    public void addConnector(SipConnector connector) {
        this.setConnectors((SipConnector[])ArrayUtil.addToArray((Object[])this.getConnectors(), (Object)connector, SipConnector.class));
    }

    public void setConnectors(SipConnector[] connectors) {
        this.updateBeans(this._connectors, connectors);
        this._connectors = connectors;
    }

    @ManagedAttribute(value="Thread pool")
    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setHandler(SipHandler handler) {
        if (handler != null) {
            handler.setServer(this);
        }
        if (this._handler != handler) {
            if (this._handler != null) {
                this.removeBean(this._handler);
            }
            if (handler != null) {
                this.addBean(handler, true);
            }
        }
        this._handler = handler;
    }

    @ManagedAttribute(value="Handler", readonly=true)
    public SipHandler getHandler() {
        return this._handler;
    }

    public void process(final SipMessage message) {
        this._threadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SipServer.this.messageReceived(message);
                    SipServer.this._processor.doProcess(message);
                }
                catch (Exception e) {
                    LOG.warn("Failed to handle message: " + message, (Throwable)e);
                }
            }
        });
    }

    public void handle(SipMessage message) throws IOException, ServletException {
        try {
            this._handler.handle(message);
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
        }
    }

    public boolean isLocalURI(URI uri) {
        if (!uri.isSipURI()) {
            return false;
        }
        SipURI sipUri = (SipURI)uri;
        if (!sipUri.getLrParam()) {
            return false;
        }
        String host = sipUri.getHost();
        if (host.indexOf("[") != -1) {
            try {
                host = InetAddress.getByName(host).getHostAddress();
            }
            catch (UnknownHostException e) {
                LOG.ignore((Throwable)e);
            }
        }
        for (int i = 0; i < this._connectors.length; ++i) {
            boolean samePort;
            SipConnector connector = this._connectors[i];
            String connectorHost = connector.getURI().getHost();
            boolean bl = samePort = connector.getPort() == sipUri.getPort() || sipUri.getPort() == -1;
            if (!samePort || !connectorHost.equals(host) && !connector.getAddress().getHostAddress().equals(host)) continue;
            if (sipUri.getPort() != -1) {
                return true;
            }
            return !connector.getAddress().getHostAddress().equals(host) || connector.getPort() == connector.getTransport().getDefaultPort();
        }
        return false;
    }

    public void sendResponse(SipResponse response, SipConnection connection) throws IOException {
        try {
            if (connection == null || !connection.getConnector().getTransport().isReliable() || !connection.isOpen()) {
                Via via = response.getTopVia();
                SipConnector connector = null;
                InetAddress address = null;
                if (connection != null) {
                    connector = connection.getConnector();
                    address = connection.getRemoteAddress();
                } else {
                    address = via.hasMAddr() ? InetAddress.getByName(via.getMAddr()) : InetAddress.getByName(via.getHost());
                    connector = this._transactionManager.getTransportProcessor().findConnector(Transport.valueOf(via.getTransport()), address);
                }
                int port = -1;
                if (via.hasRPort()) {
                    port = via.getRPort();
                } else {
                    port = via.getPort();
                    if (port == -1) {
                        port = connection.getConnector().getTransport().getDefaultPort();
                    }
                }
                connection = connector.getConnection(address, port);
                if (connection == null) {
                    throw new IOException("Could not found any SIP connection to " + address + ":" + port + "/" + (Object)((Object)connector.getTransport()));
                }
            }
            connection.send(response);
            this.messageSent(response, connection);
        }
        catch (MessageTooLongException e) {
            if (connection instanceof UdpConnector.UdpConnection) {
                try {
                    LOG.debug("Failed to send response has it is bigger than MTU, try with UDP maximum size", new Object[0]);
                    ((UdpConnector.UdpConnection)connection).send(response, true);
                    this.messageSent(response, connection);
                    return;
                }
                catch (MessageTooLongException e1) {
                    // empty catch block
                }
            }
            LOG.warn((Throwable)e);
        }
    }

    public void sendRequest(SipRequest request, SipConnection connection) throws IOException {
        block8: {
            try {
                connection.send(request);
                this.messageSent(request, connection);
            }
            catch (MessageTooLongException e) {
                if (!connection.getConnector().getTransport().isReliable()) {
                    LOG.debug("Message is too large.", new Object[0]);
                    ListIterator<Hop> hops = request.getHops();
                    try {
                        request.setHops(null);
                        SipConnection newConnection = this._transactionManager.getTransportProcessor().getConnection(request, Transport.TCP);
                        if (newConnection.getConnector().getTransport().isReliable()) {
                            LOG.debug("Switching to TCP.", new Object[0]);
                            this.sendRequest(request, newConnection);
                        }
                    }
                    catch (IOException io) {
                        LOG.warn("Failed to switch to TCP.", new Object[0]);
                        request.setHops(hops);
                        Via via = request.getTopVia();
                        SipConnector connector = connection.getConnector();
                        via.setTransport(connector.getTransport().getName());
                        via.setHost(connector.getURI().getHost());
                        via.setPort(connector.getURI().getPort());
                        if (!(connection instanceof UdpConnector.UdpConnection)) break block8;
                        try {
                            ((UdpConnector.UdpConnection)connection).send(request, true);
                            this.messageSent(request, connection);
                            break block8;
                        }
                        catch (MessageTooLongException e1) {
                            throw new IOException(e);
                        }
                    }
                }
                LOG.warn((Throwable)e);
            }
        }
    }

    protected void messageReceived(SipMessage message) {
        this._messagesReceived.incrementAndGet();
        if (this._accessLog != null) {
            this._accessLog.messageReceived(message, message.getConnection());
        }
    }

    protected void messageSent(SipMessage message, SipConnection connection) {
        this._messagesSent.incrementAndGet();
        if (this._accessLog != null) {
            this._accessLog.messageSent(message, connection);
        }
    }

    @ManagedAttribute(value="Transaction manager", readonly=true)
    public TransactionManager getTransactionManager() {
        return this._transactionManager;
    }

    @ManagedAttribute(value="Transport processor", readonly=true)
    public TransportProcessor getTransportProcessor() {
        return this._transportProcessor;
    }

    @ManagedAttribute(value="Access log", readonly=true)
    public AccessLog getAccessLog() {
        return this._accessLog;
    }

    public void setAccessLog(AccessLog accessLog) {
        this.updateBean(this._accessLog, accessLog);
        this._accessLog = accessLog;
    }

    @ManagedAttribute(value="Messages received")
    public long getMessagesReceived() {
        return this._messagesReceived.get();
    }

    @ManagedAttribute(value="Messages sent")
    public long getMessagesSent() {
        return this._messagesSent.get();
    }

    @ManagedOperation(value="Reset statistics", impact="ACTION")
    public void statsReset() {
        this._messagesReceived.set(0L);
        this._messagesSent.set(0L);
        this.getTransactionManager().statsReset();
        if (this._handler instanceof SipContextHandlerCollection) {
            SipAppContext[] handlers = ((SipContextHandlerCollection)this._handler).getSipContexts();
            if (handlers != null) {
                for (SipAppContext context : handlers) {
                    context.getSessionHandler().getSessionManager().statsReset();
                }
            }
        } else if (this._handler instanceof SipAppContext) {
            ((SipAppContext)this._handler).getSessionHandler().getSessionManager().statsReset();
        }
    }

    public void setServer(Server server) {
        if (server != null && this._server != server) {
            if (this.isStarted()) {
                throw new IllegalStateException("Started");
            }
            this._server = server;
            this._server.addLifeCycleListener((LifeCycle.Listener)new ServerListener());
            this._server.addBean((Object)this, false);
        }
    }

    private class ServerListener
    extends AbstractLifeCycle.AbstractLifeCycleListener {
        private ServerListener() {
        }

        public void lifeCycleStarted(LifeCycle event) {
            try {
                SipServer.this._server.manage((Object)SipServer.this);
                SipServer.this.start();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void lifeCycleStopping(LifeCycle event) {
            try {
                SipServer.this.stop();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

