/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.ProxyBranch;
import javax.servlet.sip.Rel100Exception;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import org.cipango.server.SipMessage;
import org.cipango.server.SipRequest;
import org.cipango.server.session.Session;
import org.cipango.server.session.SessionManager;
import org.cipango.server.transaction.Transaction;
import org.cipango.sip.AddressImpl;
import org.cipango.sip.Authenticate;
import org.cipango.sip.SipFields;
import org.cipango.sip.SipGenerator;
import org.cipango.sip.SipHeader;
import org.cipango.sip.SipMethod;
import org.cipango.sip.SipStatus;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SipResponse
extends SipMessage
implements SipServletResponse {
    private static final Logger LOG = Log.getLogger(SipResponse.class);
    private SipRequest _request;
    private int _status;
    private String _reason;
    private ProxyBranch _proxyBranch;
    private boolean _branchResponse = false;

    public SipResponse() {
    }

    public SipResponse(SipRequest request, int status, String reason) {
        this(request, status, reason, request.session());
    }

    public SipResponse(SipRequest request, int status, String reason, Session session) {
        this._request = request;
        if (status >= 200) {
            this._request.setCommitted(true);
        }
        this._session = session;
        this.setStatus(status, reason);
        SipFields requestFields = request.getFields();
        this._fields.copy(requestFields, SipHeader.VIA);
        this._fields.copy(requestFields, SipHeader.FROM);
        this._fields.copy(requestFields, SipHeader.TO);
        this._fields.copy(requestFields, SipHeader.CALL_ID);
        this._fields.copy(requestFields, SipHeader.CSEQ);
        if (status < 300) {
            this._fields.copy(requestFields, SipHeader.RECORD_ROUTE);
        }
        if (this._session != null) {
            if (this._request.isInitial() || this._request.isCancel()) {
                AddressImpl to = (AddressImpl)this._fields.get(SipHeader.TO);
                if (status > 100 && !this._session.isProxy() && to.getTag() == null) {
                    this._session.setUAS();
                    to.setParameter("tag", this._session.getLocalTag());
                }
            }
            if (this.needsContact()) {
                this._fields.set(SipHeader.CONTACT, (Object)this._session.getContact(request.getConnection()));
            }
        }
    }

    public SipResponse(SipResponse other) {
        super(other);
        this._request = other._request;
        this._status = other._status;
        this._reason = other._reason;
        this._proxyBranch = other._proxyBranch;
        this._branchResponse = other._branchResponse;
    }

    public boolean is2xx() {
        return 200 <= this._status && this._status < 300;
    }

    @Override
    public boolean needsContact() {
        return (this.isInvite() || this.isSubscribe() || this.isMethod(SipMethod.NOTIFY) || this.isMethod(SipMethod.REFER) || this.isMethod(SipMethod.UPDATE)) && this.getStatus() < 300;
    }

    @Override
    public Transaction getTransaction() {
        return this._request.getTransaction();
    }

    public void send() throws IOException {
        this.send(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(boolean reliable) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("response is committed");
        }
        try (SessionManager.ApplicationSessionScope scope = this.appSession().getSessionManager().openScope(this.appSession());){
            this._session.sendResponse(this, reliable);
            this.setCommitted(true);
        }
    }

    public boolean isSuccess() {
        return SipStatus.isSuccess((int)this._status);
    }

    @Override
    public boolean isRequest() {
        return false;
    }

    @Override
    public void setCharacterEncoding(String encoding) {
        this._characterEncoding = encoding;
    }

    public void setBufferSize(int size) {
    }

    public int getBufferSize() {
        return 0;
    }

    public void flushBuffer() throws IOException {
    }

    public void resetBuffer() {
    }

    public void reset() {
    }

    public void setLocale(Locale locale) {
        this.setContentLanguage(locale);
    }

    public SipServletRequest createAck() {
        if (!this.isInvite()) {
            throw new IllegalStateException("Not INVITE method");
        }
        if (this._status > 100 && this._status < 200) {
            try {
                return this.createPrack();
            }
            catch (Rel100Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        if (this.is2xx()) {
            this.setCommitted(true);
            return this._session.getUa().createRequest(SipMethod.ACK, this.getCSeq().getNumber());
        }
        throw new IllegalStateException("non 2xx or 1xx response");
    }

    public SipServletRequest createPrack() throws Rel100Exception {
        if (this.isCommitted()) {
            throw new IllegalStateException("Already committed");
        }
        if (!this.isInvite()) {
            throw new Rel100Exception(1);
        }
        if (this._status > 100 && this._status < 200) {
            long rseq = this.getRSeq();
            if (!this.isReliable1xx()) {
                throw new Rel100Exception(4);
            }
            SipRequest request = (SipRequest)this._session.createRequest(SipMethod.PRACK.asString());
            request.getFields().set(SipHeader.RACK, (Object)(rseq + " " + this.getCSeq()));
            this.setCommitted(true);
            return request;
        }
        throw new Rel100Exception(0);
    }

    public boolean isReliable1xx() {
        if (this._status > 100 && this._status < 200) {
            if (this.getRSeq() == -1L) {
                return false;
            }
            ListIterator it = this._fields.getValues(SipHeader.REQUIRE.asString());
            while (it.hasNext()) {
                String val = (String)it.next();
                if (!"100rel".equalsIgnoreCase(val)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public void setRSeq(long rseq) {
        this.getFields().set(SipHeader.RSEQ, (Object)Long.toString(rseq));
    }

    public long getRSeq() {
        return this.getFields().getLong(SipHeader.RSEQ);
    }

    public Iterator<String> getChallengeRealms() {
        Authenticate authenticate;
        ArrayList<String> list = new ArrayList<String>();
        ListIterator it = this._fields.getValues(SipHeader.WWW_AUTHENTICATE.asString());
        while (it.hasNext()) {
            authenticate = new Authenticate((String)it.next());
            list.add(authenticate.getParameter(Authenticate.Param.REALM.toString()));
        }
        it = this._fields.getValues(SipHeader.PROXY_AUTHENTICATE.asString());
        while (it.hasNext()) {
            authenticate = new Authenticate((String)it.next());
            list.add(authenticate.getParameter(Authenticate.Param.REALM.toString()));
        }
        return list.iterator();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return null;
    }

    public Proxy getProxy() {
        if (this._proxyBranch != null) {
            return this._proxyBranch.getProxy();
        }
        return null;
    }

    public ProxyBranch getProxyBranch() {
        return this._proxyBranch;
    }

    public String getReasonPhrase() {
        if (this._reason != null) {
            return this._reason;
        }
        SipStatus status = SipStatus.get((int)this._status);
        if (status == null) {
            return null;
        }
        return status.getReason();
    }

    public String getNullableReasonPhrase() {
        return this._reason;
    }

    public SipServletRequest getRequest() {
        return this._request;
    }

    public int getStatus() {
        return this._status;
    }

    public Locale getLocale() {
        return this.getContentLanguage();
    }

    @Override
    public SipMethod getSipMethod() {
        if (this._sipMethod == null) {
            String method = this.getMethod();
            this._sipMethod = SipMethod.get((String)method);
        }
        return this._sipMethod;
    }

    public String getMethod() {
        if (this._method == null) {
            try {
                this._method = this.getCSeq().getMethod();
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
            }
        }
        return this._method;
    }

    public PrintWriter getWriter() throws IOException {
        return null;
    }

    public boolean isBranchResponse() {
        return this._branchResponse;
    }

    public void sendReliably() throws Rel100Exception {
        String s;
        SipRequest request = (SipRequest)this.getRequest();
        if (!request.isInvite()) {
            throw new Rel100Exception(1);
        }
        if (this._status < 101 || this._status > 199) {
            throw new Rel100Exception(0);
        }
        ListIterator<String> it = this._request.getHeaders(SipHeader.SUPPORTED.asString());
        boolean supports100rel = false;
        while (it.hasNext() && !supports100rel) {
            s = (String)it.next();
            if (!s.equals("100rel")) continue;
            supports100rel = true;
        }
        if (!supports100rel) {
            it = this._request.getHeaders(SipHeader.REQUIRE.asString());
            while (it.hasNext() && !supports100rel) {
                s = (String)it.next();
                if (!s.equals("100rel")) continue;
                supports100rel = true;
            }
        }
        if (!supports100rel) {
            throw new Rel100Exception(2);
        }
        try {
            this.send(true);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public void setStatus(int status) {
        this.setStatus(status, null);
    }

    public void setStatus(int status, String reason) {
        if (status < 100 || status >= 700) {
            throw new IllegalArgumentException("Invalid status-code: " + status);
        }
        this._status = status;
        this._reason = reason;
    }

    @Override
    protected boolean canSetContact() {
        return this.isRegister() || this.getStatus() >= 300 && this.getStatus() < 400 || this.getStatus() == 485 || this.getStatus() == 200 && this.isMethod(SipMethod.OPTIONS);
    }

    public String toString() {
        ByteBuffer buffer = null;
        int bufferSize = 4096 + this.getContentLength();
        while (true) {
            buffer = ByteBuffer.allocate(bufferSize);
            try {
                new SipGenerator().generateResponse(buffer, this._status, this._reason, this._fields, this.getRawContent(), this.getHeaderForm());
                return new String(buffer.array(), 0, buffer.position(), StringUtil.__UTF8_CHARSET);
            }
            catch (BufferOverflowException e) {
                bufferSize += 4096 + this.getContentLength();
                continue;
            }
            break;
        }
    }

    @Override
    public String toStringCompact() {
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        new SipGenerator().generateResponseLine(buffer, this._status, this._reason);
        SipFields.Field field = this.getFields().getField(SipHeader.CALL_ID);
        if (field != null) {
            field.putTo(buffer, SipServletMessage.HeaderForm.DEFAULT);
        }
        return new String(buffer.array(), 0, buffer.position(), StringUtil.__UTF8_CHARSET);
    }

    public void setRequest(SipRequest request) {
        this._request = request;
    }

    public void setBranchResponse(boolean branchResponse) {
        this._branchResponse = branchResponse;
    }

    public void setProxyBranch(ProxyBranch proxyBranch) {
        this._proxyBranch = proxyBranch;
    }
}

