/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.sip.Address;
import javax.servlet.sip.AuthInfo;
import javax.servlet.sip.B2buaHelper;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TooManyHopsException;
import javax.servlet.sip.URI;
import javax.servlet.sip.ar.SipApplicationRouterInfo;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;
import org.cipango.server.B2bHelper;
import org.cipango.server.SipMessage;
import org.cipango.server.SipProxy;
import org.cipango.server.SipResponse;
import org.cipango.server.dns.Hop;
import org.cipango.server.security.AuthInfoImpl;
import org.cipango.server.session.SessionManager;
import org.cipango.server.session.scoped.ScopedServerTransactionListener;
import org.cipango.server.transaction.ClientTransaction;
import org.cipango.server.transaction.ServerTransaction;
import org.cipango.server.transaction.Transaction;
import org.cipango.sip.AddressImpl;
import org.cipango.sip.Authenticate;
import org.cipango.sip.Authorization;
import org.cipango.sip.RAck;
import org.cipango.sip.SipFields;
import org.cipango.sip.SipGenerator;
import org.cipango.sip.SipHeader;
import org.cipango.sip.SipMethod;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SipRequest
extends SipMessage
implements SipServletRequest {
    private static final Logger LOG = Log.getLogger(SipRequest.class);
    private static boolean __strictRoutingEnabled = false;
    private URI _requestUri;
    private Transaction _transaction;
    private Address _poppedRoute;
    private Address _initialPoppedRoute;
    private Serializable _stateInfo;
    private SipApplicationRouterInfo _nextRouterInfo;
    private SipApplicationRoutingDirective _directive;
    private SipApplicationRoutingRegion _region;
    private URI _subscriberURI;
    private Proxy _proxy;
    private B2buaHelper _b2bHelper;
    private SipRequest _linkedRequest;
    private boolean _nextHopStrictRouting = false;
    private boolean _handled = false;
    private ListIterator<Hop> _hops;

    public SipRequest() {
    }

    public SipRequest(SipRequest other) {
        super(other);
        this._requestUri = other._requestUri.clone();
        this._stateInfo = other._stateInfo;
        this._nextRouterInfo = other._nextRouterInfo;
        this._directive = other._directive;
        this._subscriberURI = other._subscriberURI;
        this._initialPoppedRoute = other._initialPoppedRoute;
    }

    @Override
    public boolean isRequest() {
        return true;
    }

    public void setMethod(SipMethod sipMethod, String method) {
        this._sipMethod = sipMethod;
        this._method = method;
    }

    public String getMethod() {
        return this._method;
    }

    public void setTransaction(Transaction transaction) {
        this._transaction = transaction;
    }

    @Override
    public Transaction getTransaction() {
        return this._transaction;
    }

    @Override
    protected boolean canSetContact() {
        return this._sipMethod == SipMethod.REGISTER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send() throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Request is already commited");
        }
        if (this.getTransaction() != null && !(this.getTransaction() instanceof ClientTransaction)) {
            throw new IllegalStateException("Can send request only in UAC mode");
        }
        this.setCommitted(true);
        try (SessionManager.ApplicationSessionScope scope = this.appSession().getSessionManager().openScope(this.appSession());){
            if (this.isCancel()) {
                ((ClientTransaction)this.getTransaction()).cancel(this);
            } else {
                this._session.sendRequest(this);
            }
        }
    }

    public Address getTopRoute() throws ServletParseException {
        SipFields.Field field = this._fields.getField(SipHeader.ROUTE);
        if (field == null) {
            return null;
        }
        return field.asAddress();
    }

    public Address removeTopRoute() {
        return (Address)this._fields.removeFirst(SipHeader.ROUTE);
    }

    public void setPoppedRoute(Address route) {
        this._poppedRoute = route;
    }

    public void addRecordRoute(Address route) {
        this._fields.add(SipHeader.RECORD_ROUTE.asString(), (Object)route, true);
    }

    public SipServletRequest createCancel() {
        if (this.getTransaction().isCompleted()) {
            throw new IllegalStateException("Transaction has completed");
        }
        SipRequest cancel = this.createRequest(SipMethod.CANCEL);
        cancel.to().removeParameter("tag");
        return cancel;
    }

    public SipRequest createRequest(SipMethod method) {
        SipRequest request = new SipRequest();
        request._session = this._session;
        request.setTransaction(this.getTransaction());
        request._fields.set(SipHeader.FROM, this.getFrom().clone());
        request._fields.set(SipHeader.TO, (Object)this.to().clone());
        request.setMethod(method, method.asString());
        request.setRequestURI(this.getRequestURI());
        request._fields.copy(this._fields, SipHeader.CALL_ID);
        request._fields.set(SipHeader.CSEQ, (Object)(this.getCSeq().getNumber() + " " + method.asString()));
        request._fields.set(SipHeader.VIA, (Object)this.getTopVia());
        request._fields.copy(this._fields, SipHeader.MAX_FORWARDS);
        request._fields.copy(this._fields, SipHeader.ROUTE);
        return request;
    }

    public SipServletResponse createResponse(int status) {
        return this.createResponse(status, null);
    }

    public SipServletResponse createResponse(int status, String reason) {
        if (this.isAck()) {
            throw new IllegalStateException("Cannot create response to ACK");
        }
        if (!(this.getTransaction() instanceof ServerTransaction)) {
            throw new IllegalStateException("Cannot create response if not in UAS mode");
        }
        if (this.getTransaction().isCompleted()) {
            throw new IllegalStateException("Cannot create response if final response has been sent");
        }
        return new SipResponse(this, status, reason);
    }

    @Override
    public boolean needsContact() {
        return this.isInvite() || this.isSubscribe() || this.isMethod(SipMethod.NOTIFY) || this.isMethod(SipMethod.REFER) || this.isMethod(SipMethod.UPDATE);
    }

    public SipURI getParamUri() {
        if (this._poppedRoute != null) {
            return (SipURI)this._poppedRoute.getURI();
        }
        if (this._requestUri.isSipURI()) {
            return (SipURI)this._requestUri;
        }
        return null;
    }

    public String getParameter(String name) {
        SipURI paramUri = this.getParamUri();
        if (paramUri == null) {
            return null;
        }
        return paramUri.getParameter(name);
    }

    public Enumeration<String> getParameterNames() {
        SipURI paramUri = this.getParamUri();
        if (paramUri == null) {
            return Collections.emptyEnumeration();
        }
        return new IteratorToEnum(paramUri.getParameterNames());
    }

    public String[] getParameterValues(String name) {
        String value = this.getParameter(name);
        if (value == null) {
            return null;
        }
        return new String[]{value};
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        SipURI paramUri = this.getParamUri();
        if (paramUri != null) {
            Iterator it = paramUri.getParameterNames();
            while (it.hasNext()) {
                String key = (String)it.next();
                map.put(key, new String[]{paramUri.getParameter(key)});
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public String getScheme() {
        return this._requestUri.getScheme();
    }

    public String getServerName() {
        return this.getLocalName();
    }

    public int getServerPort() {
        return this.getLocalPort();
    }

    public String getRemoteHost() {
        return this.getRemoteAddr();
    }

    public Locale getLocale() {
        return this.getAcceptLanguage();
    }

    public Enumeration<Locale> getLocales() {
        final Iterator<Locale> it = this.getAcceptLanguages();
        return new Enumeration<Locale>(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            @Override
            public Locale nextElement() {
                return (Locale)it.next();
            }
        };
    }

    public RAck getRAck() throws ServletParseException {
        String s = this.getFields().getString(SipHeader.RACK);
        return s == null ? null : new RAck(s);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException("Not Applicable");
    }

    public String getRealPath(String path) {
        return null;
    }

    public String getLocalName() {
        return this.getConnection() != null ? this.getConnection().getLocalAddress().getHostName() : null;
    }

    public void addAuthHeader(SipServletResponse response, AuthInfo authInfo) {
        Authorization authorization;
        AuthInfoImpl.AuthElement element;
        Authenticate authenticate;
        ListIterator authenticates = response.getHeaders(SipHeader.WWW_AUTHENTICATE.toString());
        while (authenticates.hasNext()) {
            authenticate = new Authenticate((String)authenticates.next());
            element = ((AuthInfoImpl)authInfo).getAuthElement(response.getStatus(), authenticate.getRealm());
            authorization = new Authorization(authenticate, element.getUsername(), element.getPassword(), this._requestUri.toString(), this.getMethod());
            this.addHeader(SipHeader.AUTHORIZATION.toString(), authorization.toString());
        }
        authenticates = response.getHeaders(SipHeader.PROXY_AUTHENTICATE.toString());
        while (authenticates.hasNext()) {
            authenticate = new Authenticate((String)authenticates.next());
            element = ((AuthInfoImpl)authInfo).getAuthElement(response.getStatus(), authenticate.getRealm());
            authorization = new Authorization(authenticate, element.getUsername(), element.getPassword(), this._requestUri.toString(), this.getMethod());
            this.addHeader(SipHeader.PROXY_AUTHORIZATION.toString(), authorization.toString());
        }
    }

    public void addAuthHeader(SipServletResponse response, String username, String password) {
        Authorization authorization;
        Authenticate authenticate;
        ListIterator authenticates = response.getHeaders(SipHeader.WWW_AUTHENTICATE.toString());
        while (authenticates.hasNext()) {
            authenticate = new Authenticate((String)authenticates.next());
            authorization = new Authorization(authenticate, username, password, this._requestUri.toString(), this.getMethod());
            this.addHeader(SipHeader.AUTHORIZATION.toString(), authorization.toString());
        }
        authenticates = response.getHeaders(SipHeader.PROXY_AUTHENTICATE.toString());
        while (authenticates.hasNext()) {
            authenticate = new Authenticate((String)authenticates.next());
            authorization = new Authorization(authenticate, username, password, this._requestUri.toString(), this.getMethod());
            this.addHeader(SipHeader.PROXY_AUTHORIZATION.toString(), authorization.toString());
        }
    }

    public B2buaHelper getB2buaHelper() {
        if (this._b2bHelper != null) {
            return this._b2bHelper;
        }
        if (this._proxy != null) {
            throw new IllegalStateException("getProxy() had already been called");
        }
        this._b2bHelper = B2bHelper.getInstance();
        if (!this._session.isUA() && this.getTransaction().isServer()) {
            this._session.setUAS();
            ((ServerTransaction)this.getTransaction()).setListener(new ScopedServerTransactionListener(this.session(), this._session.getUa()));
        }
        return this._b2bHelper;
    }

    public Address getInitialPoppedRoute() {
        if (this._initialPoppedRoute == null) {
            return this._poppedRoute;
        }
        return this._initialPoppedRoute;
    }

    public void setInitialPoppedRoute(Address route) {
        this._initialPoppedRoute = route;
    }

    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    public int getMaxForwards() {
        return (int)this._fields.getLong(SipHeader.MAX_FORWARDS);
    }

    public Address getPoppedRoute() {
        return this._poppedRoute;
    }

    public Proxy getProxy() throws TooManyHopsException {
        return this.getProxy(true);
    }

    public Proxy getProxy(boolean create) throws TooManyHopsException {
        if (this._proxy != null || !create) {
            return this._proxy;
        }
        if (this._b2bHelper != null) {
            throw new IllegalStateException("getB2buaHelper() had already been called");
        }
        if (!this._transaction.isServer()) {
            throw new IllegalStateException("Not a received request");
        }
        this._session.setProxy();
        if (this._proxy == null) {
            SipProxy proxy = new SipProxy(this);
            proxy.setProxyTimeout(this.appSession().getContext().getProxyTimeout());
            this._proxy = proxy;
        }
        return this._proxy;
    }

    public void setProxy(Proxy proxy) {
        this._proxy = proxy;
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public SipApplicationRoutingRegion getRegion() {
        return this._region;
    }

    public URI getRequestURI() {
        return this._requestUri;
    }

    public SipApplicationRoutingDirective getRoutingDirective() throws IllegalStateException {
        if (!this.isInitial()) {
            throw new IllegalStateException("SipServletRequest is not initial");
        }
        return this._directive;
    }

    public void setRoutingDirective(SipApplicationRoutingDirective directive, SipServletRequest origRequest) throws IllegalStateException {
        if (!this.isInitial()) {
            throw new IllegalStateException("SipServletRequest is not initial");
        }
        if (!(directive == SipApplicationRoutingDirective.NEW || origRequest != null && origRequest.isInitial())) {
            throw new IllegalStateException("origRequest is not initial");
        }
        if (this.isCommitted()) {
            throw new IllegalStateException("SipServletRequest is committed");
        }
        this._directive = directive;
    }

    public URI getSubscriberURI() {
        return this._subscriberURI;
    }

    public boolean isInitial() {
        return this.getToTag() == null && !this.isCancel();
    }

    public void pushPath(Address arg0) {
    }

    public void pushRoute(SipURI route) {
        this.pushRoute((Address)new AddressImpl((URI)route));
    }

    public void pushRoute(Address route) {
        boolean strictRouting;
        if (!route.getURI().isSipURI()) {
            throw new IllegalArgumentException("Only routes with a SIP URI may be pushed");
        }
        boolean bl = strictRouting = !((SipURI)route.getURI()).getLrParam();
        if (strictRouting && !SipRequest.isStrictRoutingEnabled()) {
            throw new IllegalArgumentException("Route does not contains lr param and strict routing disabled");
        }
        if (this.isNextHopStrictRouting()) {
            if (strictRouting) {
                this._fields.add(SipHeader.ROUTE.asString(), (Object)new AddressImpl(this.getRequestURI()), true);
                this.setRequestURI(route.getURI());
            } else {
                Address lastRoute = this.removeLastRoute();
                this._fields.add(SipHeader.ROUTE.asString(), (Object)new AddressImpl(this.getRequestURI()), true);
                this.setRequestURI(lastRoute.getURI());
                this._fields.add(SipHeader.ROUTE.asString(), (Object)route, true);
            }
        } else if (strictRouting) {
            this._fields.add(SipHeader.ROUTE.asString(), (Object)new AddressImpl(this.getRequestURI()), false);
            this.setRequestURI(route.getURI());
        } else {
            this._fields.add(SipHeader.ROUTE.asString(), (Object)route, true);
        }
        this.setNextHopStrinctRouting(strictRouting);
    }

    public Address removeLastRoute() {
        try {
            Address route;
            Iterator it = this._fields.getAddressValues(SipHeader.ROUTE, null);
            ArrayList<Address> list = new ArrayList<Address>();
            Address lastRoute = null;
            while (it.hasNext()) {
                route = (Address)it.next();
                if (it.hasNext()) {
                    list.add(route);
                    continue;
                }
                lastRoute = route;
            }
            it = list.iterator();
            if (it.hasNext()) {
                this._fields.set(SipHeader.ROUTE, it.next());
            } else {
                return this.removeTopRoute();
            }
            while (it.hasNext()) {
                route = (Address)it.next();
                this._fields.add(SipHeader.ROUTE.asString(), (Object)route, false);
            }
            return lastRoute;
        }
        catch (ServletParseException e) {
            throw new RuntimeException(e);
        }
    }

    public void setNextHopStrinctRouting(boolean nextHopStrictRouting) {
        this._nextHopStrictRouting = nextHopStrictRouting;
    }

    public boolean isNextHopStrictRouting() {
        return this._nextHopStrictRouting;
    }

    public void setMaxForwards(int maxForwards) {
        if (maxForwards < 0 || maxForwards > 255) {
            throw new IllegalArgumentException("Max-Forwards should be between 0 and 255");
        }
        this._fields.set(SipHeader.MAX_FORWARDS, (Object)Long.toString(maxForwards));
    }

    public void setRequestURI(URI uri) {
        if (uri == null) {
            throw new NullPointerException("Null URI");
        }
        this._requestUri = uri;
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        return null;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return null;
    }

    public AsyncContext startAsync(ServletRequest arg0, ServletResponse arg1) throws IllegalStateException {
        return null;
    }

    public SipRequest getLinkedRequest() {
        return this._linkedRequest;
    }

    public void setLinkedRequest(SipRequest request) {
        this._linkedRequest = request;
    }

    public Serializable getStateInfo() {
        return this._stateInfo;
    }

    public void setStateInfo(Serializable stateInfo) {
        this._stateInfo = stateInfo;
    }

    public void setRegion(SipApplicationRoutingRegion region) {
        this._region = region;
    }

    public void setSubscriberURI(URI uri) {
        this._subscriberURI = uri;
    }

    public boolean isHandled() {
        return this._handled;
    }

    public void setHandled(boolean handled) {
        this._handled = handled;
    }

    public ListIterator<Hop> getHops() {
        return this._hops;
    }

    public void setHops(ListIterator<Hop> hops) {
        this._hops = hops;
    }

    public String toString() {
        ByteBuffer buffer = null;
        int bufferSize = 4096 + this.getContentLength();
        while (true) {
            buffer = ByteBuffer.allocate(bufferSize);
            try {
                new SipGenerator().generateRequest(buffer, this._method, this._requestUri, this._fields, this.getRawContent(), this.getHeaderForm());
                return new String(buffer.array(), 0, buffer.position(), StringUtil.__UTF8_CHARSET);
            }
            catch (BufferOverflowException e) {
                bufferSize += 4096 + this.getContentLength();
                continue;
            }
            break;
        }
    }

    @Override
    public String toStringCompact() {
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        new SipGenerator().generateRequestLine(buffer, this._method, this._requestUri);
        SipFields.Field field = this.getFields().getField(SipHeader.CALL_ID);
        if (field != null) {
            field.putTo(buffer, SipServletMessage.HeaderForm.DEFAULT);
        }
        return new String(buffer.array(), 0, buffer.position(), StringUtil.__UTF8_CHARSET);
    }

    public static boolean isStrictRoutingEnabled() {
        return __strictRoutingEnabled;
    }

    public static void setStrictRoutingEnabled(boolean strictRoutingEnabled) {
        __strictRoutingEnabled = strictRoutingEnabled;
    }

    static class IteratorToEnum
    implements Enumeration<String> {
        private Iterator<String> _it;

        public IteratorToEnum(Iterator<String> it) {
            this._it = it;
        }

        @Override
        public boolean hasMoreElements() {
            return this._it.hasNext();
        }

        @Override
        public String nextElement() {
            return this._it.next();
        }
    }
}

