/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import javax.servlet.sip.Address;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipSession;
import org.cipango.server.SipConnection;
import org.cipango.server.SipRequest;
import org.cipango.server.servlet.SipServletHolder;
import org.cipango.server.session.ApplicationSession;
import org.cipango.server.session.Session;
import org.cipango.server.session.scoped.ScopedAppSession;
import org.cipango.server.session.scoped.ScopedSession;
import org.cipango.server.transaction.Transaction;
import org.cipango.server.util.ContactAddress;
import org.cipango.server.util.ListIteratorProxy;
import org.cipango.server.util.ReadOnlyAddress;
import org.cipango.server.util.ReadOnlyParameterable;
import org.cipango.sip.AddressImpl;
import org.cipango.sip.CSeq;
import org.cipango.sip.SipFields;
import org.cipango.sip.SipHeader;
import org.cipango.sip.SipMethod;
import org.cipango.sip.SipVersion;
import org.cipango.sip.Via;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class SipMessage
implements SipServletMessage {
    private static final Logger LOG = Log.getLogger(SipMessage.class);
    private static final Collection<Locale> __defaultLocale = Collections.singleton(Locale.getDefault());
    protected final SipFields _fields;
    private long _timeStamp;
    private SipConnection _connection;
    private boolean _committed = false;
    private SipServletMessage.HeaderForm _headerForm = SipServletMessage.HeaderForm.DEFAULT;
    protected String _characterEncoding;
    protected Session _session;
    protected SipMethod _sipMethod;
    protected String _method;
    private byte[] _content;
    private Attributes _attributes;
    private SipServletHolder _handler;
    private String _initialRemoteAddr;
    private int _initialRemotePort;
    private String _initialTransport;
    private UserIdentity _userIdentity;

    public SipMessage() {
        this._fields = new SipFields();
    }

    public SipMessage(SipMessage other) {
        this._fields = new SipFields(other._fields);
        this._headerForm = other._headerForm;
        this._characterEncoding = other._characterEncoding;
        this._session = other._session;
        this._sipMethod = other._sipMethod;
        this._method = other._method;
        this._content = other._content;
    }

    public boolean isRegister() {
        return this.getSipMethod() == SipMethod.REGISTER;
    }

    public boolean isInvite() {
        return this.getSipMethod() == SipMethod.INVITE;
    }

    public boolean isAck() {
        return this.getSipMethod() == SipMethod.ACK;
    }

    public boolean isCancel() {
        return this.getSipMethod() == SipMethod.CANCEL;
    }

    public boolean isBye() {
        return this.getSipMethod() == SipMethod.BYE;
    }

    public boolean isPrack() {
        return this.getSipMethod() == SipMethod.PRACK;
    }

    public boolean isSubscribe() {
        return this.getSipMethod() == SipMethod.SUBSCRIBE;
    }

    public boolean isNotify() {
        return this.getSipMethod() == SipMethod.NOTIFY;
    }

    public boolean isUpdate() {
        return this.getSipMethod() == SipMethod.UPDATE;
    }

    public boolean isMethod(SipMethod method) {
        return this.getSipMethod() == method;
    }

    public SipMethod getSipMethod() {
        return this._sipMethod;
    }

    protected boolean isSystemHeader(SipHeader header) {
        return header != null && (header.isSystem() || header == SipHeader.CONTACT && !this.canSetContact());
    }

    public SipFields getFields() {
        return this._fields;
    }

    public void setTimeStamp(long ts) {
        this._timeStamp = ts;
    }

    public long getTimeStamp() {
        return this._timeStamp;
    }

    public void setConnection(SipConnection connection) {
        this._connection = connection;
    }

    public SipConnection getConnection() {
        return this._connection;
    }

    public void setSession(Session session) {
        this._session = session;
    }

    public abstract boolean isRequest();

    protected abstract boolean canSetContact();

    public abstract boolean needsContact();

    public abstract String toStringCompact();

    public abstract Transaction getTransaction();

    public Via getTopVia() {
        return (Via)this._fields.get(SipHeader.VIA);
    }

    public CSeq getCSeq() {
        try {
            String cseq = this._fields.getString(SipHeader.CSEQ);
            if (cseq != null) {
                return new CSeq(cseq);
            }
            return null;
        }
        catch (ServletParseException e) {
            LOG.ignore((Throwable)e);
            return null;
        }
    }

    public String getToTag() {
        return this.to().getTag();
    }

    public AddressImpl from() {
        return (AddressImpl)this._fields.get(SipHeader.FROM);
    }

    public AddressImpl to() {
        return (AddressImpl)this._fields.get(SipHeader.TO);
    }

    public Session session() {
        return this._session;
    }

    public ApplicationSession appSession() {
        return this._session.appSession();
    }

    public void addAcceptLanguage(Locale locale) {
        this.addHeader(SipHeader.ACCEPT_LANGUAGE.asString(), locale.toString().replace('_', '-'));
    }

    public void addAddressHeader(String name, Address address, boolean first) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Message is committed");
        }
        SipHeader header = (SipHeader)SipHeader.CACHE.get(name);
        if (header != null) {
            if (header.getType() != SipHeader.Type.ADDRESS && header.getType() != SipHeader.Type.STRING) {
                throw new IllegalArgumentException("Header: " + name + " is not of address type");
            }
            if (this.isSystemHeader(header)) {
                throw new IllegalArgumentException(name + " is a system header");
            }
            name = header.asString();
        }
        if (address == null || name == null) {
            throw new NullPointerException("name or address is null");
        }
        this._fields.add(name, (Object)address, first);
    }

    public void addHeader(String name, String value) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Message is committed");
        }
        SipHeader header = (SipHeader)SipHeader.CACHE.get(name);
        if (this.isSystemHeader(header)) {
            throw new IllegalArgumentException(name + " is a system header");
        }
        if (value == null || name == null) {
            throw new NullPointerException("name or value is null");
        }
        this._fields.add(name, value);
    }

    public void addParameterableHeader(String name, Parameterable parameterable, boolean first) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Message is committed");
        }
        SipHeader header = (SipHeader)SipHeader.CACHE.get(name);
        if (header != null) {
            if (header.getType() != SipHeader.Type.PARAMETERABLE && header.getType() != SipHeader.Type.ADDRESS && header.getType() != SipHeader.Type.VIA) {
                throw new IllegalArgumentException("Header " + name + " is not of parameterable type");
            }
            if (this.isSystemHeader(header)) {
                throw new IllegalArgumentException(name + " is a system header");
            }
            name = header.asString();
        }
        if (parameterable == null || name == null) {
            throw new NullPointerException("name or address is null");
        }
        this._fields.add(name, (Object)parameterable, first);
    }

    public Locale getAcceptLanguage() {
        Iterator<Locale> it = this.getAcceptLanguages();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public Iterator<Locale> getAcceptLanguages() {
        final ListIterator it = this.getFields().getValues(SipHeader.ACCEPT_LANGUAGE.asString());
        if (!it.hasNext()) {
            return __defaultLocale.iterator();
        }
        List acceptLanguage = HttpFields.qualityList((Enumeration)new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)it.next();
            }
        });
        if (acceptLanguage.size() == 0) {
            return __defaultLocale.iterator();
        }
        Object langs = null;
        int size = acceptLanguage.size();
        for (int i = 0; i < size; ++i) {
            String language = (String)acceptLanguage.get(i);
            language = HttpFields.valueParameters((String)language, null);
            String country = "";
            int dash = language.indexOf(45);
            if (dash > -1) {
                country = language.substring(dash + 1).trim();
                language = language.substring(0, dash).trim();
            }
            langs = LazyList.ensureSize(langs, (int)size);
            langs = LazyList.add((Object)langs, (Object)new Locale(language, country));
        }
        if (LazyList.size(langs) == 0) {
            return __defaultLocale.iterator();
        }
        List l = LazyList.getList(langs);
        return l.iterator();
    }

    public Address getAddressHeader(String name) throws ServletParseException {
        SipHeader header = (SipHeader)SipHeader.CACHE.get(name);
        if (header != null && header.getType() != SipHeader.Type.ADDRESS && header.getType() != SipHeader.Type.STRING) {
            throw new ServletParseException("Header: " + name + " is not of address type");
        }
        SipFields.Field field = header != null ? this._fields.getField(header) : this._fields.getField(name);
        if (field == null) {
            return null;
        }
        Address address = field.asAddress();
        if (header == SipHeader.CONTACT && this.isSystemHeader(header) && !this.isCommitted()) {
            return new ContactAddress(address);
        }
        return this.isSystemHeader(header) || this.isCommitted() ? new ReadOnlyAddress(address) : address;
    }

    public ListIterator<Address> getAddressHeaders(String name) throws ServletParseException {
        SipHeader header = (SipHeader)SipHeader.CACHE.get(name);
        if (header != null && header.getType() != SipHeader.Type.ADDRESS && header.getType() != SipHeader.Type.STRING) {
            throw new ServletParseException("Header: " + name + " is not of address type");
        }
        ListIterator it = this._fields.getAddressValues(header, name);
        if (this.isSystemHeader(header) || this.isCommitted()) {
            return new ListIteratorProxy<Address>(it){

                @Override
                public Address next() {
                    return new ReadOnlyAddress((Address)super.next());
                }

                @Override
                public Address previous() {
                    return new ReadOnlyAddress((Address)super.previous());
                }
            };
        }
        return it;
    }

    public SipApplicationSession getApplicationSession() {
        if (this._session == null) {
            return null;
        }
        return new ScopedAppSession(this._session.appSession());
    }

    public SipApplicationSession getApplicationSession(boolean create) {
        return this.getApplicationSession();
    }

    public Object getAttribute(String name) {
        return this._attributes == null ? null : this._attributes.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        if (this._attributes == null) {
            return Collections.emptyEnumeration();
        }
        return AttributesMap.getAttributeNamesCopy((Attributes)this._attributes);
    }

    public String getCallId() {
        return this._fields.getString(SipHeader.CALL_ID);
    }

    public String getCharacterEncoding() {
        int i1;
        int i0;
        if (this._characterEncoding != null) {
            return this._characterEncoding;
        }
        String contentType = this.getContentType();
        if (contentType != null && (i0 = contentType.indexOf(59)) > 0 && (i1 = contentType.indexOf("charset=", i0 + 1)) >= 0) {
            int i8 = i1 + 8;
            int i2 = contentType.indexOf(59, i8);
            this._characterEncoding = i2 > 0 ? QuotedStringTokenizer.unquote((String)contentType.substring(i8, i2)) : QuotedStringTokenizer.unquote((String)contentType.substring(i8));
        }
        return this._characterEncoding;
    }

    public Object getContent() throws IOException, UnsupportedEncodingException {
        String contentType = this.getContentType();
        if (this._content != null && contentType != null && (StringUtil.startsWithIgnoreCase((String)contentType, (String)"text") || contentType.equalsIgnoreCase("application/sdp"))) {
            String charset = this.getCharacterEncoding();
            if (charset == null) {
                charset = "UTF-8";
            }
            return new String(this._content, charset);
        }
        return this._content;
    }

    public Locale getContentLanguage() {
        String s = this.getHeader(SipHeader.CONTENT_LANGUAGE.asString());
        if (s == null) {
            return null;
        }
        return new Locale(s);
    }

    public int getContentLength() {
        int length = (int)this._fields.getLong(SipHeader.CONTENT_LENGTH);
        if (length == -1) {
            if (this._content == null) {
                return 0;
            }
            return this._content.length;
        }
        return length;
    }

    public String getContentType() {
        return this.getHeader(SipHeader.CONTENT_TYPE.asString());
    }

    public int getExpires() {
        return (int)this._fields.getLong(SipHeader.EXPIRES);
    }

    public Address getFrom() {
        return new ReadOnlyAddress((Address)this._fields.get(SipHeader.FROM));
    }

    public String getHeader(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        return this._fields.getString(name);
    }

    public SipServletMessage.HeaderForm getHeaderForm() {
        return this._headerForm;
    }

    public Iterator<String> getHeaderNames() {
        return this._fields.getNames();
    }

    public ListIterator<String> getHeaders(String name) {
        return this._fields.getValues(name);
    }

    public String getInitialRemoteAddr() {
        if (this._initialRemoteAddr == null) {
            return this.getRemoteAddr();
        }
        return this._initialRemoteAddr;
    }

    public int getInitialRemotePort() {
        if (this._initialRemoteAddr == null) {
            return this.getRemotePort();
        }
        return this._initialRemotePort;
    }

    public String getInitialTransport() {
        if (this._initialTransport == null) {
            return this.getTransport();
        }
        return this._initialTransport;
    }

    public String getLocalAddr() {
        return this._connection != null ? this._connection.getLocalAddress().getHostAddress() : null;
    }

    public int getLocalPort() {
        return this._connection != null ? this._connection.getLocalPort() : -1;
    }

    public Parameterable getParameterableHeader(String name) throws ServletParseException {
        SipFields.Field field;
        SipHeader header = (SipHeader)SipHeader.CACHE.get(name);
        if (header != null) {
            if (header.getType() != SipHeader.Type.PARAMETERABLE && header.getType() != SipHeader.Type.ADDRESS && header.getType() != SipHeader.Type.VIA) {
                throw new ServletParseException("Header " + name + " is not of parameterable type");
            }
            field = this._fields.getField(header);
        } else {
            field = this._fields.getField(name);
        }
        if (field == null) {
            return null;
        }
        Parameterable p = field.asParameterable();
        return this.isSystemHeader(header) ? new ReadOnlyParameterable(p) : p;
    }

    public ListIterator<? extends Parameterable> getParameterableHeaders(String name) throws ServletParseException {
        SipHeader header = (SipHeader)SipHeader.CACHE.get(name);
        if (header != null && header.getType() != SipHeader.Type.PARAMETERABLE && header.getType() != SipHeader.Type.ADDRESS && header.getType() != SipHeader.Type.VIA) {
            throw new ServletParseException("Header " + name + " is not of parameterable type");
        }
        ListIterator it = this._fields.getParameterableValues(header, name);
        if (this.isSystemHeader(header) || this.isCommitted()) {
            return new ListIteratorProxy<Parameterable>(it){

                @Override
                public Parameterable next() {
                    return new ReadOnlyParameterable((Parameterable)super.next());
                }

                @Override
                public Parameterable previous() {
                    return new ReadOnlyParameterable((Parameterable)super.previous());
                }
            };
        }
        return it;
    }

    public String getProtocol() {
        return SipVersion.SIP_2_0.asString();
    }

    public byte[] getRawContent() {
        return this._content;
    }

    public String getRemoteAddr() {
        return this._connection != null ? this._connection.getRemoteAddress().getHostAddress() : null;
    }

    public int getRemotePort() {
        return this._connection != null ? this._connection.getRemotePort() : -1;
    }

    public String getRemoteUser() {
        if (this._userIdentity != null) {
            return this._userIdentity.getUserPrincipal().getName();
        }
        return null;
    }

    public SipSession getSession() {
        return new ScopedSession(this._session);
    }

    public SipSession getSession(boolean create) {
        return this.getSession();
    }

    public Address getTo() {
        return new ReadOnlyAddress((Address)this._fields.get(SipHeader.TO));
    }

    public String getTransport() {
        if (this._connection == null) {
            return null;
        }
        return this._connection.getTransport().getName();
    }

    public Principal getUserPrincipal() {
        if (this._userIdentity != null) {
            return this._userIdentity.getUserPrincipal();
        }
        return null;
    }

    public boolean isCommitted() {
        return this._committed;
    }

    public void setCommitted(boolean b) {
        this._committed = b;
    }

    public boolean isSecure() {
        return false;
    }

    public boolean isUserInRole(String role) {
        if (this._userIdentity != null) {
            return this._userIdentity.isUserInRole(role, (UserIdentity.Scope)this.getHandler());
        }
        return false;
    }

    public void removeAttribute(String name) {
        if (this._attributes != null) {
            this._attributes.removeAttribute(name);
        }
    }

    public void removeHeader(String name) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Message is committed");
        }
        SipHeader header = (SipHeader)SipHeader.CACHE.get(name);
        if (header != null) {
            if (this.isSystemHeader(header)) {
                throw new IllegalArgumentException(name + " is a system header");
            }
            name = header.asString();
        }
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this._fields.remove(name);
    }

    public void setAcceptLanguage(Locale locale) {
        this.setHeader(SipHeader.ACCEPT_LANGUAGE.asString(), locale.toString().replace('_', '-'));
    }

    public void setAddressHeader(String name, Address address) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Message is committed");
        }
        SipHeader header = (SipHeader)SipHeader.CACHE.get(name);
        if (header != null) {
            if (header.getType() != SipHeader.Type.ADDRESS && header.getType() != SipHeader.Type.STRING) {
                throw new IllegalArgumentException("Header: " + name + " is not of address type");
            }
            if (this.isSystemHeader(header)) {
                throw new IllegalArgumentException(name + " is a system header");
            }
            name = header.asString();
        }
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this._fields.set(name, (Object)address);
    }

    public void setAttribute(String name, Object value) {
        if (value == null || name == null) {
            throw new NullPointerException("name or value is null");
        }
        if (this._attributes == null) {
            this._attributes = new AttributesMap();
        }
        this._attributes.setAttribute(name, value);
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        "".getBytes(encoding);
        this._characterEncoding = encoding;
    }

    public void setContent(Object o, String type) throws UnsupportedEncodingException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Is committed");
        }
        if (o == null) {
            this._content = null;
            this.setContentLength(0);
            this.setContentType(type);
        } else if (o instanceof byte[]) {
            this._content = (byte[])o;
            this.setContentLength(this._content.length);
            this.setContentType(type);
        } else if (o instanceof String) {
            String s = (String)o;
            this.setContentType(type);
            String charset = this.getCharacterEncoding();
            if (charset == null) {
                charset = "UTF-8";
            }
            this._content = s.getBytes(charset);
            this.setContentLength(this._content.length);
        } else {
            throw new IllegalArgumentException("Unsupported object type");
        }
    }

    public void setContentLanguage(Locale locale) {
        if (locale == null) {
            this.removeHeader(SipHeader.CONTENT_LANGUAGE.asString());
        } else {
            this.setHeader(SipHeader.CONTENT_LANGUAGE.asString(), locale.toString().replace('_', '-'));
        }
    }

    public void setContentLength(int length) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Message is committed");
        }
        this.setHeader(SipHeader.CONTENT_LENGTH.asString(), Integer.toString(length));
    }

    public void setContentType(String contentType) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Message is committed");
        }
        if (contentType == null) {
            this.getFields().remove(SipHeader.CONTENT_TYPE.asString());
        } else {
            int i1;
            int i0 = contentType.indexOf(59);
            if (i0 > 0 && (i1 = contentType.indexOf("charset=", i0 + 1)) >= 0) {
                int i8 = i1 + 8;
                int i2 = contentType.indexOf(59, i8);
                this._characterEncoding = i2 > 0 ? QuotedStringTokenizer.unquote((String)contentType.substring(i8, i2)) : QuotedStringTokenizer.unquote((String)contentType.substring(i8));
            }
            this.getFields().set(SipHeader.CONTENT_TYPE, (Object)contentType);
        }
    }

    public void setExpires(int seconds) {
        if (seconds < 0) {
            this.removeHeader(SipHeader.EXPIRES.asString());
        } else {
            this.setHeader(SipHeader.EXPIRES.asString(), Long.toString(seconds));
        }
    }

    public void setHeader(String name, String value) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Message is committed");
        }
        SipHeader header = (SipHeader)SipHeader.CACHE.get(name);
        if (this.isSystemHeader(header)) {
            throw new IllegalArgumentException(name + " is a system header");
        }
        if (value == null || name == null) {
            throw new NullPointerException("name or value is null");
        }
        this._fields.set(name, (Object)value);
    }

    public void setHeaderForm(SipServletMessage.HeaderForm form) {
        if (form == null) {
            throw new NullPointerException("Null form");
        }
        this._headerForm = form;
    }

    public void setParameterableHeader(String name, Parameterable parameterable) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Message is committed");
        }
        SipHeader header = (SipHeader)SipHeader.CACHE.get(name);
        if (header != null) {
            if (header.getType() != SipHeader.Type.PARAMETERABLE && header.getType() != SipHeader.Type.ADDRESS && header.getType() != SipHeader.Type.VIA) {
                throw new IllegalArgumentException("Header " + name + " is not of parameterable type");
            }
            if (this.isSystemHeader(header)) {
                throw new IllegalArgumentException(name + " is a system header");
            }
            name = header.asString();
        }
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this._fields.set(name, (Object)parameterable);
    }

    public SipServletHolder getHandler() {
        if (this._handler != null) {
            return this._handler;
        }
        SipServletHolder holder = this.session().getHandler();
        if (holder == null && this.isRequest()) {
            holder = this.appSession().getContext().getServletHandler().getHolder((SipRequest)this);
        }
        return holder;
    }

    public void setHandler(SipServletHolder handler) {
        this._handler = handler;
    }

    public void setInitialRemoteAddr(String initialRemoteAddr) {
        this._initialRemoteAddr = initialRemoteAddr;
    }

    public void setInitialRemotePort(int initialRemotePort) {
        this._initialRemotePort = initialRemotePort;
    }

    public void setInitialTransport(String initialTransport) {
        this._initialTransport = initialTransport;
    }

    public UserIdentity getUserIdentity() {
        return this._userIdentity;
    }

    public void setUserIdentity(UserIdentity userIdentity) {
        this._userIdentity = userIdentity;
    }

    public Via removeTopVia() {
        Via via = (Via)this._fields.removeFirst(SipHeader.VIA);
        return via;
    }
}

