/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server;

import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.EventListener;
import java.util.List;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.servlet.ServletException;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.TimerListener;
import javax.servlet.sip.TimerService;
import javax.servlet.sip.ar.SipApplicationRouter;
import javax.servlet.sip.ar.SipApplicationRouterInfo;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;
import javax.servlet.sip.ar.SipRouteModifier;
import javax.servlet.sip.ar.SipTargetedRequestInfo;
import org.cipango.server.SipServer;
import org.cipango.server.handler.SipContextHandlerCollection;
import org.cipango.server.nio.UdpConnector;
import org.cipango.server.servlet.SipServletHolder;
import org.cipango.server.sipapp.SipAppContext;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.webapp.WebAppContext;

public class Main {
    public static int hashCode(String s) {
        int hash = 5381;
        char[] a = s.toCharArray();
        for (int i = 0; i < a.length; ++i) {
            hash = (hash << 5) + hash + a[i];
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int hashCode2(String s) {
        int hash = 5381;
        byte[] a = s.getBytes();
        for (int i = 0; i < a.length; ++i) {
            hash = (hash << 5) + hash + a[i];
        }
        return hash;
    }

    public static void main(String[] args) throws Exception {
        Main.usingSipContextHandlerCollection();
    }

    public static void usingSipContextHandlerCollection() throws Exception {
        SipServer sipServer = new SipServer();
        boolean jmx = true;
        if (jmx) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            MBeanContainer container = new MBeanContainer(mBeanServer);
            sipServer.addBean(container);
            sipServer.addBean("org.eclipse.jetty.util.log.Log");
        }
        UdpConnector connector = new UdpConnector(sipServer);
        connector.setHost(InetAddress.getLocalHost().getHostName());
        sipServer.addConnector(connector);
        SipAppContext context = new SipAppContext();
        Server server = new Server();
        WebAppContext webAppContext = new WebAppContext();
        webAppContext.setConfigurationClasses(new String[0]);
        webAppContext.setServer(server);
        context.setWebAppContext(webAppContext);
        server.setHandler((Handler)webAppContext);
        server.addBean((Object)sipServer);
        context.getSessionHandler().getSessionManager().setSessionTimeout(1);
        context.setName("Default");
        TestServlet testServlet = new TestServlet();
        SipServletHolder holder = new SipServletHolder();
        holder.setServlet(testServlet);
        holder.setInitOrder(1);
        context.getServletHandler().addServlet(holder);
        context.addEventListener((EventListener)((Object)testServlet));
        HandlerCollection webHandler = new HandlerCollection();
        server.setHandler((Handler)webHandler);
        webHandler.addHandler((Handler)webAppContext);
        SipContextHandlerCollection handler = new SipContextHandlerCollection(webHandler);
        sipServer.setHandler(handler);
        handler.setApplicationRouter(new AppRouter());
        server.start();
    }

    public static void directSipapp() throws Exception {
        SipServer sipServer = new SipServer();
        boolean jmx = true;
        if (jmx) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            MBeanContainer container = new MBeanContainer(mBeanServer);
            sipServer.addBean(container);
            sipServer.addBean("org.eclipse.jetty.util.log.Log");
        }
        UdpConnector connector = new UdpConnector(sipServer);
        connector.setHost(InetAddress.getLocalHost().getHostName());
        sipServer.addConnector(connector);
        SipAppContext context = new SipAppContext();
        Server server = new Server();
        WebAppContext webAppContext = new WebAppContext();
        webAppContext.setConfigurationClasses(new String[0]);
        webAppContext.setServer(server);
        context.setWebAppContext(webAppContext);
        server.setHandler((Handler)webAppContext);
        server.addBean((Object)sipServer);
        context.getSessionHandler().getSessionManager().setSessionTimeout(1);
        context.setName("Default");
        TestServlet testServlet = new TestServlet();
        SipServletHolder holder = new SipServletHolder();
        holder.setServlet(testServlet);
        holder.setInitOrder(1);
        context.getServletHandler().addServlet(holder);
        context.addEventListener((EventListener)((Object)testServlet));
        sipServer.setHandler(context);
        server.start();
    }

    static class TestServlet
    extends SipServlet
    implements TimerListener {
        private TimerService _timerService;

        TestServlet() {
        }

        public void init() {
            this._timerService = (TimerService)this.getServletContext().getAttribute("javax.servlet.sip.TimerService");
        }

        protected void doRequest(SipServletRequest request) throws ServletException, IOException {
            try {
                super.doRequest(request);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        protected void doInvite(SipServletRequest request) throws ServletException, IOException {
            request.getApplicationSession().setAttribute(SipServletRequest.class.getName(), (Object)request);
            this._timerService.createTimer(request.getApplicationSession(), 2000L, false, (Serializable)((Object)request.getSession().getId()));
            request.createResponse(180).send();
        }

        protected void doRegister(SipServletRequest request) throws ServletException, IOException {
            SipServletResponse response = request.createResponse(200);
            response.send();
        }

        protected void doMessage(SipServletRequest request) throws ServletException, IOException {
            SipServletResponse response = request.createResponse(200);
            response.send();
        }

        protected void doOptions(SipServletRequest request) throws ServletException, IOException {
            SipServletResponse response = request.createResponse(200);
            response.send();
        }

        protected void doBye(SipServletRequest request) throws ServletException, IOException {
            request.createResponse(200).send();
            request.getApplicationSession().invalidate();
        }

        protected void doResponse(SipServletResponse response) throws ServletException, IOException {
        }

        public void timeout(ServletTimer timer) {
            SipServletRequest request = (SipServletRequest)timer.getApplicationSession().getAttribute(SipServletRequest.class.getName());
            try {
                request.createResponse(200).send();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static class AppRouter
    implements SipApplicationRouter {
        AppRouter() {
        }

        public void init(Properties arg0) {
        }

        public void init() {
        }

        public SipApplicationRouterInfo getNextApplication(SipServletRequest request, SipApplicationRoutingRegion region, SipApplicationRoutingDirective directive, SipTargetedRequestInfo requestedInfo, Serializable info) {
            return new SipApplicationRouterInfo("Default", SipApplicationRoutingRegion.NEUTRAL_REGION, request.getFrom().getURI().toString(), null, SipRouteModifier.NO_ROUTE, (Serializable)Integer.valueOf(1));
        }

        public void destroy() {
        }

        public void applicationUndeployed(List<String> l) {
        }

        public void applicationDeployed(List<String> l) {
            System.out.println("App deployed: " + l);
        }
    }
}

