/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.server;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.concurrent.Executor;
import javax.servlet.sip.SipURI;
import org.cipango.server.SipConnection;
import org.cipango.server.SipConnector;
import org.cipango.server.SipMessage;
import org.cipango.server.SipRequest;
import org.cipango.server.SipResponse;
import org.cipango.server.SipServer;
import org.cipango.sip.AddressImpl;
import org.cipango.sip.SipHeader;
import org.cipango.sip.SipMethod;
import org.cipango.sip.SipParser;
import org.cipango.sip.SipURIImpl;
import org.cipango.sip.SipVersion;
import org.cipango.sip.URIFactory;
import org.cipango.sip.Via;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="SIP connector")
public abstract class AbstractSipConnector
extends ContainerLifeCycle
implements SipConnector {
    private static final Logger LOG = Log.getLogger(AbstractSipConnector.class);
    private int _port;
    private String _host;
    private SipURI _uri;
    private boolean _transportParamForced = false;
    private Thread[] _acceptors;
    private final SipServer _server;
    private final Executor _executor;

    public AbstractSipConnector(SipServer server, Executor executor, int acceptors) {
        this._server = server;
        this._executor = executor != null ? executor : this._server.getThreadPool();
        this.addBean((Object)this._server, false);
        this.addBean(this._executor);
        if (executor == null) {
            this.unmanage(this._executor);
        }
        if (acceptors <= 0) {
            acceptors = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
        }
        if (acceptors > 2 * Runtime.getRuntime().availableProcessors()) {
            LOG.warn("{}: Acceptors should be <= 2*availableProcessors", new Object[]{this});
        }
        this._acceptors = new Thread[acceptors];
    }

    @Override
    public int getPort() {
        return this._port;
    }

    @Override
    public void setPort(int port) {
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        this._port = port;
    }

    @Override
    public String getHost() {
        return this._host;
    }

    @Override
    public void setHost(String host) {
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        this._host = host;
    }

    public boolean isTransportParamForced() {
        return this._transportParamForced;
    }

    public void setTransportParamForced(boolean forced) {
        this._transportParamForced = forced;
    }

    public Executor getExecutor() {
        return this._executor;
    }

    public SipServer getServer() {
        return this._server;
    }

    @ManagedAttribute(value="Acceptors", readonly=true)
    public int getAcceptors() {
        return this._acceptors.length;
    }

    protected void doStart() throws Exception {
        if (this._port <= 0) {
            this._port = this.getTransport().getDefaultPort();
        }
        if (this._host == null) {
            try {
                this._host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                LOG.ignore((Throwable)e);
                this._host = "127.0.0.1";
            }
        }
        this._uri = new SipURIImpl(this._host, this._port);
        if (this.isTransportParamForced()) {
            this._uri.setTransportParam(this.getTransport().getName().toLowerCase());
        }
        super.doStart();
        this.open();
        for (int i = 0; i < this._acceptors.length; ++i) {
            this.getExecutor().execute(new Acceptor(i));
        }
        LOG.info("Started {}", new Object[]{this});
    }

    protected void doStop() throws Exception {
        try {
            this.close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        if ((this._server == null || this.getExecutor() != this._server.getThreadPool()) && this._executor instanceof LifeCycle) {
            ((LifeCycle)this._executor).stop();
        }
        this.interruptAcceptors();
        super.doStop();
        LOG.info("Stopped {}", new Object[]{this});
    }

    protected void interruptAcceptors() {
        for (Thread thread : this._acceptors) {
            if (thread == null) continue;
            thread.interrupt();
        }
    }

    public void join() throws InterruptedException {
        this.join(0L);
    }

    public void join(long timeout) throws InterruptedException {
        for (Thread thread : this._acceptors) {
            if (thread == null) continue;
            thread.join(timeout);
        }
    }

    @Override
    public SipURI getURI() {
        return this._uri;
    }

    public String toString() {
        String name = this.getClass().getSimpleName();
        return name + "@" + this.getHost() + ":" + this.getPort();
    }

    protected abstract void accept(int var1) throws IOException;

    public static class MessageBuilder
    implements SipParser.SipMessageHandler {
        protected SipServer _server;
        protected SipConnection _connection;
        protected SipMessage _message;

        public MessageBuilder(SipServer server, SipConnection connection) {
            this._server = server;
            this._connection = connection;
        }

        public boolean startRequest(String method, String uri, SipVersion version) throws ParseException {
            SipRequest request = new SipRequest();
            request.setMethod((SipMethod)SipMethod.CACHE.get(method), method);
            request.setRequestURI(URIFactory.parseURI((String)uri));
            this._message = request;
            return false;
        }

        public boolean startResponse(SipVersion version, int status, String reason) throws ParseException {
            SipResponse response = new SipResponse();
            response.setStatus(status, reason);
            this._message = response;
            return false;
        }

        public boolean parsedHeader(SipHeader header, String name, String value) {
            String o = value;
            try {
                if (header != null) {
                    switch (header.getType()) {
                        case VIA: {
                            Via via = new Via(value);
                            via.parse();
                            o = via;
                            break;
                        }
                        case ADDRESS: {
                            AddressImpl addr = new AddressImpl(value);
                            addr.parse();
                            o = addr;
                            break;
                        }
                    }
                }
            }
            catch (ParseException e) {
                LOG.warn((Throwable)e);
                return true;
            }
            if (header != null) {
                name = header.asString();
            }
            if (o == null) {
                o = "";
            }
            this._message.getFields().add(name, (Object)o, false);
            return false;
        }

        public boolean headerComplete() {
            return false;
        }

        public boolean messageComplete(ByteBuffer content) {
            if (content != null) {
                int size = content.limit() - content.position();
                byte[] buffer = new byte[size];
                content.get(buffer, 0, size);
                try {
                    this._message.setContent(buffer, this._message.getContentType());
                }
                catch (UnsupportedEncodingException e) {
                    LOG.ignore((Throwable)e);
                }
            }
            this._message.setConnection(this._connection);
            this._message.setTimeStamp(System.currentTimeMillis());
            if (this._server != null) {
                this._server.process(this._message);
            }
            return true;
        }

        public void badMessage(int status, String reason) {
            LOG.debug("Bad message: {} {}", new Object[]{status, reason});
        }

        public SipMessage getMessage() {
            return this._message;
        }

        protected void reset() {
            this._message = null;
        }
    }

    class Acceptor
    implements Runnable {
        int _acceptor = 0;

        Acceptor(int id) {
            this._acceptor = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread current = Thread.currentThread();
            AbstractSipConnector abstractSipConnector = AbstractSipConnector.this;
            synchronized (abstractSipConnector) {
                ((AbstractSipConnector)AbstractSipConnector.this)._acceptors[this._acceptor] = current;
            }
            String name = AbstractSipConnector.this._acceptors[this._acceptor].getName();
            current.setName(name + " - Acceptor" + this._acceptor + " " + AbstractSipConnector.this);
            int oldPriority = current.getPriority();
            try {
                while (AbstractSipConnector.this.isRunning()) {
                    try {
                        AbstractSipConnector.this.accept(this._acceptor);
                    }
                    catch (IOException ioe) {
                        LOG.ignore((Throwable)ioe);
                    }
                    catch (Exception e) {
                        LOG.warn((Throwable)e);
                    }
                }
            }
            finally {
                current.setPriority(oldPriority);
                current.setName(name);
                try {
                    if (this._acceptor == 0) {
                        AbstractSipConnector.this.close();
                    }
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
                AbstractSipConnector abstractSipConnector2 = AbstractSipConnector.this;
                synchronized (abstractSipConnector2) {
                    ((AbstractSipConnector)AbstractSipConnector.this)._acceptors[this._acceptor] = null;
                }
            }
        }
    }
}

