/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.callflow.diameter;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.cipango.diameter.AVP;
import org.cipango.diameter.node.DiameterAnswer;
import org.cipango.diameter.node.DiameterMessage;

public class DiameterMessageFormator {
    private static DiameterMessageFormator __default = new DiameterMessageFormator(false);
    private static DiameterMessageFormator __pretty = new DiameterMessageFormator(true);
    private boolean _prettyPrint;

    public static DiameterMessageFormator getDefault() {
        return __default;
    }

    public static DiameterMessageFormator getPretty() {
        return __pretty;
    }

    public DiameterMessageFormator(boolean prettyPrint) {
        this._prettyPrint = prettyPrint;
    }

    public Output newOutput() {
        return new OutputImpl();
    }

    public boolean isPrettyPrint() {
        return this._prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this._prettyPrint = prettyPrint;
    }

    public class OutputImpl
    implements Output {
        private StringBuilder _sb = new StringBuilder();
        private int _indexTab;

        @Override
        public void add(String name, Object value) {
            if (value == null) {
                this._sb.append(name).append('\n');
            } else if (name == null && value instanceof Collection) {
                for (Object val : (Collection)value) {
                    this.add(val);
                }
            } else {
                if (DiameterMessageFormator.this._prettyPrint) {
                    for (int i = 0; i < this._indexTab; ++i) {
                        this._sb.append('\t');
                    }
                    ++this._indexTab;
                }
                this._sb.append(name);
                this._sb.append(": ");
                if (value instanceof Boolean) {
                    this._sb.append((Boolean)value != false ? 1 : 0);
                } else if (value instanceof String || value.getClass().isPrimitive()) {
                    this._sb.append(value);
                } else if (value instanceof Date) {
                    this._sb.append(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S'Z'").format((Date)value));
                } else if (value instanceof Collection) {
                    this._sb.append('\n');
                    for (Object val : (Collection)value) {
                        this.add(val);
                    }
                    this._sb.setLength(this._sb.length() - 1);
                } else if (value instanceof byte[]) {
                    byte[] tab = (byte[])value;
                    if (tab[0] == 60 && tab[1] == 63 && tab[2] == 120 && tab[3] == 109 && tab[4] == 108) {
                        this._sb.append(new String(tab));
                    } else {
                        this._sb.append(value);
                    }
                } else {
                    this._sb.append(value);
                }
                if (DiameterMessageFormator.this._prettyPrint) {
                    --this._indexTab;
                    this._sb.append('\n');
                }
            }
        }

        @Override
        public void add(Object value) {
            if (value instanceof Collection) {
                Iterator it = ((Collection)value).iterator();
                ++this._indexTab;
                while (it.hasNext()) {
                    Object val = it.next();
                    this.add(val);
                }
                --this._indexTab;
            } else if (value instanceof DiameterMessage) {
                DiameterMessage message = (DiameterMessage)value;
                StringBuilder sb = new StringBuilder();
                sb.append("[" + message.getApplicationId() + ",");
                sb.append(message.getEndToEndId() + "," + message.getHopByHopId() + "] ");
                sb.append(message.getCommand());
                if (value instanceof DiameterAnswer) {
                    sb.append(" / " + ((DiameterAnswer)message).getResultCode());
                }
                this.add(sb.toString());
                this.add(message.getAVPs());
            } else if (value instanceof AVP) {
                AVP avp = (AVP)value;
                this.add(avp.getType().toString(), avp.getValue());
            } else {
                if (DiameterMessageFormator.this._prettyPrint) {
                    for (int i = 0; i < this._indexTab; ++i) {
                        this._sb.append('\t');
                    }
                    ++this._indexTab;
                }
                if (value instanceof Boolean) {
                    this._sb.append((Boolean)value != false ? 1 : 0);
                } else if (value instanceof String || value.getClass().isPrimitive()) {
                    this._sb.append(value);
                } else if (value instanceof Date) {
                    this._sb.append(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S'Z'").format((Date)value));
                } else {
                    this._sb.append(value);
                }
                if (DiameterMessageFormator.this._prettyPrint) {
                    --this._indexTab;
                    this._sb.append('\n');
                }
            }
        }

        public String toString() {
            return this._sb.toString();
        }
    }

    public static interface Output {
        public void add(Object var1);

        public void add(String var1, Object var2);
    }
}

