/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.callflow;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.cipango.callflow.CallflowNotification;
import org.cipango.callflow.MessageInfo;
import org.cipango.server.SipConnection;
import org.cipango.server.SipMessage;
import org.cipango.server.log.AbstractMessageLog;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="JMX message logger")
public class JmxMessageLog
extends AbstractMessageLog
implements NotificationEmitter {
    private static final Logger LOG = Log.getLogger(JmxMessageLog.class);
    private static final int DEFAULT_MAX_MESSAGES = 100;
    private MessageInfo[] _messages;
    private int _maxMessages = 100;
    private int _cursor;
    private long _messageId = 0L;
    private Map<String, String> _alias = new HashMap<String, String>();
    private List<ListenerInfo> _listeners = new ArrayList<ListenerInfo>();

    @ManagedAttribute
    public int getMaxMessages() {
        return this._maxMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxMessages(int maxMessages) {
        if (maxMessages <= 0) {
            throw new IllegalArgumentException("Max message must be greater than 0");
        }
        JmxMessageLog jmxMessageLog = this;
        synchronized (jmxMessageLog) {
            if (this.isRunning() && maxMessages != this._maxMessages) {
                MessageInfo[] messages = new MessageInfo[maxMessages];
                ListIterator<MessageInfo> it = this.iterate(false);
                int index = maxMessages;
                while (it.hasPrevious()) {
                    messages[--index] = it.previous();
                    if (index != 0) continue;
                }
                this._cursor = 0;
                this._messages = messages;
            }
            this._maxMessages = maxMessages;
        }
    }

    protected void doStart() throws Exception {
        this._messages = new MessageInfo[this._maxMessages];
        this._cursor = 0;
        super.doStart();
    }

    protected void doStop() throws Exception {
        this._messages = null;
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLog(SipMessage message, int direction, SipConnection connection) {
        if (this._messages != null) {
            if (direction == 1 && connection.getLocalAddress().equals(connection.getRemoteAddress()) && connection.getLocalPort() == connection.getRemotePort()) {
                return;
            }
            MessageInfo messageInfo = new MessageInfo(message, direction, connection);
            JmxMessageLog jmxMessageLog = this;
            synchronized (jmxMessageLog) {
                this._messages[this._cursor] = messageInfo;
                this._cursor = this.getNextCursor();
                ++this._messageId;
            }
            if (!this._listeners.isEmpty()) {
                String infoLine;
                JmxMessageLog jmxMessageLog2 = this;
                synchronized (jmxMessageLog2) {
                    infoLine = this.generateInfoLine(direction, connection, System.currentTimeMillis());
                }
                CallflowNotification notification = new CallflowNotification(messageInfo, this._messageId, infoLine);
                this.sendNotification(notification);
            }
        }
    }

    @ManagedOperation(value="Returns the last SIP messages received", impact="INFO")
    public Object[][] getMessages(@Name(value="maxMessages") Integer maxMessages) throws Exception {
        return this.getMessages(maxMessages, null);
    }

    private ListIterator<MessageInfo> iterate(boolean start) {
        return new LogIterator(start);
    }

    private int getNextCursor() {
        return this._cursor + 1 == this._maxMessages ? 0 : this._cursor + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(value="Clear all messages in the logger", impact="ACTION")
    public void clear() {
        if (this._messages == null) {
            return;
        }
        JmxMessageLog jmxMessageLog = this;
        synchronized (jmxMessageLog) {
            for (int i = 0; i < this._messages.length; ++i) {
                this._messages[i] = null;
            }
            this._cursor = 0;
        }
    }

    @ManagedOperation(value="Returns the last SIP messages received matching the filter", impact="INFO")
    public Object[][] getMessages(@Name(value="maxMessages", description="The maximum number of messages to return") Integer maxMessages, @Name(value="msgFilter", description="a JEXL boolean expression to filter messages to display") String msgFilter) throws Exception {
        List<MessageInfo> messages = this.getMessageList(maxMessages, msgFilter);
        Object[][] tab = new Object[messages.size()][3];
        for (int i = 0; i < tab.length; ++i) {
            MessageInfo info = messages.get(i);
            tab[i][0] = this.generateInfoLine(info.getDirection(), info.getConnection(), info.getDate());
            tab[i][1] = info.getMessage();
            tab[i][2] = info.getRemote();
        }
        return tab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MessageInfo> getMessageList(Integer maxMessages, String msgFilter) throws Exception {
        if (this._messages == null) {
            return null;
        }
        JmxMessageLog jmxMessageLog = this;
        synchronized (jmxMessageLog) {
            JexlContext jc = JexlHelper.createContext();
            Expression msgExpression = null;
            if (msgFilter != null && !msgFilter.trim().equals("")) {
                LOG.debug("Get messages with filter: " + msgFilter, new Object[0]);
                msgExpression = ExpressionFactory.createExpression((String)("log." + msgFilter));
            }
            ArrayList<MessageInfo> result = new ArrayList<MessageInfo>();
            ListIterator<MessageInfo> it = this.iterate(false);
            int i = 0;
            while (it.hasPrevious() && i < maxMessages) {
                MessageInfo info = it.previous();
                jc.getVars().put("log", info);
                jc.getVars().put("message", info.getMessage());
                if (msgExpression != null && !((Boolean)msgExpression.evaluate(jc)).booleanValue()) continue;
                result.add(0, info);
                ++i;
            }
            return result;
        }
    }

    public byte[] generateGraph(Integer maxMessages, String msgFilter, String xslUri) throws Exception {
        return this.generateGraph(this.getMessageList(maxMessages, msgFilter), xslUri, false);
    }

    @ManagedOperation(value="Returns the data for generating SVG graph received matching the filter", impact="INFO")
    public byte[] generateGraph(@Name(value="maxMessages", description="The maximum number of messages to return") Integer maxMessages, @Name(value="msgFilter", description="a JEXL boolean expression to filter messages to display") String msgFilter, @Name(value="xslUri", description="URI pointing to the XSL document") String xslUri, @Name(value="includeMsg", description="Include the SIP message") Boolean includeMsg) throws Exception {
        return this.generateGraph(this.getMessageList(maxMessages, msgFilter), xslUri, includeMsg);
    }

    protected byte[] generateGraph(List<MessageInfo> messages, String xslUri, boolean includeMsg) throws IOException {
        MessageInfo info;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        OutputStreamWriter out = new OutputStreamWriter(os);
        out.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        if (xslUri != null) {
            out.write("<?xml-stylesheet href=\"" + xslUri + "\" type=\"text/xsl\"?>\n");
        }
        out.write("<data>\n");
        out.write("\t<hosts>\n");
        HashMap<String, Integer> hostsMap = new HashMap<String, Integer>();
        Iterator<MessageInfo> it = messages.iterator();
        int indexLocal = -1;
        int index = 1;
        while (it.hasNext()) {
            String alias;
            info = it.next();
            if (!hostsMap.containsKey(info.getLocalKey())) {
                if (indexLocal == -1) {
                    out.write("\t\t<host>");
                    alias = this._alias.get(info.getLocalKey());
                    out.write(alias == null ? "Cipango" : alias);
                    out.write("</host>\n");
                    indexLocal = index++;
                }
                hostsMap.put(info.getLocalKey(), indexLocal);
            }
            if (hostsMap.containsKey(info.getRemoteKey())) continue;
            out.write("\t\t<host>");
            alias = this._alias.get(info.getRemoteKey());
            out.write(alias == null ? info.getRemote() : alias);
            out.write("</host>\n");
            hostsMap.put(info.getRemoteKey(), index++);
        }
        out.write("\t</hosts>\n");
        it = messages.iterator();
        out.write("\t<messages>\n");
        while (it.hasNext()) {
            info = it.next();
            out.write("\t\t<message from=\"");
            if (info.getDirection() == 0) {
                out.write(String.valueOf(hostsMap.get(info.getRemoteKey())));
                out.write("\" to=\"");
                out.write(String.valueOf(hostsMap.get(info.getLocalKey())));
                out.write("\">\n");
            } else {
                out.write(String.valueOf(hostsMap.get(info.getLocalKey())));
                out.write("\" to=\"");
                out.write(String.valueOf(hostsMap.get(info.getRemoteKey())));
                out.write("\">\n");
            }
            out.write("\t\t\t<name>");
            out.write(info.getShortName());
            out.write("</name>\n");
            out.write("\t\t\t<date>");
            out.write(info.getFormatedDate());
            out.write("</date>\n");
            if (includeMsg) {
                StringBuilder sb = new StringBuilder(info.getMessage().toString());
                this.replaceAll(sb, "<", "&lt;");
                this.replaceAll(sb, ">", "&gt;");
                String msg = sb.toString();
                int nbLines = 1;
                for (int i = 0; i < msg.length(); ++i) {
                    if (msg.charAt(i) != '\n') continue;
                    ++nbLines;
                }
                out.write("\t\t\t<content nbLines=\"" + nbLines + "\">");
                out.write(msg);
                out.write("</content>\n");
            }
            out.write("\t\t</message>\n");
        }
        out.write("\t</messages>\n");
        out.write("</data>\n");
        out.flush();
        return os.toByteArray();
    }

    protected void replaceAll(StringBuilder sb, String toFind, Object toSet) {
        int index = 0;
        while ((index = sb.indexOf(toFind)) != -1) {
            sb.replace(index, index + toFind.length(), toSet.toString());
        }
    }

    public void addAlias(String host, int port, String name) throws UnknownHostException {
        InetAddress addr = InetAddress.getByName(host);
        this._alias.put(addr.getHostAddress() + ":" + port, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        List<ListenerInfo> list = this._listeners;
        synchronized (list) {
            this._listeners.add(new ListenerInfo(listener, filter, handback));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        List<ListenerInfo> list = this._listeners;
        synchronized (list) {
            Iterator<ListenerInfo> it = this._listeners.iterator();
            while (it.hasNext()) {
                ListenerInfo info = it.next();
                if (!info.listener.equals(listener)) continue;
                it.remove();
                return;
            }
        }
        throw new ListenerNotFoundException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        List<ListenerInfo> list = this._listeners;
        synchronized (list) {
            Iterator<ListenerInfo> it = this._listeners.iterator();
            while (it.hasNext()) {
                ListenerInfo info = it.next();
                if (!info.listener.equals(listener) || info.filter != filter || info.handback != handback) continue;
                it.remove();
                return;
            }
        }
        throw new ListenerNotFoundException();
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{"SIP"};
        String name = MBeanNotificationInfo.class.getName();
        String description = "SIP message notification";
        MBeanNotificationInfo info = new MBeanNotificationInfo(types, name, description);
        return new MBeanNotificationInfo[]{info};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNotification(Notification notification) {
        if (notification == null || this._listeners.isEmpty()) {
            return;
        }
        List<ListenerInfo> list = this._listeners;
        synchronized (list) {
            for (ListenerInfo info : this._listeners) {
                if (info.filter != null && !info.filter.isNotificationEnabled(notification)) continue;
                try {
                    info.listener.handleNotification(notification, info.handback);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
        }
    }

    private class ListenerInfo {
        public NotificationListener listener;
        NotificationFilter filter;
        Object handback;

        public ListenerInfo(NotificationListener listener, NotificationFilter filter, Object handback) {
            this.listener = listener;
            this.filter = filter;
            this.handback = handback;
        }
    }

    private class LogIterator
    implements ListIterator<MessageInfo> {
        private int _itCursor;
        private boolean _start = true;

        public LogIterator(boolean start) {
            this._itCursor = start ? (JmxMessageLog.this._messages[JmxMessageLog.this.getNextCursor()] == null ? 0 : JmxMessageLog.this.getNextCursor()) : JmxMessageLog.this._cursor;
        }

        private int getNextItCursor() {
            return this._itCursor + 1 == JmxMessageLog.this._maxMessages ? 0 : this._itCursor + 1;
        }

        private int getPreviousItCursor() {
            return this._itCursor == 0 ? JmxMessageLog.this._maxMessages - 1 : this._itCursor - 1;
        }

        @Override
        public boolean hasNext() {
            return this._itCursor != JmxMessageLog.this._cursor && JmxMessageLog.this._messages[this.getNextItCursor()] != null;
        }

        @Override
        public MessageInfo next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No next");
            }
            this._itCursor = this.getNextItCursor();
            return JmxMessageLog.this._messages[this._itCursor];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public void add(MessageInfo arg0) {
            throw new UnsupportedOperationException("Read-only");
        }

        @Override
        public boolean hasPrevious() {
            return (this._start || this._itCursor != JmxMessageLog.this._cursor) && JmxMessageLog.this._messages[this.getPreviousItCursor()] != null;
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public MessageInfo previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException("No previous");
            }
            this._start = false;
            this._itCursor = this.getPreviousItCursor();
            return JmxMessageLog.this._messages[this._itCursor];
        }

        @Override
        public int previousIndex() {
            return 0;
        }

        @Override
        public void set(MessageInfo arg0) {
            throw new UnsupportedOperationException("Read-only");
        }
    }
}

