/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.util;

public class TimerTask
implements Comparable<TimerTask> {
    private Runnable _runnable;
    private long _executionTime;
    private boolean _cancelled = false;

    public TimerTask(Runnable runnable, long executionTime) {
        this._runnable = runnable;
        this._executionTime = executionTime;
    }

    public long getExecutionTime() {
        return this._executionTime;
    }

    public Runnable getRunnable() {
        return this._runnable;
    }

    @Override
    public int compareTo(TimerTask task) {
        long otherExecutionTime = task._executionTime;
        return this._executionTime < otherExecutionTime ? -1 : (this._executionTime == otherExecutionTime ? 0 : 1);
    }

    public boolean isCancelled() {
        return this._cancelled;
    }

    public void cancel() {
        this._cancelled = true;
        if (this._runnable instanceof Cancelable) {
            ((Cancelable)((Object)this._runnable)).cancel();
        }
    }

    public String toString() {
        long delay = this._executionTime - System.currentTimeMillis();
        if (delay > 1000L || delay < -1000L) {
            return this._runnable + "@" + (this._executionTime - System.currentTimeMillis()) / 1000L + "s";
        }
        return this._runnable + "@" + (this._executionTime - System.currentTimeMillis()) + "ms";
    }

    public static interface Cancelable {
        public void cancel();
    }
}

